/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

final class JAXPValidationMessageFormatter {
    JAXPValidationMessageFormatter() {
    }

    public static String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        String msg;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.JAXPValidationMessages", locale);
        try {
            msg = resourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format(msg, arguments);
                }
                catch (Exception e2) {
                    msg = resourceBundle.getString("FormatFailed");
                    msg = msg + " " + resourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e3) {
            String msg2 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg == null) {
            msg = key;
            if (arguments.length > 0) {
                StringBuffer str2 = new StringBuffer(msg);
                str2.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str2.append('&');
                    }
                    str2.append(String.valueOf(arguments[i]));
                }
            }
        }
        return msg;
    }
}

