/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseJSONFile
extends AbstractJsonFile {
    private boolean deprecated;
    private SpdxListedLicense license;

    public void setLicense(SpdxListedLicense license, boolean deprecated) {
        this.license = license;
        this.deprecated = deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    private Object isDeprecated() {
        return this.deprecated;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("licenseId", this.license.getLicenseId());
        jsonObject.put("isOsiApproved", this.license.isOsiApproved());
        if (this.license.getFsfLibre() != null) {
            jsonObject.put("isFsfLibre", this.license.isFsfLibre());
        }
        jsonObject.put("name", this.license.getName());
        String[] seeAlsos = this.license.getSeeAlso();
        if (seeAlsos != null && seeAlsos.length > 0) {
            JSONArray seeAlsoArray = new JSONArray();
            for (String seeAlso : seeAlsos) {
                seeAlsoArray.add(seeAlso);
            }
            jsonObject.put("seeAlso", seeAlsoArray);
        }
        if (this.license.getComment() != null && !this.license.getComment().isEmpty()) {
            jsonObject.put("licenseComments", this.license.getComment());
        }
        if (this.license.getLicenseText() != null) {
            jsonObject.put("licenseText", this.license.getLicenseText().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
        }
        if (this.license.getStandardLicenseHeader() != null) {
            jsonObject.put("standardLicenseHeader", this.license.getStandardLicenseHeader().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            if (this.license.getStandardLicenseHeaderTemplate() != null) {
                jsonObject.put("standardLicenseHeaderTemplate", this.license.getStandardLicenseHeaderTemplate().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            } else {
                jsonObject.put("standardLicenseHeaderTemplate", this.license.getStandardLicenseHeader().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            }
        }
        if (this.license.getStandardLicenseTemplate() != null) {
            jsonObject.put("standardLicenseTemplate", this.license.getStandardLicenseTemplate().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
        }
        jsonObject.put("isDeprecatedLicenseId", this.isDeprecated());
        return jsonObject;
    }
}

