/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class AnnotationsSheet
extends AbstractSheet {
    static final int ID_COL = 0;
    static final int COMMENT_COL = 1;
    static final int DATE_COL = 2;
    static final int ANNOTATOR_COL = 3;
    static final int TYPE_COL = 4;
    static final int USER_DEFINED_COL = 5;
    static final int NUM_COLS = 5;
    static final String[] HEADER_TITLES = new String[]{"SPDX Identifier being Annotated", "Annotation Comment", "Annotation Date", "Annotator", "Annotation Type", "Optional User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{25, 70, 25, 60, 20, 50};
    static final boolean[] LEFT_WRAP = new boolean[]{false, true, false, true, false, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, false, true, false, true, false};
    static final boolean[] REQUIRED = new boolean[]{true, true, true, true, true, false};

    public AnnotationsSheet(Workbook workbook, String annotationsSheetName) {
        super(workbook, annotationsSheetName);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for Annotations does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 5; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for Annotation worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying Annotations worksheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 5; ++i) {
            Annotation.AnnotationType type;
            Cell cell = row.getCell(i);
            if (REQUIRED[i] && cell == null) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum()) + " in annotation sheet";
            }
            if (i != 4 || cell.getStringCellValue() == null || (type = Annotation.AnnotationType.fromTag(cell.getStringCellValue())) != null) continue;
            return "Invalid annotation type in row " + String.valueOf(row) + ": " + cell.getStringCellValue();
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void add(Annotation annotation, String elementId) {
        Row row = this.addRow();
        if (elementId != null) {
            Cell idCell = row.createCell(0, CellType.STRING);
            idCell.setCellValue(elementId);
        }
        if (annotation.getComment() != null) {
            row.createCell(1).setCellValue(annotation.getComment());
        }
        if (annotation.getAnnotationDate() != null) {
            row.createCell(2).setCellValue(annotation.getAnnotationDate());
        }
        if (annotation.getAnnotator() != null) {
            row.createCell(3).setCellValue(annotation.getAnnotator());
        }
        if (annotation.getAnnotationType() != null) {
            row.createCell(4).setCellValue(annotation.getAnnotationType().getTag());
        }
    }

    public String getElmementId(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return row.getCell(0).getStringCellValue();
    }

    public Annotation getAnnotation(int rowNum) throws SpreadsheetException {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String comment = null;
        Cell commentCell = row.getCell(1);
        if (commentCell != null) {
            comment = commentCell.getStringCellValue();
        }
        String date2 = null;
        Cell dateCell = row.getCell(2);
        if (dateCell != null) {
            date2 = dateCell.getStringCellValue();
        }
        String annotator = null;
        Cell annotatorCell = row.getCell(3);
        if (annotatorCell != null) {
            annotator = annotatorCell.getStringCellValue();
        }
        Annotation.AnnotationType type = null;
        Cell typeCell = row.getCell(4);
        if (typeCell != null) {
            type = Annotation.AnnotationType.fromTag(typeCell.getStringCellValue().trim());
        }
        return new Annotation(annotator, type, date2, comment);
    }
}

