/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.spdx.compare.SpdxCompareException;
import org.spdx.merge.SpdxFileInfoMerger;
import org.spdx.merge.SpdxLicenseInfoMerger;
import org.spdx.merge.SpdxLicenseMapper;
import org.spdx.merge.SpdxPackageInfoMerger;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;
import org.spdx.tools.CompareSpdxDocs;

public class MergeSpdxDocs {
    static final int MIN_ARGS = 2;
    static final int ERROR_STATUS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileOutputStream out;
        File spdxRdfFile;
        if (args.length < 2) {
            System.out.println("Insufficient arguments");
            MergeSpdxDocs.usage();
            System.exit(1);
        }
        if ((spdxRdfFile = new File(args[args.length - 1])).exists()) {
            System.out.println("Output file " + args[args.length - 1] + " already exist");
            System.exit(1);
        }
        SpdxDocument[] mergeDocs = new SpdxDocument[args.length - 1];
        String[] docNames = new String[args.length - 1];
        List[] verficationError = new List[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            try {
                ArrayList<String> warnings = new ArrayList<String>();
                mergeDocs[i] = CompareSpdxDocs.openRdfOrTagDoc(args[i], warnings);
                if (!warnings.isEmpty()) {
                    System.out.println("Verification errors were found in " + args[i].trim() + ":");
                    if (!warnings.isEmpty()) {
                        System.out.println("The following warnings and or verification errors were found:");
                        for (String warning : warnings) {
                            System.out.println("\t" + warning);
                        }
                    }
                }
                docNames[i] = CompareSpdxDocs.convertDocName(args[i]);
                verficationError[i] = mergeDocs[i].verify();
                if (verficationError[i] == null || verficationError[i].size() <= 0) continue;
                System.out.println("Warning: " + docNames[i] + " contains verfication errors.");
                continue;
            }
            catch (SpdxCompareException e2) {
                System.out.println("Error opening SPDX document " + args[i] + " : " + e2.getMessage());
                System.exit(1);
            }
        }
        SpdxDocument master = mergeDocs[0];
        SpdxDocument[] subDocs = new SpdxDocument[mergeDocs.length - 1];
        for (int k = 0; k < subDocs.length; ++k) {
            subDocs[k] = mergeDocs[k + 1];
        }
        try {
            out = new FileOutputStream(spdxRdfFile);
        }
        catch (FileNotFoundException e3) {
            System.out.println("Could not write to the new SPDX RDF file " + args[args.length - 1]);
            System.out.println("due to error " + e3.getMessage());
            MergeSpdxDocs.usage();
            return;
        }
        SpdxDocument outputDoc = null;
        String masterDocUri = master.getDocumentContainer().getDocumentNamespace();
        Model model = null;
        if (masterDocUri.endsWith("#")) {
            masterDocUri = masterDocUri.substring(0, masterDocUri.length() - 1);
        }
        String outputDocURI = masterDocUri + "-merged";
        try {
            SpdxDocumentContainer container2 = new SpdxDocumentContainer(outputDocURI);
            outputDoc = container2.getSpdxDocument();
            model = container2.getModel();
        }
        catch (InvalidSPDXAnalysisException e1) {
            System.out.print("Error creating SPDX Analysis: " + e1.getMessage());
            try {
                out.close();
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
            return;
        }
        List<SpdxPackage> packageInfoResult = null;
        try {
            packageInfoResult = master.getDocumentContainer().findAllPackages();
        }
        catch (InvalidSPDXAnalysisException e1) {
            System.out.println("Error obtaining master's packages: " + e1.getMessage());
        }
        ExtractedLicenseInfo[] licInfoResult = null;
        SpdxLicenseMapper licenseMapper = new SpdxLicenseMapper();
        try {
            SpdxLicenseInfoMerger nonStandardLicMerger = new SpdxLicenseInfoMerger(outputDoc, licenseMapper);
            licInfoResult = nonStandardLicMerger.mergeNonStdLic(subDocs);
        }
        catch (InvalidSPDXAnalysisException e5) {
            System.out.println("Error merging documents' SPDX Non-standard License Information: " + e5.getMessage());
            System.exit(1);
        }
        SpdxFile[] fileInfoResult = null;
        try {
            SpdxFileInfoMerger fileInfoMerger = new SpdxFileInfoMerger(master, licenseMapper);
            fileInfoResult = fileInfoMerger.mergeFileInfo(subDocs);
        }
        catch (InvalidSPDXAnalysisException e6) {
            System.out.println("Error merging SPDX files' Information: " + e6.getMessage());
            System.exit(1);
        }
        try {
            SpdxPackageInfoMerger packInfoMerger = new SpdxPackageInfoMerger(packageInfoResult, subDocs, licenseMapper);
            try {
                packInfoMerger.mergePackagesInfo(fileInfoResult);
            }
            catch (NoSuchAlgorithmException e7) {
                System.out.println("Error merging packages' information: " + e7.getMessage());
            }
            catch (InvalidLicenseStringException e8) {
                System.out.println("Error on package's license string " + e8.getMessage());
            }
        }
        catch (InvalidSPDXAnalysisException e9) {
            System.out.println("Error merging SPDX Non-standard License Information: " + e9.getMessage());
            System.exit(1);
        }
        try {
            SPDXReview[] reviewInfoResult = new SPDXReview[]{};
            outputDoc.setReviewers(reviewInfoResult);
            outputDoc.setSpecVersion(master.getSpecVersion());
            outputDoc.setCreationInfo(master.getCreationInfo());
            outputDoc.setComment(master.getComment());
            outputDoc.setDataLicense(master.getDataLicense());
            outputDoc.setExtractedLicenseInfos(licInfoResult);
        }
        catch (InvalidSPDXAnalysisException e10) {
            System.out.println("Error to set merged information into output document " + e10.getMessage());
            try {
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return;
        }
        try {
            model.write(out, "RDF/XML-ABBREV");
        }
        catch (Exception e11) {
            System.out.println("Error writing to the output file " + e11.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e12) {
                    System.out.println("Error closing RDF file: " + e12.getMessage());
                }
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: doc1 doc2 doc3...[output]");
        System.out.println("where doc1, doc2, doc3... is a serial of vaild SPDX documents in RDF/XML format");
        System.out.println("[output] is a vaild name for output document");
        System.out.println("Note: the doc1 will be used as master document to build the finail output document ");
    }
}

