/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.ARQInternalErrorException;

public class ClsLoader {
    public static Class<?> loadClass(String classNameOrURI) {
        return ClsLoader.loadClass(classNameOrURI, null);
    }

    public static Class<?> loadClass(String classNameOrURI, Class<?> requiredClass) {
        Class<?> classObj;
        String className;
        block9: {
            if (classNameOrURI == null) {
                throw new ARQInternalErrorException("Null classNameorIRI");
            }
            if (classNameOrURI.startsWith("http:")) {
                return null;
            }
            if (classNameOrURI.startsWith("urn:")) {
                return null;
            }
            className = classNameOrURI;
            if (classNameOrURI.startsWith("java:")) {
                className = classNameOrURI.substring("java:".length());
            }
            classObj = null;
            try {
                classObj = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                String baseUri = className.substring(0, className.lastIndexOf(46) + 1);
                String escapedClassName = ClsLoader.escape(className.substring(className.lastIndexOf(46) + 1));
                try {
                    classObj = Class.forName(baseUri + escapedClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (classObj != null) break block9;
                Log.warn(ClsLoader.class, "Class not found: " + className);
                return null;
            }
        }
        if (requiredClass != null && !requiredClass.isAssignableFrom(classObj)) {
            Log.warn(ClsLoader.class, "Class '" + className + "' found but not a " + Lib.classShortName(requiredClass));
            return null;
        }
        return classObj;
    }

    public static Object loadAndInstantiate(String uri, Class<?> requiredClass) {
        Class<?> classObj = ClsLoader.loadClass(uri, requiredClass);
        if (classObj == null) {
            return null;
        }
        Object module = null;
        try {
            module = classObj.newInstance();
        }
        catch (Exception ex) {
            String className = uri.substring("java:".length());
            Log.warn(ClsLoader.class, "Exception during instantiation '" + className + "': " + ex.getMessage());
            return null;
        }
        return module;
    }

    public static String escape(String className) {
        int cp;
        StringBuilder builder = new StringBuilder();
        boolean upgrade = false;
        for (int offset = 0; offset < className.length(); offset += Character.charCount(cp)) {
            cp = className.codePointAt(offset);
            if (builder.length() == 0) {
                if (Character.isJavaIdentifierStart(cp)) {
                    builder.append(Character.toChars(cp));
                    continue;
                }
                builder.append("F_");
                continue;
            }
            if (Character.isJavaIdentifierPart(cp)) {
                if (upgrade) {
                    cp = Character.toUpperCase(cp);
                    upgrade = false;
                }
                builder.append(Character.toChars(cp));
                continue;
            }
            upgrade = true;
        }
        return builder.toString();
    }
}

