/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TransactionHandlerView;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;

public class GraphViewSwitchable
extends GraphView {
    private final DatasetGraphSwitchable dsgx;
    private TransactionHandler transactionHandler = null;

    public static GraphViewSwitchable createDefaultGraph(DatasetGraphSwitchable dsg) {
        return new GraphViewSwitchable(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraph(DatasetGraphSwitchable dsg, Node graphIRI) {
        return new GraphViewSwitchable(dsg, graphIRI);
    }

    public static GraphViewSwitchable createUnionGraph(DatasetGraphSwitchable dsg) {
        return new GraphViewSwitchable(dsg, Quad.unionGraph);
    }

    protected DatasetGraphSwitchable getx() {
        return this.dsgx;
    }

    protected GraphViewSwitchable(DatasetGraphSwitchable dsg, Node gn) {
        super(dsg, gn);
        this.dsgx = dsg;
        this.transactionHandler = new TransactionHandlerView(this.dsgx);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        Node gn = super.getGraphName();
        if (gn == Quad.defaultGraphNodeGenerated) {
            gn = null;
        }
        if (Quad.isUnionGraph(gn)) {
            PrefixMappingImpl pmap = new PrefixMappingImpl();
            pmap.setNsPrefixes(this.prefixMapping(null));
            return pmap;
        }
        return this.prefixMapping(gn);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    @Override
    public DatasetGraphSwitchable getDataset() {
        return this.getx();
    }

    public Graph getBaseGraph() {
        if (this.getGraphName() == null) {
            return this.getDSG().getDefaultGraph();
        }
        return this.getDSG().getGraph(this.getGraphName());
    }

    @Override
    protected int graphBaseSize() {
        if (this.isDefaultGraph()) {
            return this.getDSG().getDefaultGraphTDB().size();
        }
        return this.getDSG().getGraphTDB(this.getGraphName()).size();
    }

    private DatasetGraphTDB getDSG() {
        return (DatasetGraphTDB)this.getx().get();
    }

    private PrefixMapping prefixMapping(Node graphName) {
        return new PrefixMappingImplTDB2(graphName);
    }

    class PrefixMappingImplTDB2
    extends PrefixMappingImpl {
        private final String gn;
        private final Node graphName;

        PrefixMappingImplTDB2(Node graphName) {
            this.graphName = graphName;
            if (graphName != null) {
                graphName = NodeFunctions.blankNodeToIri(graphName);
                this.gn = graphName.getURI();
            } else {
                this.gn = "";
            }
        }

        private DatasetPrefixStorage dps() {
            return GraphViewSwitchable.this.getDSG().getPrefixes();
        }

        private PrefixMapping prefixMapping() {
            if (this.gn == null) {
                return this.dps().getPrefixMapping();
            }
            return this.dps().getPrefixMapping(this.gn);
        }

        @Override
        protected void set(String prefix, String uri) {
            this.dps().insertPrefix(this.gn, prefix, uri);
            super.set(prefix, uri);
        }

        @Override
        protected String get(String prefix) {
            return this.dps().readPrefix(this.gn, prefix);
        }

        @Override
        protected void remove(String prefix) {
            this.dps().getPrefixMapping().removeNsPrefix(prefix);
            super.remove(prefix);
        }

        @Override
        public Map<String, String> getNsPrefixMap() {
            return this.prefixMapping().getNsPrefixMap();
        }
    }
}

