/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.dsig;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.dsig.DigestInfo;
import org.apache.poi.poifs.crypt.dsig.KeyInfoKeySelector;
import org.apache.poi.poifs.crypt.dsig.SignatureConfig;
import org.apache.poi.poifs.crypt.dsig.SignatureMarshalListener;
import org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.services.RelationshipTransformService;
import org.apache.poi.util.DocumentHelper;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2000.x09.xmldsig.SignatureDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.SAXException;

public class SignatureInfo
implements SignatureConfig.SignatureConfigurable {
    private static final POILogger LOG = POILogFactory.getLogger(SignatureInfo.class);
    private static boolean isInitialized = false;
    private SignatureConfig signatureConfig;

    public SignatureInfo() {
        SignatureInfo.initXmlProvider();
    }

    public SignatureConfig getSignatureConfig() {
        return this.signatureConfig;
    }

    @Override
    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }

    public boolean verifySignature() {
        Iterator<SignaturePart> i$ = this.getSignatureParts().iterator();
        if (i$.hasNext()) {
            SignaturePart sp = i$.next();
            return sp.validate();
        }
        return false;
    }

    public void confirmSignature() throws XMLSignatureException, MarshalException {
        Document document = DocumentHelper.createDocument();
        DigestInfo digestInfo = this.preSign(document, null);
        byte[] signatureValue = this.signDigest(digestInfo.digestValue);
        this.postSign(document, signatureValue);
    }

    public byte[] signDigest(byte[] digest) {
        Cipher cipher = CryptoFunctions.getCipher(this.signatureConfig.getKey(), CipherAlgorithm.rsa, ChainingMode.ecb, null, 1, "PKCS1Padding");
        try {
            ByteArrayOutputStream digestInfoValueBuf = new ByteArrayOutputStream();
            digestInfoValueBuf.write(this.signatureConfig.getHashMagic());
            digestInfoValueBuf.write(digest);
            byte[] digestInfoValue = digestInfoValueBuf.toByteArray();
            byte[] signatureValue = cipher.doFinal(digestInfoValue);
            return signatureValue;
        }
        catch (Exception e2) {
            throw new EncryptedDocumentException(e2);
        }
    }

    public Iterable<SignaturePart> getSignatureParts() {
        this.signatureConfig.init(true);
        return new Iterable<SignaturePart>(){

            @Override
            public Iterator<SignaturePart> iterator() {
                return new Iterator<SignaturePart>(){
                    OPCPackage pkg;
                    Iterator<PackageRelationship> sigOrigRels;
                    Iterator<PackageRelationship> sigRels;
                    PackagePart sigPart;
                    {
                        this.pkg = SignatureInfo.this.signatureConfig.getOpcPackage();
                        this.sigOrigRels = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin").iterator();
                        this.sigRels = null;
                        this.sigPart = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.sigRels == null || !this.sigRels.hasNext()) {
                            if (!this.sigOrigRels.hasNext()) {
                                return false;
                            }
                            this.sigPart = this.pkg.getPart(this.sigOrigRels.next());
                            LOG.log(1, "Digital Signature Origin part", this.sigPart);
                            try {
                                this.sigRels = this.sigPart.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature").iterator();
                            }
                            catch (InvalidFormatException e2) {
                                LOG.log(5, new Object[]{"Reference to signature is invalid.", e2});
                            }
                        }
                        return true;
                    }

                    @Override
                    public SignaturePart next() {
                        PackagePart sigRelPart = null;
                        do {
                            try {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                sigRelPart = this.sigPart.getRelatedPart(this.sigRels.next());
                                LOG.log(1, "XML Signature part", sigRelPart);
                            }
                            catch (InvalidFormatException e2) {
                                LOG.log(5, new Object[]{"Reference to signature is invalid.", e2});
                            }
                        } while (this.sigPart == null);
                        return new SignaturePart(sigRelPart);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected static synchronized void initXmlProvider() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        try {
            Init.init();
            RelationshipTransformService.registerDsigProvider();
            CryptoFunctions.registerBouncyCastle();
        }
        catch (Exception e2) {
            throw new RuntimeException("Xml & BouncyCastle-Provider initialization failed", e2);
        }
    }

    public DigestInfo preSign(Document document, List<DigestInfo> digestInfos) throws XMLSignatureException, MarshalException {
        SignedInfo signedInfo;
        this.signatureConfig.init(false);
        EventTarget target = (EventTarget)((Object)document);
        EventListener creationListener = this.signatureConfig.getSignatureMarshalListener();
        if (creationListener != null) {
            if (creationListener instanceof SignatureMarshalListener) {
                ((SignatureMarshalListener)creationListener).setEventTarget(target);
            }
            SignatureMarshalListener.setListener(target, creationListener, true);
        }
        DOMSignContext xmlSignContext = new DOMSignContext(this.signatureConfig.getKey(), (Node)document);
        URIDereferencer uriDereferencer = this.signatureConfig.getUriDereferencer();
        if (null != uriDereferencer) {
            xmlSignContext.setURIDereferencer(uriDereferencer);
        }
        for (Map.Entry<String, String> me : this.signatureConfig.getNamespacePrefixes().entrySet()) {
            xmlSignContext.putNamespacePrefix(me.getKey(), me.getValue());
        }
        xmlSignContext.setDefaultNamespacePrefix("");
        this.brokenJvmWorkaround(xmlSignContext);
        XMLSignatureFactory signatureFactory = this.signatureConfig.getSignatureFactory();
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (DigestInfo digestInfo : SignatureInfo.safe(digestInfos)) {
            byte[] documentDigestValue = digestInfo.digestValue;
            String uri = new File(digestInfo.description).getName();
            Reference reference = SignatureFacet.newReference(uri, null, null, null, documentDigestValue, this.signatureConfig);
            references.add(reference);
        }
        ArrayList<XMLObject> objects = new ArrayList<XMLObject>();
        for (SignatureFacet signatureFacet : this.signatureConfig.getSignatureFacets()) {
            LOG.log(1, new Object[]{"invoking signature facet: " + signatureFacet.getClass().getSimpleName()});
            signatureFacet.preSign(document, references, objects);
        }
        try {
            SignatureMethod signatureMethod = signatureFactory.newSignatureMethod(this.signatureConfig.getSignatureMethodUri(), null);
            CanonicalizationMethod canonicalizationMethod = signatureFactory.newCanonicalizationMethod(this.signatureConfig.getCanonicalizationMethod(), (C14NMethodParameterSpec)null);
            signedInfo = signatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, references);
        }
        catch (GeneralSecurityException e2) {
            throw new XMLSignatureException(e2);
        }
        String signatureValueId = this.signatureConfig.getPackageSignatureId() + "-signature-value";
        XMLSignature xmlSignature = signatureFactory.newXMLSignature(signedInfo, null, objects, this.signatureConfig.getPackageSignatureId(), signatureValueId);
        xmlSignature.sign(xmlSignContext);
        for (XMLObject object : objects) {
            LOG.log(1, new Object[]{"object java type: " + object.getClass().getName()});
            List<XMLStructure> objectContentList = object.getContent();
            for (XMLStructure objectContent : objectContentList) {
                LOG.log(1, new Object[]{"object content java type: " + objectContent.getClass().getName()});
                if (!(objectContent instanceof Manifest)) continue;
                Manifest manifest = (Manifest)objectContent;
                List<Reference> manifestReferences = manifest.getReferences();
                for (Reference manifestReference : manifestReferences) {
                    if (manifestReference.getDigestValue() != null) continue;
                    DOMReference manifestDOMReference = (DOMReference)manifestReference;
                    manifestDOMReference.digest((XMLSignContext)xmlSignContext);
                }
            }
        }
        List<Reference> signedInfoReferences = signedInfo.getReferences();
        for (Reference signedInfoReference : signedInfoReferences) {
            DOMReference domReference = (DOMReference)signedInfoReference;
            if (domReference.getDigestValue() != null) continue;
            domReference.digest((XMLSignContext)xmlSignContext);
        }
        DOMSignedInfo domSignedInfo = (DOMSignedInfo)signedInfo;
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        domSignedInfo.canonicalize((XMLCryptoContext)xmlSignContext, dataStream);
        byte[] octets = dataStream.toByteArray();
        MessageDigest md = CryptoFunctions.getMessageDigest(this.signatureConfig.getDigestAlgo());
        byte[] digestValue = md.digest(octets);
        String description = this.signatureConfig.getSignatureDescription();
        return new DigestInfo(digestValue, this.signatureConfig.getDigestAlgo(), description);
    }

    public void postSign(Document document, byte[] signatureValue) throws MarshalException {
        LOG.log(1, new Object[]{"postSign"});
        String signatureId = this.signatureConfig.getPackageSignatureId();
        if (!signatureId.equals(document.getDocumentElement().getAttribute("Id"))) {
            throw new RuntimeException("ds:Signature not found for @Id: " + signatureId);
        }
        NodeList sigValNl = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        if (sigValNl.getLength() != 1) {
            throw new RuntimeException("preSign has to be called before postSign");
        }
        sigValNl.item(0).setTextContent(Base64.encode((byte[])signatureValue));
        for (SignatureFacet signatureFacet : this.signatureConfig.getSignatureFacets()) {
            signatureFacet.postSign(document);
        }
        this.writeDocument(document);
    }

    protected void writeDocument(Document document) throws MarshalException {
        PackagePartName sigsPartName;
        PackagePartName sigPartName;
        XmlOptions xo = new XmlOptions();
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.signatureConfig.getNamespacePrefixes().entrySet()) {
            namespaceMap.put(entry.getValue(), entry.getKey());
        }
        xo.setSaveSuggestedPrefixes(namespaceMap);
        xo.setUseDefaultNamespace();
        LOG.log(1, new Object[]{"output signed Office OpenXML document"});
        OPCPackage pkg = this.signatureConfig.getOpcPackage();
        try {
            sigPartName = PackagingURIHelper.createPartName("/_xmlsignatures/sig1.xml");
            sigsPartName = PackagingURIHelper.createPartName("/_xmlsignatures/origin.sigs");
        }
        catch (InvalidFormatException e2) {
            throw new MarshalException(e2);
        }
        PackagePart sigPart = pkg.getPart(sigPartName);
        if (sigPart == null) {
            sigPart = pkg.createPart(sigPartName, "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml");
        }
        try {
            OutputStream os = sigPart.getOutputStream();
            SignatureDocument sigDoc = SignatureDocument.Factory.parse(document, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            sigDoc.save(os, xo);
            os.close();
        }
        catch (Exception e3) {
            throw new MarshalException("Unable to write signature document", e3);
        }
        PackagePart sigsPart = pkg.getPart(sigsPartName);
        if (sigsPart == null) {
            sigsPart = pkg.createPart(sigsPartName, "application/vnd.openxmlformats-package.digital-signature-origin");
        }
        PackageRelationshipCollection relCol = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        for (PackageRelationship pr : relCol) {
            pkg.removeRelationship(pr.getId());
        }
        pkg.addRelationship(sigsPartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        sigsPart.addRelationship(sigPartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
    }

    private static <T> List<T> safe(List<T> other) {
        List emptyList = Collections.emptyList();
        return other == null ? emptyList : other;
    }

    private void brokenJvmWorkaround(XMLSignContext context) {
        Provider bcProv = Security.getProvider("BC");
        if (bcProv != null) {
            context.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", bcProv);
        }
    }

    private void brokenJvmWorkaround(XMLValidateContext context) {
        Provider bcProv = Security.getProvider("BC");
        if (bcProv != null) {
            context.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", bcProv);
        }
    }

    public class SignaturePart {
        private final PackagePart signaturePart;
        private X509Certificate signer;
        private List<X509Certificate> certChain;

        private SignaturePart(PackagePart signaturePart) {
            this.signaturePart = signaturePart;
        }

        public PackagePart getPackagePart() {
            return this.signaturePart;
        }

        public X509Certificate getSigner() {
            return this.signer;
        }

        public List<X509Certificate> getCertChain() {
            return this.certChain;
        }

        public SignatureDocument getSignatureDocument() throws IOException, XmlException {
            return SignatureDocument.Factory.parse(this.signaturePart.getInputStream(), POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        }

        public boolean validate() {
            KeyInfoKeySelector keySelector = new KeyInfoKeySelector();
            try {
                Document doc = DocumentHelper.readDocument(this.signaturePart.getInputStream());
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList nl = (NodeList)xpath.compile("//*[@Id]").evaluate(doc, XPathConstants.NODESET);
                int length = nl.getLength();
                for (int i = 0; i < length; ++i) {
                    ((Element)nl.item(i)).setIdAttribute("Id", true);
                }
                DOMValidateContext domValidateContext = new DOMValidateContext(keySelector, (Node)doc);
                domValidateContext.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
                domValidateContext.setURIDereferencer(SignatureInfo.this.signatureConfig.getUriDereferencer());
                SignatureInfo.this.brokenJvmWorkaround(domValidateContext);
                XMLSignatureFactory xmlSignatureFactory = SignatureInfo.this.signatureConfig.getSignatureFactory();
                XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
                for (Reference ref : xmlSignature.getSignedInfo().getReferences()) {
                    SignatureFacet.brokenJvmWorkaround(ref);
                }
                for (XMLObject xo : xmlSignature.getObjects()) {
                    for (XMLStructure xs : xo.getContent()) {
                        if (!(xs instanceof Manifest)) continue;
                        for (Reference ref : ((Manifest)xs).getReferences()) {
                            SignatureFacet.brokenJvmWorkaround(ref);
                        }
                    }
                }
                boolean valid = xmlSignature.validate(domValidateContext);
                if (valid) {
                    this.signer = keySelector.getSigner();
                    this.certChain = keySelector.getCertChain();
                }
                return valid;
            }
            catch (IOException e2) {
                String s = "error in reading document";
                LOG.log(7, new Object[]{s, e2});
                throw new EncryptedDocumentException(s, e2);
            }
            catch (SAXException e3) {
                String s = "error in parsing document";
                LOG.log(7, new Object[]{s, e3});
                throw new EncryptedDocumentException(s, e3);
            }
            catch (XPathExpressionException e4) {
                String s = "error in searching document with xpath expression";
                LOG.log(7, new Object[]{s, e4});
                throw new EncryptedDocumentException(s, e4);
            }
            catch (MarshalException e5) {
                String s = "error in unmarshalling the signature";
                LOG.log(7, new Object[]{s, e5});
                throw new EncryptedDocumentException(s, e5);
            }
            catch (XMLSignatureException e6) {
                String s = "error in validating the signature";
                LOG.log(7, new Object[]{s, e6});
                throw new EncryptedDocumentException(s, e6);
            }
        }
    }
}

