/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Locale;
import org.jsoup.helper.Validate;

class CharacterReader {
    static final char EOF = '\uffff';
    private final char[] input;
    private final int length;
    private int pos = 0;
    private int mark = 0;

    CharacterReader(String input) {
        Validate.notNull(input);
        this.input = input.toCharArray();
        this.length = this.input.length;
    }

    int pos() {
        return this.pos;
    }

    boolean isEmpty() {
        return this.pos >= this.length;
    }

    char current() {
        return this.isEmpty() ? (char)'\uffff' : this.input[this.pos];
    }

    char consume() {
        char val = this.isEmpty() ? (char)'\uffff' : this.input[this.pos];
        ++this.pos;
        return val;
    }

    void unconsume() {
        --this.pos;
    }

    void advance() {
        ++this.pos;
    }

    void mark() {
        this.mark = this.pos;
    }

    void rewindToMark() {
        this.pos = this.mark;
    }

    String consumeAsString() {
        return new String(this.input, this.pos++, 1);
    }

    int nextIndexOf(char c) {
        for (int i = this.pos; i < this.length; ++i) {
            if (c != this.input[i]) continue;
            return i - this.pos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq2) {
        char startChar = seq2.charAt(0);
        for (int offset = this.pos; offset < this.length; ++offset) {
            if (startChar != this.input[offset]) {
                while (++offset < this.length && startChar != this.input[offset]) {
                }
            }
            if (offset >= this.length) continue;
            int i = offset + 1;
            int last = i + seq2.length() - 1;
            int j = 1;
            while (i < last && seq2.charAt(j) == this.input[i]) {
                ++i;
                ++j;
            }
            if (i != last) continue;
            return offset - this.pos;
        }
        return -1;
    }

    String consumeTo(char c) {
        int offset = this.nextIndexOf(c);
        if (offset != -1) {
            String consumed = new String(this.input, this.pos, offset);
            this.pos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq2) {
        int offset = this.nextIndexOf(seq2);
        if (offset != -1) {
            String consumed = new String(this.input, this.pos, offset);
            this.pos += offset;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeToAny(char ... chars) {
        int start = this.pos;
        block0: while (this.pos < this.length) {
            for (int i = 0; i < chars.length; ++i) {
                if (this.input[this.pos] == chars[i]) break block0;
            }
            ++this.pos;
        }
        return this.pos > start ? new String(this.input, start, this.pos - start) : "";
    }

    String consumeToEnd() {
        String data = new String(this.input, this.pos, this.length - this.pos);
        this.pos = this.length;
        return data;
    }

    String consumeLetterSequence() {
        char c;
        int start = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        int start = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            ++this.pos;
        }
        while (!this.isEmpty() && (c = this.input[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    String consumeHexSequence() {
        char c;
        int start = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    String consumeDigitSequence() {
        char c;
        int start = this.pos;
        while (this.pos < this.length && (c = this.input[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        return new String(this.input, start, this.pos - start);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.input[this.pos] == c;
    }

    boolean matches(String seq2) {
        int scanLength = seq2.length();
        if (scanLength > this.length - this.pos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            if (seq2.charAt(offset) == this.input[this.pos + offset]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq2) {
        int scanLength = seq2.length();
        if (scanLength > this.length - this.pos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            char upTarget;
            char upScan = Character.toUpperCase(seq2.charAt(offset));
            if (upScan == (upTarget = Character.toUpperCase(this.input[this.pos + offset]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... seq2) {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        for (char seek : seq2) {
            if (seek != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq2) {
        if (this.matches(seq2)) {
            this.pos += seq2.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq2) {
        if (this.matchesIgnoreCase(seq2)) {
            this.pos += seq2.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq2) {
        String loScan = seq2.toLowerCase(Locale.ENGLISH);
        String hiScan = seq2.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(loScan) > -1 || this.nextIndexOf(hiScan) > -1;
    }

    public String toString() {
        return new String(this.input, this.pos, this.length - this.pos);
    }
}

