/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseHTMLFile {
    static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    static final String TEMPLATE_ROOT_PATH = "resources" + File.separator + "htmlTemplate";
    static final String TEMPLATE_FILE_NAME = "LicenseHTMLTemplate.html";
    static final boolean USE_SITE = false;
    static final Pattern SITE_PATTERN = Pattern.compile("http://(.*)\\.(.*)(\\.org|\\.com|\\.net|\\.info)");
    private SpdxListedLicense license;

    public LicenseHTMLFile(SpdxListedLicense license) {
        this.license = license;
    }

    public LicenseHTMLFile() {
        this(null);
    }

    public SpdxListedLicense getLicense() {
        return this.license;
    }

    public void setLicense(SpdxListedLicense license) {
        this.license = license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File htmlFile, String tableOfContentsReference) throws IOException, MustacheException, InvalidLicenseTemplateException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!htmlFile.exists() && !htmlFile.createNewFile()) {
            throw new IOException("Can not create new file " + htmlFile.getName());
        }
        String templateDirName = TEMPLATE_ROOT_PATH;
        File templateDirectoryRoot = new File(templateDirName);
        if (!templateDirectoryRoot.exists() || !templateDirectoryRoot.isDirectory()) {
            templateDirName = TEMPLATE_CLASS_PATH;
        }
        try {
            stream = new FileOutputStream(htmlFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DefaultMustacheFactory builder = new DefaultMustacheFactory(templateDirName);
            Map<String, Object> mustacheMap = this.buildMustachMap();
            Mustache mustache = builder.compile(TEMPLATE_FILE_NAME);
            mustache.execute((Writer)writer, mustacheMap);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private Map<String, Object> buildMustachMap() throws InvalidLicenseTemplateException {
        HashMap<String, Object> retval = Maps.newHashMap();
        if (this.license != null) {
            retval.put("licenseId", this.license.getLicenseId());
            String licenseTextHtml = this.license.getLicenseTextHtml();
            retval.put("licenseText", licenseTextHtml);
            retval.put("licenseName", this.license.getName());
            String notes = this.license.getComment() != null && !this.license.getComment().isEmpty() ? this.license.getComment() : null;
            String templateText = this.license.getStandardLicenseTemplate();
            if (templateText == null) {
                templateText = StringEscapeUtils.escapeHtml4(this.license.getLicenseText());
            }
            retval.put("standardLicenseTemplate", templateText);
            retval.put("notes", notes);
            retval.put("osiApproved", this.license.isOsiApproved());
            retval.put("fsfLibre", this.license.isFsfLibre());
            retval.put("notFsfLibre", this.license.isNotFsfLibre());
            ArrayList<FormattedUrl> otherWebPages = Lists.newArrayList();
            if (this.license.getSeeAlso() != null && this.license.getSeeAlso().length > 0) {
                for (String sourceUrl : this.license.getSeeAlso()) {
                    if (sourceUrl == null || sourceUrl.isEmpty()) continue;
                    FormattedUrl formattedUrl = new FormattedUrl(sourceUrl);
                    otherWebPages.add(formattedUrl);
                }
                if (otherWebPages.size() == 0) {
                    otherWebPages = null;
                }
                retval.put("otherWebPages", otherWebPages);
                retval.put("title", this.license.getName());
                String header = this.license.getLicenseHeaderHtml();
                if (header != null && header.trim().isEmpty()) {
                    header = null;
                }
                retval.put("licenseHeader", header);
            }
        }
        retval.put("deprecated", this.license.isDeprecated());
        retval.put("deprecatedVersion", this.license.getDeprecatedVersion());
        return retval;
    }

    public static class FormattedUrl {
        String url;

        public FormattedUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getSite() {
            return this.getSiteFromUrl(this.url);
        }

        private String getSiteFromUrl(String url) {
            Matcher matcher = SITE_PATTERN.matcher(url);
            if (matcher.find()) {
                // empty if block
            }
            return url;
        }
    }
}

