/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.SpdxElement;

public class ExternalSpdxElement
extends SpdxElement {
    public ExternalSpdxElement(String id) throws InvalidSPDXAnalysisException {
        super(null, null, null, null);
        if (!SpdxRdfConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(id).matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        this.setId(id);
    }

    @Override
    public void setId(String id) throws InvalidSPDXAnalysisException {
        if (id != null && !SpdxRdfConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(id).matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        super.setId(id);
    }

    public String getExternalDocumentId() throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxRdfConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        return matcher.group(1);
    }

    public String getExternalElementId() throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxRdfConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        return matcher.group(2);
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxRdfConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        String externalDocumentUri = modelContainer.externalDocumentIdToNamespace(matcher.group(1));
        if (externalDocumentUri == null) {
            throw new InvalidSPDXAnalysisException("No external document reference exists for document ID " + matcher.group(1));
        }
        return externalDocumentUri + "#" + matcher.group(2);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    @Override
    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalSpdxElement)) {
            return false;
        }
        ExternalSpdxElement comp = (ExternalSpdxElement)o;
        if (!super.equivalent(comp, testRelationships)) {
            return false;
        }
        return Objects.equal(this.getId(), comp.getId());
    }

    @Override
    public ExternalSpdxElement clone() {
        try {
            return new ExternalSpdxElement(this.getId());
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new AssertionError("Clone should never cause an Invalid SPDX Exception", e2);
        }
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        String id = this.getId();
        if (!SpdxRdfConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(id).matches()) {
            retval.add("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        return retval;
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
    }
}

