/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdConsts;
import com.github.jsonldjava.core.JsonLdError;

public class JsonLdOptions {
    public static final String JSON_LD_1_0 = "json-ld-1.0";
    public static final String JSON_LD_1_1 = "json-ld-1.1";
    public static final String JSON_LD_1_1_FRAME = "json-ld-1.1-expand-frame";
    public static final boolean DEFAULT_COMPACT_ARRAYS = true;
    private String base = null;
    private Boolean compactArrays = true;
    private Object expandContext = null;
    private String processingMode = "json-ld-1.0";
    private DocumentLoader documentLoader = new DocumentLoader();
    private JsonLdConsts.Embed embed = JsonLdConsts.Embed.LAST;
    private Boolean explicit = null;
    private Boolean omitDefault = null;
    private Boolean pruneBlankNodeIdentifiers = false;
    private Boolean requireAll = false;
    Boolean useRdfType = false;
    Boolean useNativeTypes = false;
    private boolean produceGeneralizedRdf = false;
    public String format = null;
    public Boolean useNamespaces = false;
    public String outputForm = null;

    public JsonLdOptions() {
        this("");
    }

    public JsonLdOptions(String base) {
        this.setBase(base);
    }

    public String getEmbed() {
        switch (this.embed) {
            case ALWAYS: {
                return "@always";
            }
            case NEVER: {
                return "@never";
            }
            case LINK: {
                return "@link";
            }
        }
        return "@last";
    }

    JsonLdConsts.Embed getEmbedVal() {
        return this.embed;
    }

    public void setEmbed(Boolean embed) {
        this.embed = embed != false ? JsonLdConsts.Embed.LAST : JsonLdConsts.Embed.NEVER;
    }

    public void setEmbed(String embed) throws JsonLdError {
        switch (embed) {
            case "@always": {
                this.embed = JsonLdConsts.Embed.ALWAYS;
                break;
            }
            case "@never": {
                this.embed = JsonLdConsts.Embed.NEVER;
                break;
            }
            case "@last": {
                this.embed = JsonLdConsts.Embed.LAST;
                break;
            }
            case "@link": {
                this.embed = JsonLdConsts.Embed.LINK;
                break;
            }
            default: {
                throw new JsonLdError(JsonLdError.Error.INVALID_EMBED_VALUE);
            }
        }
    }

    public Boolean getExplicit() {
        return this.explicit;
    }

    public void setExplicit(Boolean explicit) {
        this.explicit = explicit;
    }

    public Boolean getOmitDefault() {
        return this.omitDefault;
    }

    public void setOmitDefault(Boolean omitDefault) {
        this.omitDefault = omitDefault;
    }

    public Boolean getPruneBlankNodeIdentifiers() {
        return this.pruneBlankNodeIdentifiers != false || this.getProcessingMode().equals(JSON_LD_1_1);
    }

    public void setPruneBlankNodeIdentifiers(Boolean pruneBlankNodeIdentifiers) {
        if (pruneBlankNodeIdentifiers.booleanValue()) {
            this.setProcessingMode(JSON_LD_1_1);
        }
        this.pruneBlankNodeIdentifiers = pruneBlankNodeIdentifiers;
    }

    public Boolean getRequireAll() {
        return this.requireAll;
    }

    public void setRequireAll(Boolean requireAll) {
        this.requireAll = requireAll;
    }

    public Boolean getCompactArrays() {
        return this.compactArrays;
    }

    public void setCompactArrays(Boolean compactArrays) {
        this.compactArrays = compactArrays;
    }

    public Object getExpandContext() {
        return this.expandContext;
    }

    public void setExpandContext(Object expandContext) {
        this.expandContext = expandContext;
    }

    public String getProcessingMode() {
        return this.processingMode;
    }

    public void setProcessingMode(String processingMode) {
        this.processingMode = processingMode;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Boolean getUseRdfType() {
        return this.useRdfType;
    }

    public void setUseRdfType(Boolean useRdfType) {
        this.useRdfType = useRdfType;
    }

    public Boolean getUseNativeTypes() {
        return this.useNativeTypes;
    }

    public void setUseNativeTypes(Boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
    }

    public boolean getProduceGeneralizedRdf() {
        return this.produceGeneralizedRdf;
    }

    public void setProduceGeneralizedRdf(Boolean produceGeneralizedRdf) {
        this.produceGeneralizedRdf = produceGeneralizedRdf;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }
}

