/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.util.Arrays;

public class GuardedWrapper
implements Wrapper {
    private static final GuardException guardException = new GuardException();
    protected final Predicate<Object[]>[] guard;
    private int hashCode;

    public GuardedWrapper(Predicate<Object[]>[] guard) {
        this.guard = guard;
    }

    @Override
    public Object call(Object[] scopes) throws GuardException {
        this.guardCall(scopes);
        return null;
    }

    protected void guardCall(Object[] scopes) throws GuardException {
        for (Predicate<Object[]> predicate : this.guard) {
            if (predicate.apply(scopes)) continue;
            throw guardException;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (Predicate<Object[]> predicate : this.guard) {
                this.hashCode += this.hashCode * 43 + predicate.hashCode();
            }
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof GuardedWrapper) {
            GuardedWrapper other = (GuardedWrapper)o;
            return this.guard == null && other.guard == null || Arrays.equals(other.guard, this.guard);
        }
        return false;
    }

    static {
        guardException.setStackTrace(new StackTraceElement[0]);
    }
}

