/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HtmlSerializer
implements ContentHandler,
LexicalHandler {
    private static final String[] VOID_ELEMENTS = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "command", "embed", "frame", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"};
    private static final String[] NON_ESCAPING = new String[]{"iframe", "noembed", "noframes", "noscript", "plaintext", "script", "style", "xmp"};
    private int ignoreLevel = 0;
    private int escapeLevel = 0;
    private final Writer writer;

    private static Writer wrap(OutputStream out) {
        try {
            return new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public HtmlSerializer(OutputStream out) {
        this(HtmlSerializer.wrap(out));
    }

    public HtmlSerializer(Writer out) {
        this.writer = out;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.escapeLevel > 0) {
                this.writer.write(ch, start, length);
            } else {
                block8: for (int i = start; i < start + length; ++i) {
                    char c = ch[i];
                    switch (c) {
                        case '<': {
                            this.writer.write("&lt;");
                            continue block8;
                        }
                        case '>': {
                            this.writer.write("&gt;");
                            continue block8;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block8;
                        }
                        case '\u00a0': {
                            this.writer.write("&nbsp;");
                            continue block8;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.escapeLevel > 0) {
            --this.escapeLevel;
        }
        if (this.ignoreLevel > 0) {
            --this.ignoreLevel;
        } else {
            try {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(localName);
                this.writer.write(62);
            }
            catch (IOException e2) {
                throw new SAXException(e2);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.writer.write("<!DOCTYPE html>\n");
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.escapeLevel > 0) {
            ++this.escapeLevel;
        }
        boolean xhtml = "http://www.w3.org/1999/xhtml".equals(uri);
        if (this.ignoreLevel > 0 || !xhtml && !"http://www.w3.org/2000/svg".equals(uri) && !"http://www.w3.org/1998/Math/MathML".equals(uri)) {
            ++this.ignoreLevel;
            return;
        }
        try {
            this.writer.write(60);
            this.writer.write(localName);
            for (int i = 0; i < atts.getLength(); ++i) {
                String attUri = atts.getURI(i);
                String attLocal = atts.getLocalName(i);
                if (attUri.length() == 0) {
                    this.writer.write(32);
                } else if (!xhtml && "http://www.w3.org/1999/xlink".equals(attUri)) {
                    this.writer.write(" xlink:");
                } else {
                    if (!"http://www.w3.org/XML/1998/namespace".equals(attUri)) continue;
                    if (xhtml) {
                        if (!"lang".equals(attLocal)) continue;
                        this.writer.write(32);
                    } else {
                        this.writer.write(" xml:");
                    }
                }
                this.writer.write(atts.getLocalName(i));
                this.writer.write(61);
                this.writer.write(34);
                String val = atts.getValue(i);
                block8: for (int j = 0; j < val.length(); ++j) {
                    char c = val.charAt(j);
                    switch (c) {
                        case '\"': {
                            this.writer.write("&quot;");
                            continue block8;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block8;
                        }
                        case '\u00a0': {
                            this.writer.write("&nbsp;");
                            continue block8;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
                this.writer.write(34);
            }
            this.writer.write(62);
            if (Arrays.binarySearch(VOID_ELEMENTS, localName) > -1) {
                ++this.ignoreLevel;
                return;
            }
            if ("pre".equals(localName) || "textarea".equals(localName) || "listing".equals(localName)) {
                this.writer.write(10);
            }
            if (this.escapeLevel == 0 && Arrays.binarySearch(NON_ESCAPING, localName) > -1) {
                this.escapeLevel = 1;
            }
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreLevel > 0 || this.escapeLevel > 0) {
            return;
        }
        try {
            this.writer.write("<!--");
            this.writer.write(ch, start, length);
            this.writer.write("-->");
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

