/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.NoSuchElementException;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterYieldN
extends QueryIter {
    protected int limitYielded;
    protected int countYielded = 0;
    protected Binding binding;

    public QueryIterYieldN(int num, Binding b) {
        this(num, b, null);
    }

    public QueryIterYieldN(int num, Binding b, ExecutionContext context) {
        super(context);
        this.binding = b;
        this.limitYielded = num;
    }

    public Binding getBinding() {
        return this.binding;
    }

    @Override
    protected boolean hasNextBinding() {
        return this.countYielded < this.limitYielded;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Lib.className(this));
        }
        ++this.countYielded;
        return this.binding;
    }

    @Override
    protected void closeIterator() {
    }

    @Override
    protected void requestCancel() {
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("QueryIterYieldN: " + this.limitYielded + " of " + this.binding);
    }
}

