/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.file.BufferChannel;
import org.apache.jena.tdb.base.file.BufferChannelFile;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.StorageConfig;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.sys.SystemTDB;
import org.apache.jena.tdb.transaction.Journal;
import org.apache.jena.tdb.transaction.JournalEntry;
import org.apache.jena.tdb.transaction.JournalEntryType;
import org.apache.jena.tdb.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalControl {
    private static Logger log = LoggerFactory.getLogger(JournalControl.class);

    public static void print(String filename) {
        BufferChannelFile chan = BufferChannelFile.createUnmanaged(filename, "r");
        Journal journal = new Journal(chan);
        JournalControl.print(journal);
        chan.close();
    }

    public static void print(Journal journal) {
        System.out.println("Size: " + journal.size());
        Iterator<JournalEntry> iter = journal.entries();
        while (true) {
            long posn0 = journal.position();
            if (!iter.hasNext()) break;
            JournalEntry e2 = iter.next();
            long posn1 = journal.position();
            long size = posn1 - posn0;
            System.out.printf("Posn: (%d, %d) Len=%d  reverse %d\n", posn0, posn1, size, journal.size() - journal.position());
            System.out.print("  ");
            System.out.println(JournalEntry.format(e2));
        }
    }

    public static void recovery(DatasetGraphTDB dsg) {
        if (dsg.getLocation().isMem()) {
            return;
        }
        Journal journal = JournalControl.findJournal(dsg);
        if (journal == null || journal.isEmpty()) {
            return;
        }
        JournalControl.recoverFromJournal(dsg.getConfig(), journal);
        journal.close();
        if (journal.getFilename() != null && FileOps.exists(journal.getFilename())) {
            FileOps.delete(journal.getFilename());
        }
    }

    private static Journal findJournal(DatasetGraphTDB dsg) {
        Location loc = dsg.getLocation();
        String journalFilename = loc.absolute("journal.jrnl");
        File f = new File(journalFilename);
        if (f.exists() && f.isFile() && f.length() > 0L) {
            return Journal.create(loc);
        }
        return null;
    }

    public static boolean recoverFromJournal(StorageConfig sConf, Journal jrnl) {
        if (jrnl.isEmpty()) {
            return false;
        }
        for (FileRef fileRef : sConf.objectFiles.keySet()) {
            JournalControl.recoverNodeDat(sConf.location, fileRef);
        }
        long posn = 0L;
        while (true) {
            long x;
            try {
                x = JournalControl.scanForCommit(jrnl, posn);
            }
            catch (TDBException ex) {
                x = -1L;
            }
            if (x == -1L) break;
            JournalControl.recoverSegment(jrnl, posn, x, sConf);
            posn = x;
        }
        JournalControl.syncAll(sConf);
        jrnl.truncate(0L);
        jrnl.sync();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long scanForCommit(Journal jrnl, long startPosn) {
        Iterator<JournalEntry> iter = jrnl.entries(startPosn);
        try {
            while (iter.hasNext()) {
                JournalEntry e2 = iter.next();
                if (e2.getType() != JournalEntryType.Commit) continue;
                long l = e2.getEndPosition();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            Iter.close(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recoverSegment(Journal jrnl, long startPosn, long endPosn, StorageConfig sConf) {
        Iterator<JournalEntry> iter = jrnl.entries(startPosn);
        iter = jrnl.entries(startPosn);
        try {
            while (iter.hasNext()) {
                JournalEntry e2 = iter.next();
                if (e2.getType() == JournalEntryType.Commit) {
                    if (e2.getEndPosition() != endPosn) {
                        log.warn(String.format("Inconsistent: end at %d; expected %d", e2.getEndPosition(), endPosn));
                    }
                    return;
                }
                JournalControl.replay(e2, sConf);
            }
        }
        finally {
            Iter.close(iter);
        }
    }

    private static void recoverNodeDat(Location loc, FileRef fileRef) {
        String objFilename = fileRef.getFilename() + "-" + "jrnl";
        File jrnlFile = new File(objFilename = loc.absolute(objFilename));
        if (jrnlFile.exists()) {
            if (jrnlFile.length() > 0L) {
                SystemTDB.syslog.info("Found dat-jrnl file : earlier version of Jena" + fileRef.getFilename());
                SystemTDB.syslog.info("  To clearup: run TDB from a version of Jena 3.0.0-3.4.0");
                SystemTDB.syslog.info("  dat-jrnl should then go away");
                SystemTDB.syslog.info("  See https://issues.apache.org/jira/browse/JENA-1379");
                throw new TDBException("Manual recovery required - see log - see JENA-1379 <https://issues.apache.org/jira/browse/JENA-1379>");
            }
            FileOps.delete(objFilename);
        }
    }

    public static void replay(Transaction transaction) {
        if (SystemTDB.syslog.isDebugEnabled()) {
            SystemTDB.syslog.debug("Replay " + transaction.getLabel());
        }
        Journal journal = transaction.getJournal();
        DatasetGraphTDB dsg = transaction.getBaseDataset();
        JournalControl.replay(journal, dsg.getConfig());
    }

    public static void replay(Journal journal, DatasetGraphTDB dsg) {
        JournalControl.replay(journal, dsg.getConfig());
    }

    private static void replay(Journal journal, StorageConfig sConf) {
        if (journal.size() == 0L) {
            return;
        }
        journal.position(0L);
        try {
            Iterator<JournalEntry> iter = journal.entries();
            while (iter.hasNext()) {
                JournalEntry e2 = iter.next();
                JournalControl.replay(e2, sConf);
            }
        }
        catch (RuntimeException ex) {
            SystemTDB.syslog.error("Exception during journal replay", ex);
            throw ex;
        }
        Collection<BlockMgr> x = sConf.blockMgrs.values();
        for (BlockMgr blkMgr : x) {
            blkMgr.syncForce();
        }
        journal.truncate(0L);
    }

    private static boolean replay(JournalEntry e2, StorageConfig sConf) {
        switch (e2.getType()) {
            case Block: {
                BlockMgr blkMgr = sConf.blockMgrs.get(e2.getFileRef());
                Block blk = e2.getBlock();
                log.debug("Replay: {} {}", (Object)e2.getFileRef(), (Object)blk);
                blk.setModified(true);
                blkMgr.overwrite(blk);
                return true;
            }
            case Buffer: {
                BufferChannel chan = sConf.bufferChannels.get(e2.getFileRef());
                ByteBuffer bb = e2.getByteBuffer();
                log.debug("Replay: {} {}", (Object)e2.getFileRef(), (Object)bb);
                chan.write(bb, 0L);
                return true;
            }
            case Commit: {
                return false;
            }
            case Abort: 
            case Object: 
            case Checkpoint: {
                SystemTDB.errlog.warn("Unexpected block type: " + (Object)((Object)e2.getType()));
            }
        }
        return false;
    }

    private static void syncAll(StorageConfig sConf) {
        Collection<BlockMgr> x = sConf.blockMgrs.values();
        for (BlockMgr blkMgr : x) {
            blkMgr.syncForce();
        }
        Collection<BufferChannel> y = sConf.bufferChannels.values();
        for (BufferChannel bChan : y) {
            bChan.sync();
        }
    }
}

