/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.assembler.VocabTDB2;

public class DatasetAssemblerTDB
extends DatasetAssembler {
    @Override
    public Dataset createDataset(Assembler a, Resource root2, Mode mode) {
        TDB2.init();
        return DatasetAssemblerTDB.make(root2);
    }

    static Dataset make(Resource root2) {
        if (!GraphUtils.exactlyOneProperty(root2, VocabTDB2.pLocation)) {
            throw new AssemblerException(root2, "No location given");
        }
        String dir = GraphUtils.getStringValue(root2, VocabTDB2.pLocation);
        Location loc = Location.create(dir);
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(loc);
        if (root2.hasProperty(VocabTDB2.pUnionDefaultGraph)) {
            Node b = root2.getProperty(VocabTDB2.pUnionDefaultGraph).getObject().asNode();
            NodeValue nv = NodeValue.makeNode(b);
            if (nv.isBoolean()) {
                dsg.getContext().set(TDB2.symUnionDefaultGraph, nv.getBoolean());
            } else {
                Log.warn(DatasetAssemblerTDB.class, "Failed to recognize value for union graph setting (ignored): " + b);
            }
        }
        AssemblerUtils.setContext(root2, dsg.getContext());
        return DatasetFactory.wrap(dsg);
    }

    static {
        JenaSystem.init();
    }
}

