/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.loader.DataLoader;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.basic.LoaderBasic;
import org.apache.jena.tdb2.loader.main.LoaderParallel;
import org.apache.jena.tdb2.loader.main.LoaderPhased;
import org.apache.jena.tdb2.loader.sequential.LoaderSequential;

public class LoaderFactory {
    public static DataLoader basicLoader(DatasetGraph dsg, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderBasic(dsg, null, output);
    }

    public static DataLoader basicLoader(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderBasic(dsg, graphName, output);
    }

    public static DataLoader sequentialLoader(DatasetGraph dsg, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderSequential(dsg, null, output);
    }

    public static DataLoader sequentialLoader(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderSequential(dsg, graphName, output);
    }

    public static DataLoader phasedLoader(DatasetGraph dsg, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderPhased(dsg, null, output);
    }

    public static DataLoader phasedLoader(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderPhased(dsg, graphName, output);
    }

    public static DataLoader parallelLoader(DatasetGraph dsg, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderParallel(dsg, null, output);
    }

    public static DataLoader parallelLoader(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return new LoaderParallel(dsg, graphName, output);
    }

    public static DataLoader createLoader(DatasetGraph dsg, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        return LoaderFactory.createDft(dsg, null, output);
    }

    public static DataLoader createLoader(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        Objects.requireNonNull(dsg);
        Objects.requireNonNull(graphName);
        return LoaderFactory.createDft(dsg, graphName, output);
    }

    private static DataLoader createDft(DatasetGraph dsg, Node graphName, MonitorOutput output) {
        return LoaderFactory.phasedLoader(dsg, graphName, output);
    }
}

