/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.loader.BulkLoaderException;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.main.Destination;
import org.apache.jena.tdb2.loader.main.LoaderConst;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.DatasetPrefixesTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class DataToTuplesInline
implements StreamRDFCounting,
BulkStartFinish {
    public static final int DataTickPoint = 100000;
    public static final int DataSuperTick = 10;
    private final Destination<Tuple<NodeId>> dest3;
    private final Destination<Tuple<NodeId>> dest4;
    private final DatasetGraphTDB dsgtdb;
    private final NodeTable nodeTable;
    private final DatasetPrefixStorage prefixes;
    private final MonitorOutput output;
    private long countTriples = 0L;
    private long countQuads = 0L;
    private List<Tuple<NodeId>> quads = null;
    private List<Tuple<NodeId>> triples = null;
    private TransactionCoordinator coordinator;
    private Transaction transaction;

    public DataToTuplesInline(DatasetGraphTDB dsgtdb, Destination<Tuple<NodeId>> dest3, Destination<Tuple<NodeId>> dest4, MonitorOutput output) {
        this.dsgtdb = dsgtdb;
        this.dest3 = dest3;
        this.dest4 = dest4;
        this.output = output;
        this.nodeTable = dsgtdb.getTripleTable().getNodeTupleTable().getNodeTable();
        this.prefixes = dsgtdb.getPrefixes();
        NodeTable nodeTable2 = dsgtdb.getQuadTable().getNodeTupleTable().getNodeTable();
        if (this.nodeTable != nodeTable2) {
            throw new BulkLoaderException("Different node tables");
        }
    }

    @Override
    public void startBulk() {
        this.coordinator = CoLib.newCoordinator();
        CoLib.add(this.coordinator, this.nodeTable);
        NodeTupleTable p = ((DatasetPrefixesTDB)this.prefixes).getNodeTupleTable();
        CoLib.add(this.coordinator, p.getNodeTable());
        CoLib.add(this.coordinator, p.getTupleTable().getIndexes());
        CoLib.start(this.coordinator);
        this.transaction = this.coordinator.begin(TxnType.WRITE);
    }

    @Override
    public void finishBulk() {
        if (this.triples != null && !this.triples.isEmpty()) {
            this.dispatchTriples(this.triples);
            this.triples = null;
        }
        this.dispatchTriples(LoaderConst.END_TUPLES);
        if (this.quads != null && !this.quads.isEmpty()) {
            this.dispatchTriples(this.quads);
            this.quads = null;
        }
        this.dispatchQuads(LoaderConst.END_TUPLES);
        this.transaction.commit();
        this.transaction.end();
        CoLib.finish(this.coordinator);
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
    }

    @Override
    public long count() {
        return this.countTriples() + this.countQuads();
    }

    @Override
    public long countTriples() {
        return this.countTriples;
    }

    @Override
    public long countQuads() {
        return this.countQuads;
    }

    @Override
    public void triple(Triple triple) {
        ++this.countTriples;
        if (this.triples == null) {
            this.triples = this.allocChunkTriples();
        }
        DataToTuplesInline.accTuples(triple, this.nodeTable, this.triples);
        if (this.triples.size() >= 100000) {
            this.dispatchTriples(this.triples);
            this.triples = null;
        }
    }

    @Override
    public void quad(Quad quad) {
        if (quad.isTriple() || quad.isDefaultGraph()) {
            this.triple(quad.asTriple());
            return;
        }
        ++this.countQuads;
        if (this.quads == null) {
            this.quads = this.allocChunkQuads();
        }
        DataToTuplesInline.accTuples(quad, this.nodeTable, this.quads);
        if (this.quads.size() >= 100000) {
            this.dispatchQuads(this.quads);
            this.quads = null;
        }
    }

    private void dispatchQuads(List<Tuple<NodeId>> chunk) {
        this.dest4.deliver(chunk);
    }

    private void dispatchTriples(List<Tuple<NodeId>> chunk) {
        this.dest3.deliver(chunk);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri) {
        this.prefixes.insertPrefix("", prefix, iri);
    }

    private static void accTuples(Triple triple, NodeTable nodeTable, List<Tuple<NodeId>> acc) {
        acc.add(DataToTuplesInline.nodes(nodeTable, triple));
    }

    private static void accTuples(Quad quad, NodeTable nodeTable, List<Tuple<NodeId>> acc) {
        acc.add(DataToTuplesInline.nodes(nodeTable, quad));
    }

    private List<Tuple<NodeId>> allocChunkTriples() {
        return new ArrayList<Tuple<NodeId>>(100000);
    }

    private List<Tuple<NodeId>> allocChunkQuads() {
        return new ArrayList<Tuple<NodeId>>(100000);
    }

    private static Tuple<NodeId> nodes(NodeTable nt, Triple triple) {
        NodeId s = DataToTuplesInline.idForNode(nt, triple.getSubject());
        NodeId p = DataToTuplesInline.idForNode(nt, triple.getPredicate());
        NodeId o = DataToTuplesInline.idForNode(nt, triple.getObject());
        return TupleFactory.tuple(s, p, o);
    }

    private static Tuple<NodeId> nodes(NodeTable nt, Quad quad) {
        NodeId g = DataToTuplesInline.idForNode(nt, quad.getGraph());
        NodeId s = DataToTuplesInline.idForNode(nt, quad.getSubject());
        NodeId p = DataToTuplesInline.idForNode(nt, quad.getPredicate());
        NodeId o = DataToTuplesInline.idForNode(nt, quad.getObject());
        return TupleFactory.tuple(g, s, p, o);
    }

    private static final NodeId idForNode(NodeTable nodeTable, Node node) {
        return nodeTable.getAllocateNodeId(node);
    }
}

