/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.main;

import java.util.function.BiConsumer;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.query.TxnType;
import org.apache.jena.tdb2.loader.base.BulkStartFinish;
import org.apache.jena.tdb2.loader.base.CoLib;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.store.DatasetPrefixesTDB;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class PrefixHandler
implements BulkStartFinish {
    private Transaction transaction;
    private TransactionCoordinator coordinator;
    private DatasetPrefixesTDB prefixes;
    private MonitorOutput output;

    public PrefixHandler(DatasetPrefixesTDB prefixes, MonitorOutput output) {
        this.prefixes = prefixes;
        this.output = output;
    }

    @Override
    public void startBulk() {
        TransactionCoordinator coordinator = CoLib.newCoordinator();
        NodeTupleTable p = this.prefixes.getNodeTupleTable();
        CoLib.add(coordinator, p.getNodeTable());
        CoLib.add(coordinator, p.getTupleTable().getIndexes());
        coordinator.start();
        this.transaction = coordinator.begin(TxnType.WRITE);
    }

    @Override
    public void finishBulk() {
        this.transaction.commit();
    }

    public BiConsumer<String, String> handler() {
        return (prefix, uriStr) -> this.prefixes.insertPrefix("", (String)prefix, (String)uriStr);
    }
}

