/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.setup;

import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableCache;
import org.apache.jena.tdb2.store.nodetable.NodeTableInline;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class TDBDatasetDetails {
    public final TupleIndex[] tripleIndexes;
    public final TupleIndex[] quadIndexes;
    public final NodeTable ntTop;
    public NodeTableInline ntInline;
    public NodeTableCache ntCache;
    public NodeTable ntBase;

    public TDBDatasetDetails(DatasetGraphTDB dsg) {
        this.ntTop = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        this.tripleIndexes = ArrayUtils.copy(dsg.getTripleTable().getNodeTupleTable().getTupleTable().getIndexes());
        this.quadIndexes = ArrayUtils.copy(dsg.getQuadTable().getNodeTupleTable().getTupleTable().getIndexes());
        this.fillInNodeTableDetails();
        this.fillInIndexDetails();
    }

    private void fillInNodeTableDetails() {
        NodeTable ntx = this.ntTop;
        while (ntx.wrapped() != null) {
            if (ntx instanceof NodeTableInline) {
                if (this.ntInline != null) {
                    Log.warn(this, "Multiple NodeTableInline");
                }
                this.ntInline = (NodeTableInline)ntx;
            } else if (ntx instanceof NodeTableCache) {
                if (this.ntCache != null) {
                    Log.warn(this, "Multiple NodeTableCache");
                }
                this.ntCache = (NodeTableCache)ntx;
            }
            ntx = ntx.wrapped();
        }
        this.ntBase = ntx;
        if (this.ntInline == null) {
            Log.warn(this, "No NodeTableInline");
        }
        if (this.ntCache == null) {
            Log.warn(this, "No NodeTableCache");
        }
        if (this.ntBase == null) {
            Log.warn(this, "No base NodeTable");
        }
    }

    private void fillInIndexDetails() {
    }
}

