/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.CacheSet;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.setup.StoreParams;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableOps;

public class NodeTableCache
implements NodeTable {
    private Cache<Node, NodeId> node2id_Cache = null;
    private Cache<NodeId, Node> id2node_Cache = null;
    private CacheSet<Node> notPresent = null;
    private NodeTable baseTable;
    private final Object lock = new Object();

    public static NodeTable create(NodeTable nodeTable, StoreParams params) {
        int nodeToIdCacheSize = params.getNode2NodeIdCacheSize();
        int idToNodeCacheSize = params.getNodeId2NodeCacheSize();
        if (nodeToIdCacheSize <= 0 && idToNodeCacheSize <= 0) {
            return nodeTable;
        }
        return new NodeTableCache(nodeTable, nodeToIdCacheSize, idToNodeCacheSize, params.getNodeMissCacheSize());
    }

    public static NodeTable create(NodeTable nodeTable, int nodeToIdCacheSize, int idToNodeCacheSize, int nodeMissesCacheSize) {
        if (nodeToIdCacheSize <= 0 && idToNodeCacheSize <= 0) {
            return nodeTable;
        }
        return new NodeTableCache(nodeTable, nodeToIdCacheSize, idToNodeCacheSize, nodeMissesCacheSize);
    }

    private NodeTableCache(NodeTable baseTable, int nodeToIdCacheSize, int idToNodeCacheSize, int nodeMissesCacheSize) {
        this.baseTable = baseTable;
        if (nodeToIdCacheSize > 0) {
            this.node2id_Cache = CacheFactory.createCache(nodeToIdCacheSize);
        }
        if (idToNodeCacheSize > 0) {
            this.id2node_Cache = CacheFactory.createCache(idToNodeCacheSize);
        }
        if (nodeMissesCacheSize > 0) {
            this.notPresent = CacheFactory.createCacheSet(nodeMissesCacheSize);
        }
    }

    public Node getNodeForNodeIdCache(NodeId id) {
        return this.id2node_Cache.getIfPresent(id);
    }

    public NodeId getNodeIdForNodeCache(Node node) {
        return this.node2id_Cache.getIfPresent(node);
    }

    public boolean isCachedNodeId(NodeId id) {
        return this.getNodeForNodeIdCache(id) != null;
    }

    public boolean isCachedNode(Node node) {
        return this.getNodeIdForNodeCache(node) != null;
    }

    @Override
    public final NodeTable wrapped() {
        return this.baseTable;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    @Override
    public boolean containsNode(Node node) {
        NodeId x = this.getNodeIdForNode(node);
        return NodeId.isDoesNotExist(x);
    }

    @Override
    public boolean containsNodeId(NodeId nodeId) {
        Node x = this.getNodeForNodeId(nodeId);
        return x == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeId> bulkNodeToNodeId(List<Node> required, boolean withAllocation) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node n : required) {
                if (this.getNodeIdForNodeCache(n) != null) continue;
                nodes.add(n);
            }
            List<NodeId> x = this.baseTable.bulkNodeToNodeId(nodes, true);
            for (int i = 0; i < nodes.size(); ++i) {
                Node n = (Node)nodes.get(i);
                NodeId nid = x.get(i);
                this.cacheUpdate(n, nid);
            }
            return x;
        }
    }

    @Override
    public List<Node> bulkNodeIdToNode(List<NodeId> nodeIds) {
        return NodeTableOps.bulkNodeIdToNodeImpl(this, nodeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        Node n = this.cacheLookup(id);
        if (n != null) {
            return n;
        }
        Object object = this.lock;
        synchronized (object) {
            n = this.cacheLookup(id);
            if (n != null) {
                return n;
            }
            if (this.baseTable == null) {
                System.err.println("" + this);
            }
            n = this.baseTable.getNodeForNodeId(id);
            this.cacheUpdate(n, id);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeId nodeId = this.cacheLookup(node);
        if (nodeId != null) {
            return nodeId;
        }
        Object object = this.lock;
        synchronized (object) {
            nodeId = this.cacheLookup(node);
            if (nodeId != null) {
                return nodeId;
            }
            nodeId = allocate ? this.baseTable.getAllocateNodeId(node) : this.baseTable.getNodeIdForNode(node);
            this.cacheUpdate(node, nodeId);
            return nodeId;
        }
    }

    private Node cacheLookup(NodeId id) {
        if (this.id2node_Cache == null) {
            return null;
        }
        return this.id2node_Cache.getIfPresent(id);
    }

    private NodeId cacheLookup(Node node) {
        if (this.notPresent != null && this.notPresent.contains(node)) {
            return null;
        }
        if (this.node2id_Cache == null) {
            return null;
        }
        return this.node2id_Cache.getIfPresent(node);
    }

    private void cacheUpdate(Node node, NodeId id) {
        if (node == null) {
            return;
        }
        if (NodeId.isDoesNotExist(id)) {
            if (this.notPresent != null) {
                this.notPresent.add(node);
            }
            return;
        }
        if (id == NodeId.NodeIdAny) {
            Log.warn(this, "Attempt to cache NodeIdAny - ignored");
            return;
        }
        if (this.node2id_Cache != null) {
            this.node2id_Cache.put(node, id);
        }
        if (this.id2node_Cache != null) {
            this.id2node_Cache.put(id, node);
        }
        if (this.notPresent != null && this.notPresent.contains(node)) {
            this.notPresent.remove(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            if (this.node2id_Cache != null) {
                return this.node2id_Cache.isEmpty();
            }
            if (this.id2node_Cache != null) {
                this.id2node_Cache.isEmpty();
            }
            return this.baseTable.isEmpty();
        }
    }

    @Override
    public synchronized void close() {
        if (this.baseTable == null) {
            return;
        }
        this.baseTable.close();
        this.node2id_Cache = null;
        this.id2node_Cache = null;
        this.notPresent = null;
        this.baseTable = null;
    }

    @Override
    public void sync() {
        this.baseTable.sync();
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return this.baseTable.all();
    }

    private void testForConsistency() {
        for (Node n : Iter.toList(this.node2id_Cache.keys())) {
            NodeId nId = this.node2id_Cache.getIfPresent(n);
            if (!this.id2node_Cache.containsKey(nId)) {
                throw new TDBException("Inconsistent: " + n + " => " + nId);
            }
            if (!this.notPresent.contains(n)) continue;
            throw new TDBException("Inconsistent: " + n + " in notPresent cache (1)");
        }
        for (NodeId nId : Iter.toList(this.id2node_Cache.keys())) {
            Node n = this.id2node_Cache.getIfPresent(nId);
            if (!this.node2id_Cache.containsKey(n)) {
                throw new TDBException("Inconsistent: " + nId + " => " + n);
            }
            if (!this.notPresent.contains(n)) continue;
            throw new TDBException("Inconsistent: " + n + " in notPresent cache (2)");
        }
    }

    public String toString() {
        return "Cache(" + this.baseTable.toString() + ")";
    }
}

