/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class TByteBuffer
extends TTransport {
    private final ByteBuffer byteBuffer;

    public TByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public boolean isOpen() {
        return true;
    }

    public void open() {
    }

    public void close() {
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        int n = Math.min(this.byteBuffer.remaining(), len);
        if (n > 0) {
            try {
                this.byteBuffer.get(buf, off, len);
            }
            catch (BufferUnderflowException e2) {
                throw new TTransportException("Unexpected end of input buffer", (Throwable)e2);
            }
        }
        return n;
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.byteBuffer.put(buf, off, len);
        }
        catch (BufferOverflowException e2) {
            throw new TTransportException("Not enough room in output buffer", (Throwable)e2);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public TByteBuffer clear() {
        this.byteBuffer.clear();
        return this;
    }

    public TByteBuffer flip() {
        this.byteBuffer.flip();
        return this;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(data);
        return data;
    }
}

