/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.CompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class ExternalReferencesSheet
extends AbstractSheet {
    ExternalDocRefComparator externalDocRefComparator = new ExternalDocRefComparator();
    static final int NAMESPACE_COL = 0;
    static final String NAMESPACE_TEXT_TITLE = "External Document Namespace";
    static final int NAMESPACE_COL_WIDTH = 80;
    static final int CHECKSUM_COL = 1;
    static final String CHECKSUM_TEXT_TITLE = "External Doc Checksum";
    static final int CHECKSUM_COL_WIDTH = 55;
    static final int FIRST_DOC_ID_COL = 2;
    static final int DOC_ID_COL_WIDTH = 30;

    public ExternalReferencesSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        sheet.setColumnWidth(0, 20480);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell extractedHeaderCell = row.createCell(0);
        extractedHeaderCell.setCellStyle(headerStyle);
        extractedHeaderCell.setCellValue(NAMESPACE_TEXT_TITLE);
        sheet.setColumnWidth(1, 14080);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell checksumHeaderCell = row.createCell(1);
        checksumHeaderCell.setCellStyle(headerStyle);
        checksumHeaderCell.setCellValue(CHECKSUM_TEXT_TITLE);
        for (int i = 2; i < 25; ++i) {
            sheet.setColumnWidth(i, 7680);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int[] refIndexes = new int[comparer.getNumSpdxDocs()];
        ExternalDocumentRef[][] externalRefs = new ExternalDocumentRef[comparer.getNumSpdxDocs()][];
        for (int i = 0; i < externalRefs.length; ++i) {
            Cell headerCell = header.getCell(2 + i);
            headerCell.setCellValue(docNames[i]);
            ExternalDocumentRef[] docExternalRefs = comparer.getSpdxDoc(i).getExternalDocumentRefs();
            Arrays.sort(docExternalRefs, this.externalDocRefComparator);
            externalRefs[i] = docExternalRefs;
            refIndexes[i] = 0;
        }
        while (!this.allExternalRefsExhausted(externalRefs, refIndexes)) {
            Row currentRow = this.addRow();
            ExternalDocumentRef nextRef = this.getNextExternalRef(externalRefs, refIndexes);
            Cell namespaceCell = currentRow.createCell(0);
            namespaceCell.setCellValue(nextRef.getSpdxDocumentNamespace());
            Cell checksumCell = currentRow.createCell(1);
            checksumCell.setCellValue(CompareHelper.checksumToString(nextRef.getChecksum()));
            for (int i = 0; i < externalRefs.length; ++i) {
                if (externalRefs[i].length <= refIndexes[i]) continue;
                ExternalDocumentRef compareRef = externalRefs[i][refIndexes[i]];
                if (!Objects.equal(nextRef.getSpdxDocumentNamespace(), compareRef.getSpdxDocumentNamespace()) || !nextRef.equivalentConsideringNull(nextRef.getChecksum(), compareRef.getChecksum())) continue;
                Cell docIdCell = currentRow.createCell(2 + i);
                docIdCell.setCellValue(externalRefs[i][refIndexes[i]].getExternalDocumentId());
                int n = i;
                refIndexes[n] = refIndexes[n] + 1;
            }
        }
    }

    private ExternalDocumentRef getNextExternalRef(ExternalDocumentRef[][] externalRefs, int[] refIndexes) {
        ExternalDocumentRef retval = null;
        for (int i = 0; i < externalRefs.length; ++i) {
            if (externalRefs[i].length <= refIndexes[i]) continue;
            ExternalDocumentRef candidate = externalRefs[i][refIndexes[i]];
            if (retval != null && this.externalDocRefComparator.compare(retval, candidate) <= 0) continue;
            retval = candidate;
        }
        return retval;
    }

    private boolean allExternalRefsExhausted(ExternalDocumentRef[][] externalRefs, int[] refIndexes) {
        for (int i = 0; i < externalRefs.length; ++i) {
            if (refIndexes[i] >= externalRefs[i].length) continue;
            return false;
        }
        return true;
    }

    private static class ExternalDocRefComparator
    implements Comparator<ExternalDocumentRef>,
    Serializable {
        private static final long serialVersionUID = -4558641025187339674L;

        private ExternalDocRefComparator() {
        }

        @Override
        public int compare(ExternalDocumentRef o1, ExternalDocumentRef o2) {
            if (o1 != null) {
                if (o2 != null) {
                    ExternalDocumentRef r1 = o1;
                    ExternalDocumentRef r2 = o2;
                    int retval = r1.getSpdxDocumentNamespace().compareTo(r2.getSpdxDocumentNamespace());
                    if (retval == 0) {
                        try {
                            return r1.getChecksum().getValue().compareTo(r2.getChecksum().getValue());
                        }
                        catch (InvalidSPDXAnalysisException e2) {
                            return retval;
                        }
                    }
                    return retval;
                }
                return 1;
            }
            return -1;
        }
    }
}

