/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.merge;

import com.google.common.collect.Lists;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.spdx.merge.SpdxLicenseMapper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.JavaSha1ChecksumGenerator;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.VerificationCodeGenerator;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class SpdxPackageInfoMerger {
    @Deprecated
    private SpdxPackage packageInfoResult = null;
    private List<SpdxPackage> packagesResult = null;
    private SpdxDocument[] subDocs = null;
    private SpdxLicenseMapper mapper = null;

    public SpdxPackageInfoMerger(List<SpdxPackage> masterPackagesInfo, SpdxDocument[] subDocs, SpdxLicenseMapper mapper) {
        this.packagesResult = masterPackagesInfo;
        this.subDocs = (SpdxDocument[])subDocs.clone();
        this.mapper = mapper;
    }

    public List<SpdxPackage> mergePackagesInfo(SpdxFile[] fileMergeResult) throws InvalidSPDXAnalysisException, NoSuchAlgorithmException, InvalidLicenseStringException {
        ArrayList<SpdxPackage> retval = Lists.newArrayList(this.clonePackages(this.packagesResult));
        for (int i = 0; i < this.subDocs.length; ++i) {
            List<SpdxPackage> subPackagesInfo = this.subDocs[i].getDocumentContainer().findAllPackages();
            SpdxPackage tempPackage = null;
            for (int p = 0; p < subPackagesInfo.size(); ++p) {
                boolean foundNameMatch = false;
                boolean foundSha1Match = false;
                SpdxItem masterPackage = null;
                Integer index = null;
                tempPackage = subPackagesInfo.get(p);
                for (int q = 0; q < retval.size(); ++q) {
                    if (((SpdxPackage)retval.get(q)).getName().equalsIgnoreCase(tempPackage.getName())) {
                        foundNameMatch = true;
                    }
                    if (!((SpdxPackage)retval.get(q)).getSha1().equals(tempPackage.getSha1())) continue;
                    foundSha1Match = true;
                    masterPackage = (SpdxPackage)retval.get(q);
                    index = q;
                    break;
                }
                if (!foundNameMatch && !foundSha1Match) {
                    AnyLicenseInfo[] licFromFile = this.checkLicenseFromFile(this.subDocs[i], tempPackage);
                    tempPackage.setLicenseInfosFromFiles(licFromFile);
                    retval.add(tempPackage);
                    continue;
                }
                AnyLicenseInfo[] masterLicFromFile = masterPackage.getLicenseInfoFromFiles();
                AnyLicenseInfo[] licFromFile = this.checkLicenseFromFile(this.subDocs[i], tempPackage);
                ArrayList<AnyLicenseInfo> licList = Lists.newArrayList(masterLicFromFile);
                for (int g = 0; g < licFromFile.length; ++g) {
                    for (int d = 0; d < licList.size() && !licList.get(d).equals(licFromFile[g]); ++d) {
                        licList.add(licFromFile[g]);
                    }
                }
                AnyLicenseInfo[] mergedLicFromFile = licList.toArray(new AnyLicenseInfo[licList.size()]);
                masterPackage.setLicenseInfosFromFiles(mergedLicFromFile);
                String[] skippedFiles = this.collectSkippedFiles((SpdxPackage)masterPackage, tempPackage);
                VerificationCodeGenerator verCodeGenerator = new VerificationCodeGenerator(new JavaSha1ChecksumGenerator());
                SpdxPackageVerificationCode newCode = verCodeGenerator.generatePackageVerificationCode(fileMergeResult, skippedFiles);
                ((SpdxPackage)masterPackage).setPackageVerificationCode(newCode);
                String supplierInfo = this.stringCombiner(((SpdxPackage)masterPackage).getSupplier(), tempPackage.getSupplier());
                ((SpdxPackage)masterPackage).setSupplier(supplierInfo);
                String originator = this.stringCombiner(((SpdxPackage)masterPackage).getOriginator(), tempPackage.getOriginator());
                ((SpdxPackage)masterPackage).setOriginator(originator);
                String homePage = this.stringCombiner(((SpdxPackage)masterPackage).getHomepage(), tempPackage.getHomepage());
                ((SpdxPackage)masterPackage).setHomepage(homePage);
                String downloadLocation = this.stringCombiner(((SpdxPackage)masterPackage).getDownloadLocation(), tempPackage.getDownloadLocation());
                ((SpdxPackage)masterPackage).setDownloadLocation(downloadLocation);
                String sourceInfo = this.stringCombiner(((SpdxPackage)masterPackage).getSourceInfo(), tempPackage.getSourceInfo());
                ((SpdxPackage)masterPackage).setSourceInfo(sourceInfo);
                AnyLicenseInfo licDeclared1 = ((SpdxPackage)masterPackage).getLicenseDeclared();
                AnyLicenseInfo licDeclared2 = this.mapper.mapLicenseInfo(this.subDocs[i], tempPackage.getLicenseDeclared());
                AnyLicenseInfo licDeclared = this.licsCombiner(licDeclared1, licDeclared2);
                ((SpdxPackage)masterPackage).setLicenseDeclared(licDeclared);
                AnyLicenseInfo licConcluded1 = masterPackage.getLicenseConcluded();
                AnyLicenseInfo licConcluded2 = this.mapper.mapLicenseInfo(this.subDocs[i], tempPackage.getLicenseConcluded());
                AnyLicenseInfo licConcluded = this.licsCombiner(licConcluded1, licConcluded2);
                masterPackage.setLicenseConcluded(licConcluded);
                String licenseComments = this.stringCombiner(masterPackage.getLicenseComments(), tempPackage.getLicenseComments());
                masterPackage.setLicenseComments(licenseComments);
                String summary = this.stringCombiner(((SpdxPackage)masterPackage).getSummary(), tempPackage.getSummary());
                ((SpdxPackage)masterPackage).setSummary(summary);
                String description = this.stringCombiner(((SpdxPackage)masterPackage).getDescription(), tempPackage.getDescription());
                ((SpdxPackage)masterPackage).setDescription(description);
                String usrDefined = this.stringCombiner(masterPackage.getComment(), tempPackage.getComment());
                masterPackage.setComment(usrDefined);
                retval.set(index, (SpdxPackage)masterPackage);
            }
        }
        return this.packagesResult;
    }

    public AnyLicenseInfo[] checkLicenseFromFile(SpdxDocument doc, SpdxPackage temp) {
        AnyLicenseInfo[] licFromFile = temp.getLicenseInfoFromFiles();
        for (int k = 0; k < licFromFile.length; ++k) {
            AnyLicenseInfo tempLicense;
            if (!(licFromFile[k] instanceof ExtractedLicenseInfo)) continue;
            licFromFile[k] = tempLicense = this.mapper.mapNonStdLicInMap(doc, licFromFile[k]);
        }
        return licFromFile;
    }

    public List<SpdxPackage> clonePackages(List<SpdxPackage> packagesList) {
        ArrayList<SpdxPackage> clonedPackagesList = Lists.newArrayList();
        for (int h = 0; h < packagesList.size(); ++h) {
            clonedPackagesList.add(packagesList.get(h).clone());
        }
        return clonedPackagesList;
    }

    public String stringCombiner(String line1, String line2) {
        StringBuilder buffer = new StringBuilder();
        if (line1.isEmpty() && line2.isEmpty()) {
            return buffer.toString();
        }
        if (!line1.isEmpty()) {
            buffer.append(line1);
            if (!line1.equalsIgnoreCase(line2) && !line2.isEmpty()) {
                buffer.append(" " + line2);
            }
        } else {
            buffer.append(line2);
        }
        return buffer.toString();
    }

    public AnyLicenseInfo licsCombiner(AnyLicenseInfo lic1, AnyLicenseInfo lic2) throws InvalidLicenseStringException {
        StringBuilder buffer = new StringBuilder(lic1.toString());
        if (!lic1.equals(lic2)) {
            buffer.append(" " + lic2.toString());
        }
        return LicenseInfoFactory.parseSPDXLicenseString(buffer.toString());
    }

    public String[] collectSkippedFiles(SpdxPackage main, SpdxPackage sub) throws InvalidSPDXAnalysisException {
        ArrayList<Object> excludedFileNamesList = Lists.newArrayList();
        String[] retval = sub.getPackageVerificationCode().getExcludedFileNames();
        String[] skippedFileInMain = main.getPackageVerificationCode().getExcludedFileNames();
        if (skippedFileInMain.length == 0 && retval.length == 0) {
            String[] excludedFileNamesArray = new String[]{};
            return excludedFileNamesArray;
        }
        if (skippedFileInMain.length != 0) {
            excludedFileNamesList = Lists.newArrayList(skippedFileInMain);
        } else if (excludedFileNamesList.isEmpty() && retval.length != 0) {
            excludedFileNamesList = Lists.newArrayList(retval);
        } else {
            for (int k = 0; k < retval.length; ++k) {
                boolean foundNameMatch = false;
                for (int q = 0; q < excludedFileNamesList.size(); ++q) {
                    if (!retval[k].equalsIgnoreCase((String)excludedFileNamesList.get(q))) continue;
                    foundNameMatch = true;
                }
                if (foundNameMatch) continue;
                excludedFileNamesList.add(retval[k]);
            }
        }
        String[] excludedFileNamesArray = new String[excludedFileNamesList.size()];
        excludedFileNamesList.toArray(excludedFileNamesArray);
        excludedFileNamesList.clear();
        return excludedFileNamesArray;
    }

    @Deprecated
    public String translateSubDelcaredLicsIntoComments(SpdxDocument[] subDocs) throws InvalidSPDXAnalysisException {
        SpdxLicenseMapper mapper = new SpdxLicenseMapper();
        if (!mapper.isNonStdLicIdMapEmpty()) {
            StringBuilder buffer = new StringBuilder(this.packageInfoResult.getLicenseComments() + ". This package merged several packages and the sub-package contain the following licenses:");
            for (int k = 0; k < subDocs.length; ++k) {
                List<SpdxPackage> tempList;
                if (mapper.docInNonStdLicIdMap(subDocs[k])) {
                    tempList = subDocs[k].getDocumentContainer().findAllPackages();
                    for (int h = 0; h < tempList.size(); ++h) {
                        AnyLicenseInfo license = tempList.get(h).getLicenseDeclared();
                        AnyLicenseInfo result = mapper.mapLicenseInfo(subDocs[k], license);
                        buffer.append(tempList.get(h).getPackageFileName());
                        buffer.append(" (" + result.toString() + ") ");
                    }
                    continue;
                }
                tempList = subDocs[k].getDocumentContainer().findAllPackages();
                for (int q = 0; q < tempList.size(); ++q) {
                    buffer.append(tempList.get(q).getPackageFileName());
                    buffer.append(" (" + tempList.get(q).getLicenseDeclared().toString() + ") ");
                }
            }
            return buffer.toString();
        }
        return this.packageInfoResult.getLicenseComments();
    }
}

