/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SpdxPackageVerificationCode {
    private String value;
    private List<String> excludedFileNames = Lists.newArrayList();
    private Model model;
    private Node verificationCodeNode;
    private Resource verificationCodeResource;

    public SpdxPackageVerificationCode(String value, String[] excludedFileNames) {
        this.value = value;
        if (excludedFileNames != null) {
            for (String fileName : excludedFileNames) {
                this.excludedFileNames.add(fileName);
            }
        }
        this.model = null;
        this.verificationCodeNode = null;
        this.verificationCodeResource = null;
    }

    public SpdxPackageVerificationCode(Model model, Node verificationCodeNode) throws InvalidSPDXAnalysisException {
        Triple t;
        this.model = model;
        this.verificationCodeNode = verificationCodeNode;
        if (verificationCodeNode.isBlank()) {
            this.verificationCodeResource = model.createResource(new AnonId(verificationCodeNode.getBlankNodeId()));
        } else if (verificationCodeNode.isURI()) {
            this.verificationCodeResource = model.createResource(verificationCodeNode.getURI());
        } else {
            throw new InvalidSPDXAnalysisException("Verification code node can not be a literal");
        }
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile").asNode();
        Triple m = Triple.createMatch(verificationCodeNode, p, null);
        ExtendedIterator<Triple> tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.excludedFileNames.add(t.getObject().toString(false));
        }
        p = model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue").asNode();
        m = Triple.createMatch(verificationCodeNode, p, null);
        tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.value = t.getObject().toString(false);
        }
    }

    public Resource createResource(Model model) {
        this.model = model;
        Resource type = model.createResource("http://spdx.org/rdf/terms#PackageVerificationCode");
        Resource r = model.createResource(type);
        if (this.excludedFileNames.size() > 0) {
            Property excludedFileProp = model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile");
            for (int i = 0; i < this.excludedFileNames.size(); ++i) {
                r.addProperty(excludedFileProp, this.excludedFileNames.get(i));
            }
        }
        if (this.value != null && !this.value.isEmpty()) {
            Property valueProperty = model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue");
            r.addProperty(valueProperty, this.value);
        }
        this.verificationCodeNode = r.asNode();
        this.verificationCodeResource = r;
        return r;
    }

    public String[] getExcludedFileNames() {
        String[] retval = this.excludedFileNames.toArray(new String[this.excludedFileNames.size()]);
        return retval;
    }

    public void setExcludedFileNames(String[] excludedFileNames) {
        this.excludedFileNames.clear();
        if (this.verificationCodeNode != null && this.model != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile");
            this.model.removeAll(this.verificationCodeResource, p, null);
        }
        for (int i = 0; i < excludedFileNames.length; ++i) {
            this.addExcludedFileName(excludedFileNames[i]);
        }
    }

    public void addExcludedFileName(String excludedFileName) {
        this.excludedFileNames.add(excludedFileName);
        if (this.verificationCodeNode != null && this.model != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeExcludedFile");
            this.verificationCodeResource.addProperty(p, excludedFileName);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.model != null && this.verificationCodeNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue");
            this.model.removeAll(this.verificationCodeResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue");
            this.verificationCodeResource.addProperty(p, value);
        }
    }

    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        String value = this.getValue();
        if (value == null || value.isEmpty()) {
            retval.add("Missing required verification code value");
        } else {
            String verify = SpdxVerificationHelper.verifyChecksumString(value);
            if (verify != null) {
                retval.add(verify);
            }
        }
        return retval;
    }

    public boolean equivalent(SpdxPackageVerificationCode comp) {
        if (comp == null) {
            return false;
        }
        return SpdxVerificationHelper.equalsWithNull(this.getValue(), comp.getValue()) && SpdxVerificationHelper.equivalentArray(this.getExcludedFileNames(), comp.getExcludedFileNames());
    }
}

