/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.DuplicateExtractedLicenseIdException;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.IRdfModel;

public class ExtractedLicenseInfo
extends SimpleLicensingInfo
implements Comparable<ExtractedLicenseInfo> {
    private String extractedText;

    public ExtractedLicenseInfo(IModelContainer modelContainer, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseInfoNode);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.extractedText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "extractedText");
    }

    public ExtractedLicenseInfo(String id, String text, String licenseName, String[] crossReferenceUrls, String comment) {
        super(licenseName, id, comment, crossReferenceUrls);
        this.extractedText = text;
    }

    public ExtractedLicenseInfo(String licenseID, String licenseText) {
        this(licenseID, licenseText, null, null, null);
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        String existingLicenseText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "extractedText");
        if (existingLicenseText != null && this.extractedText != null && !LicenseCompareHelper.isLicenseTextEquivalent(existingLicenseText, this.extractedText)) {
            throw new DuplicateExtractedLicenseIdException("Non-standard license ID " + this.licenseId + " already exists.  Can not add a license with the same ID but different text.");
        }
        this.setPropertyValue("http://spdx.org/rdf/terms#", "extractedText", this.extractedText);
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#ExtractedLicensingInfo");
    }

    @Override
    public String toString() {
        return this.licenseId;
    }

    public String getExtractedText() {
        if (this.resource != null && this.refreshOnGet) {
            this.extractedText = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "extractedText");
        }
        return this.extractedText;
    }

    public void setExtractedText(String text) {
        this.extractedText = text;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "extractedText", text);
    }

    @Override
    public int hashCode() {
        if (this.getLicenseId() == null) {
            return 0;
        }
        return this.getLicenseId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtractedLicenseInfo)) {
            return false;
        }
        ExtractedLicenseInfo comp = (ExtractedLicenseInfo)o;
        if (this.licenseId == null) {
            return comp.getLicenseId() == null;
        }
        return this.licenseId.equalsIgnoreCase(comp.getLicenseId());
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        String id = this.getLicenseId();
        if (id == null || id.isEmpty()) {
            retval.add("Missing required license ID");
        } else {
            String idError = SpdxVerificationHelper.verifyNonStdLicenseid(id);
            if (idError != null && !idError.isEmpty()) {
                retval.add(idError);
            }
        }
        String licenseText = this.getExtractedText();
        if (licenseText == null || licenseText.isEmpty()) {
            retval.add("Missing required license text for " + id);
        }
        try {
            if (this.node != null) {
                Node p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
                Triple m = Triple.createMatch(this.node, p, null);
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
                int count = 0;
                while (tripleIter.hasNext()) {
                    ++count;
                    tripleIter.next();
                }
                if (count > 1) {
                    retval.add("More than one comment on Extracted License Info id " + id.toString());
                }
            }
        }
        catch (Exception e2) {
            retval.add("Error getting license comments: " + e2.getMessage());
        }
        return retval;
    }

    @Override
    public AnyLicenseInfo clone() {
        return new ExtractedLicenseInfo(this.getLicenseId(), this.getExtractedText(), this.getName(), this.getSeeAlso(), this.getComment());
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (!(compare instanceof ExtractedLicenseInfo)) {
            return false;
        }
        return LicenseCompareHelper.isLicenseTextEquivalent(this.getExtractedText(), ((ExtractedLicenseInfo)compare).getExtractedText());
    }

    @Override
    public int compareTo(ExtractedLicenseInfo o) {
        if (this.getLicenseId() == null) {
            if (o.getLicenseId() == null) {
                if (this.getExtractedText() == null) {
                    if (o.getExtractedText() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o.getExtractedText() == null) {
                    return -1;
                }
                return this.getExtractedText().compareToIgnoreCase(o.getExtractedText());
            }
            return 1;
        }
        if (o.getLicenseId() == null) {
            return -1;
        }
        return this.getLicenseId().compareToIgnoreCase(o.getLicenseId());
    }
}

