/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class LicenseJsonTOC {
    private String licenseListVersion;
    private LicenseJson[] licenses;
    private String releaseDate;

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public LicenseJson[] getLicenses() {
        return this.licenses;
    }

    public Set<String> getLicenseIds() {
        HashSet<String> retval = Sets.newHashSet();
        if (this.licenses == null) {
            return retval;
        }
        for (LicenseJson license : this.licenses) {
            retval.add(license.licenseId);
        }
        return retval;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    class LicenseJson {
        private String reference;
        private boolean isDeprecatedLicenseId;
        private String detailsUrl;
        private int referenceNumber;
        private String name;
        private String licenseId;
        private String[] seeAlso;
        private boolean isOsiApproved;

        LicenseJson() {
        }

        public String getReference() {
            return this.reference;
        }

        public boolean isDeprecatedLicenseId() {
            return this.isDeprecatedLicenseId;
        }

        public String getDetailsUrl() {
            return this.detailsUrl;
        }

        public int getReferenceNumber() {
            return this.referenceNumber;
        }

        public String getName() {
            return this.name;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public String[] getSeeAlso() {
            return this.seeAlso;
        }

        public boolean isOsiApproved() {
            return this.isOsiApproved;
        }
    }
}

