/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.rdfparser.license.ListedLicenseException;

public class ExceptionHtml {
    static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    static final String TEMPLATE_ROOT_PATH = "resources" + File.separator + "htmlTemplate";
    static final String HTML_TEMPLATE = "ExceptionHTMLTemplate.html";
    Map<String, Object> mustacheMap = Maps.newHashMap();

    public ExceptionHtml(ListedLicenseException exception) throws InvalidLicenseTemplateException {
        ArrayList alSourceUrls = Lists.newArrayList();
        String[] sourceUrls = exception.getSeeAlso();
        if (sourceUrls != null) {
            for (String sourceUrl : sourceUrls) {
                alSourceUrls.add(sourceUrl);
            }
        }
        this.mustacheMap.put("name", exception.getName());
        this.mustacheMap.put("id", exception.getLicenseExceptionId());
        this.mustacheMap.put("text", exception.getExceptionTextHtml());
        this.mustacheMap.put("getSourceUrl", alSourceUrls);
        this.mustacheMap.put("notes", exception.getComment());
        this.mustacheMap.put("deprecated", exception.isDeprecated());
        this.mustacheMap.put("deprecatedVersion", exception.getDeprecatedVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File exceptionHtmlFile, String exceptionHtmlTocReference) throws IOException, MustacheException {
        this.mustacheMap.put("exceptionTocReference", exceptionHtmlTocReference);
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!exceptionHtmlFile.exists() && !exceptionHtmlFile.createNewFile()) {
            throw new IOException("Can not create new file " + exceptionHtmlFile.getName());
        }
        String templateDirName = TEMPLATE_ROOT_PATH;
        File templateDirectoryRoot = new File(templateDirName);
        if (!templateDirectoryRoot.exists() || !templateDirectoryRoot.isDirectory()) {
            templateDirName = TEMPLATE_CLASS_PATH;
        }
        try {
            stream = new FileOutputStream(exceptionHtmlFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DefaultMustacheFactory builder = new DefaultMustacheFactory(templateDirName);
            Mustache mustache = builder.compile(HTML_TEMPLATE);
            mustache.execute((Writer)writer, this.mustacheMap);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }
}

