/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.rdfparser.license.LicenseException;

public class ExceptionHtmlToc {
    static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    static final String TEMPLATE_ROOT_PATH = "resources" + File.separator + "htmlTemplate";
    static final String HTML_TEMPLATE = "ExceptionsTocHTMLTemplate.html";
    List<ExceptionRow> exceptions = Lists.newArrayList();
    List<DeprecatedExceptionRow> deprecatedExceptions = Lists.newArrayList();
    int currentRefNum = 1;

    public void addException(LicenseException exception, String exceptionHTMLReference) {
        this.exceptions.add(new ExceptionRow(StringEscapeUtils.escapeHtml4((String)exception.getLicenseExceptionId()), StringEscapeUtils.escapeHtml4((String)exception.getName()), this.currentRefNum++, exceptionHTMLReference));
    }

    public void addDeprecatedException(LicenseException exception, String exceptionHTMLReference, String deprecatedVersion) {
        this.deprecatedExceptions.add(new DeprecatedExceptionRow(StringEscapeUtils.escapeHtml4((String)exception.getLicenseExceptionId()), StringEscapeUtils.escapeHtml4((String)exception.getName()), this.currentRefNum++, exceptionHTMLReference, deprecatedVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File exceptionTocFile, String version) throws MustacheException, IOException {
        HashMap mustacheMap = Maps.newHashMap();
        mustacheMap.put("version", StringEscapeUtils.escapeHtml4((String)version));
        mustacheMap.put("listedExceptions", this.exceptions);
        mustacheMap.put("deprecatedExceptions", this.deprecatedExceptions);
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!exceptionTocFile.exists() && !exceptionTocFile.createNewFile()) {
            throw new IOException("Can not create new file " + exceptionTocFile.getName());
        }
        String templateDirName = TEMPLATE_ROOT_PATH;
        File templateDirectoryRoot = new File(templateDirName);
        if (!templateDirectoryRoot.exists() || !templateDirectoryRoot.isDirectory()) {
            templateDirName = TEMPLATE_CLASS_PATH;
        }
        try {
            stream = new FileOutputStream(exceptionTocFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DefaultMustacheFactory builder = new DefaultMustacheFactory(templateDirName);
            Mustache mustache = builder.compile(HTML_TEMPLATE);
            mustache.execute((Writer)writer, (Object)mustacheMap);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static class ExceptionRow {
        private int refNumber;
        private String reference;
        private String exceptionName;
        private String licenseExceptionId;

        public int getRefNumber() {
            return this.refNumber;
        }

        public void setRefNumber(int refNumber) {
            this.refNumber = refNumber;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getExceptionName() {
            return this.exceptionName;
        }

        public void setExceptionName(String exceptionName) {
            this.exceptionName = exceptionName;
        }

        public String getLicenseExceptionId() {
            return this.licenseExceptionId;
        }

        public void setLicenseExceptionId(String licenseExceptionId) {
            this.licenseExceptionId = licenseExceptionId;
        }

        public ExceptionRow(String licenseExceptionId, String exceptionName, int refNumber, String reference) {
            this.licenseExceptionId = licenseExceptionId;
            this.exceptionName = exceptionName;
            this.refNumber = refNumber;
            this.reference = reference;
        }
    }

    public static class DeprecatedExceptionRow {
        private int refNumber;
        String licenseExceptionId;
        private String reference;
        private String exceptionName;
        private String deprecatedVersion;

        public DeprecatedExceptionRow(String licenseExceptionId, String exceptionName, int refNumber, String reference, String deprecatedVersion) {
            this.licenseExceptionId = licenseExceptionId;
            this.exceptionName = exceptionName;
            this.refNumber = refNumber;
            this.reference = reference;
            this.deprecatedVersion = deprecatedVersion;
        }

        public String getLicenseExceptionId() {
            return this.licenseExceptionId;
        }

        public void setLicenseExceptionId(String licenseExceptionId) {
            this.licenseExceptionId = licenseExceptionId;
        }

        public int getRefNumber() {
            return this.refNumber;
        }

        public void setRefNumber(int refNumber) {
            this.refNumber = refNumber;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getExceptionName() {
            return this.exceptionName;
        }

        public void setExceptionName(String exceptionName) {
            this.exceptionName = exceptionName;
        }

        public String getDeprecatedVersion() {
            return this.deprecatedVersion;
        }

        public void setDeprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
        }
    }
}

