/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheetV09d2;
import org.spdx.spdxspreadsheet.PackageInfoSheetV09d3;
import org.spdx.spdxspreadsheet.PackageInfoSheetV1d2;
import org.spdx.spdxspreadsheet.PackageInfoSheetV2d0;
import org.spdx.spdxspreadsheet.PackageInfoSheetV2d1;
import org.spdx.spdxspreadsheet.PackageInfoSheetV9d1;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public abstract class PackageInfoSheet
extends AbstractSheet {
    protected String version;

    public PackageInfoSheet(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName);
        this.version = version;
    }

    public abstract void add(SpdxPackage var1) throws InvalidSPDXAnalysisException;

    public static String licensesToString(AnyLicenseInfo[] licenses) {
        if (licenses == null || licenses.length == 0) {
            return "";
        }
        if (licenses.length == 1) {
            return licenses[0].toString();
        }
        StringBuilder sb = new StringBuilder(licenses[0].toString());
        for (int i = 1; i < licenses.length; ++i) {
            sb.append(", ");
            sb.append(licenses[i].toString());
        }
        return sb.toString();
    }

    public static void create(Workbook wb, String sheetName) {
        PackageInfoSheetV2d1.create(wb, sheetName);
    }

    public static PackageInfoSheet openVersion(Workbook workbook, String packageInfoSheetName, String version) {
        if (version.compareTo("0.9.1") <= 0) {
            return new PackageInfoSheetV9d1(workbook, packageInfoSheetName, version);
        }
        if (version.compareTo("0.9.2") <= 0) {
            return new PackageInfoSheetV09d2(workbook, packageInfoSheetName, version);
        }
        if (version.compareTo("1.1.0") <= 0) {
            return new PackageInfoSheetV09d3(workbook, packageInfoSheetName, version);
        }
        if (version.compareTo("1.2.0") <= 0) {
            return new PackageInfoSheetV1d2(workbook, packageInfoSheetName, version);
        }
        if (version.compareTo("2.0.0") <= 0) {
            return new PackageInfoSheetV2d0(workbook, packageInfoSheetName, version);
        }
        return new PackageInfoSheetV2d1(workbook, packageInfoSheetName, version);
    }

    public abstract SpdxPackage[] getPackages(SpdxDocumentContainer var1) throws SpreadsheetException;
}

