/**
 * Copyright (c) 2014 Source Auditor Inc.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
*/
package org.spdx.rdfparser;

/**
 * Exception for non standard license IDs where a numeric value is expected and 
 * no numeric value is found
 * @author Gary O'Neall
 *
 */
public class NonNumericLicenseIdException extends InvalidSPDXAnalysisException {

	/**
	 * @param msg
	 */
	public NonNumericLicenseIdException(String msg) {
		super(msg);
	}
	
	public NonNumericLicenseIdException(String msg, Exception inner) {
		super(msg, inner);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 3276217047461134627L;

}
