/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfParserHelper;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;

public class Checksum
extends RdfModelObject
implements Comparable<Checksum> {
    static final Logger logger = LoggerFactory.getLogger(Checksum.class);
    public static final ImmutableMap<ChecksumAlgorithm, String> CHECKSUM_ALGORITHM_TO_TAG = new ImmutableMap.Builder().put((Object)ChecksumAlgorithm.checksumAlgorithm_md5, (Object)"MD5:").put((Object)ChecksumAlgorithm.checksumAlgorithm_sha1, (Object)"SHA1:").put((Object)ChecksumAlgorithm.checksumAlgorithm_sha256, (Object)"SHA256:").build();
    public static final ImmutableMap<String, ChecksumAlgorithm> CHECKSUM_TAG_TO_ALGORITHM = new ImmutableMap.Builder().put((Object)"MD5:", (Object)ChecksumAlgorithm.checksumAlgorithm_md5).put((Object)"SHA1:", (Object)ChecksumAlgorithm.checksumAlgorithm_sha1).put((Object)"SHA256:", (Object)ChecksumAlgorithm.checksumAlgorithm_sha256).build();
    ChecksumAlgorithm algorithm;
    String checksumValue;

    protected static Resource findSpdxChecksum(Model model, Checksum checksum) throws InvalidSPDXAnalysisException {
        if (checksum == null || checksum.algorithm == null || checksum.checksumValue == null) {
            return null;
        }
        Node checksumValueProperty = model.getProperty("http://spdx.org/rdf/terms#", "checksumValue").asNode();
        Triple checksumValueMatch = Triple.createMatch(null, (Node)checksumValueProperty, (Node)NodeFactory.createLiteral((String)checksum.getValue()));
        ExtendedIterator checksumMatchIter = model.getGraph().find(checksumValueMatch);
        while (checksumMatchIter.hasNext()) {
            Triple checksumMatchTriple = (Triple)checksumMatchIter.next();
            Node checksumNode = checksumMatchTriple.getSubject();
            Node algorithmProperty = model.getProperty("http://spdx.org/rdf/terms#", "algorithm").asNode();
            Triple algorithmMatch = Triple.createMatch((Node)checksumNode, (Node)algorithmProperty, null);
            ExtendedIterator algorithmMatchIterator = model.getGraph().find(algorithmMatch);
            if (!algorithmMatchIterator.hasNext()) continue;
            String algorithm = "UNKNOWN";
            Triple algorithmMatchTriple = (Triple)algorithmMatchIterator.next();
            if (!algorithmMatchTriple.getObject().isURI()) continue;
            algorithm = algorithmMatchTriple.getObject().getURI().substring("http://spdx.org/rdf/terms#".length());
            if (algorithm == null) {
                algorithm = "UNKNOWN";
            }
            if (!algorithm.equals(checksum.getAlgorithm().toString())) continue;
            return RdfParserHelper.convertToResource(model, checksumNode);
        }
        return null;
    }

    public Checksum(ChecksumAlgorithm algorithm, String checksumValue) {
        this.algorithm = algorithm;
        this.checksumValue = checksumValue;
    }

    public Checksum(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        String algorithmUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "algorithm");
        if (algorithmUri != null && !algorithmUri.isEmpty()) {
            if (!algorithmUri.startsWith("http://spdx.org/rdf/terms#")) {
                throw new InvalidSPDXAnalysisException("Invalid checksum algorithm: " + algorithmUri);
            }
            String algorithmS = algorithmUri.substring("http://spdx.org/rdf/terms#".length());
            try {
                this.algorithm = ChecksumAlgorithm.valueOf(algorithmS);
            }
            catch (Exception ex) {
                logger.error("Invalid checksum algorithm in the model - " + algorithmS);
                throw new InvalidSPDXAnalysisException("Invalid checksum algorithm: " + algorithmS);
            }
        }
        this.checksumValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "checksumValue");
    }

    public ChecksumAlgorithm getAlgorithm() {
        if (this.resource != null && this.refreshOnGet) {
            String algorithmUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "algorithm");
            if (algorithmUri != null && !algorithmUri.isEmpty()) {
                if (!algorithmUri.startsWith("http://spdx.org/rdf/terms#")) {
                    logger.error("Invalid checksum algorithm in the model - " + algorithmUri);
                } else {
                    String algorithmS = algorithmUri.substring("http://spdx.org/rdf/terms#".length());
                    try {
                        this.algorithm = ChecksumAlgorithm.valueOf(algorithmS);
                    }
                    catch (Exception ex) {
                        logger.error("Invalid checksum algorithm in the model - " + algorithmS);
                        this.algorithm = null;
                    }
                }
            } else {
                this.algorithm = null;
            }
        }
        return this.algorithm;
    }

    public void setAlgorithm(ChecksumAlgorithm algorithm) throws InvalidSPDXAnalysisException {
        this.algorithm = algorithm;
        if (algorithm == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "algorithm");
        } else {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "algorithm", "http://spdx.org/rdf/terms#" + this.algorithm.toString());
        }
    }

    public String getValue() {
        if (this.resource != null && this.refreshOnGet) {
            this.checksumValue = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "checksumValue");
        }
        return this.checksumValue;
    }

    public void setValue(String checksumValue) {
        this.checksumValue = checksumValue;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "checksumValue", checksumValue);
    }

    @Override
    public List<String> verify() {
        ArrayList retval = Lists.newArrayList();
        if (this.algorithm == null) {
            retval.add("Missing required algorithm");
        }
        if (this.checksumValue == null || this.checksumValue.isEmpty()) {
            retval.add("Missing required checksum value");
        } else {
            String verify = SpdxVerificationHelper.verifyChecksumString(this.checksumValue, this.algorithm);
            if (verify != null) {
                retval.add(verify);
            }
        }
        return retval;
    }

    @Override
    public String getUri(IModelContainer modelContainer) {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#Checksum");
    }

    @Override
    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        return Checksum.findSpdxChecksum(modelContainer.getModel(), this);
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        if (this.algorithm == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "algorithm");
        } else {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "algorithm", "http://spdx.org/rdf/terms#" + this.algorithm.toString());
        }
        this.setPropertyValue("http://spdx.org/rdf/terms#", "checksumValue", this.checksumValue);
    }

    public Checksum clone() {
        return new Checksum(this.algorithm, this.checksumValue);
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof Checksum)) {
            return false;
        }
        Checksum cksum = (Checksum)compare;
        return Objects.equal((Object)((Object)this.getAlgorithm()), (Object)((Object)cksum.getAlgorithm())) && Objects.equal((Object)this.getValue(), (Object)cksum.getValue());
    }

    public String toString() {
        if (this.algorithm == null || this.checksumValue == null) {
            return "";
        }
        return (String)CHECKSUM_ALGORITHM_TO_TAG.get((Object)this.algorithm) + " " + this.checksumValue;
    }

    @Override
    public int compareTo(Checksum compare) {
        int retval = 0;
        retval = this.getAlgorithm() == null ? (compare.getAlgorithm() != null ? 1 : 0) : (compare.getAlgorithm() == null ? -1 : ((String)CHECKSUM_ALGORITHM_TO_TAG.get((Object)this.getAlgorithm())).compareTo((String)CHECKSUM_ALGORITHM_TO_TAG.get((Object)compare.getAlgorithm())));
        if (retval == 0) {
            retval = this.getValue() == null ? (compare.getValue() != null ? 1 : 0) : (compare.getValue() == null ? -1 : this.getValue().compareTo(compare.getValue()));
        }
        return retval;
    }

    public static enum ChecksumAlgorithm {
        checksumAlgorithm_sha1,
        checksumAlgorithm_sha256,
        checksumAlgorithm_md5;

    }
}

