/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SPDXCreatorInformation {
    private String[] creators = null;
    private String comment = null;
    private String createdDate = null;
    private String licenseListVersion = null;
    private Node creatorNode = null;
    private Model model = null;
    private Resource creatorResource = null;

    public String[] getCreators() {
        return this.creators;
    }

    public void setCreators(String[] creators) {
        this.creators = creators;
        if (this.creatorNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "creator");
            this.model.removeAll(this.creatorResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "creator");
            for (int i = 0; i < creators.length; ++i) {
                this.creatorResource.addProperty(p, creators[i]);
            }
        }
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public void setLicenseListVersion(String licenseListVersion) {
        this.licenseListVersion = licenseListVersion;
        if (this.creatorNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseListVersion");
            this.model.removeAll(this.creatorResource, p, null);
            if (this.licenseListVersion != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseListVersion");
                this.creatorResource.addProperty(p, this.licenseListVersion);
            }
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.creatorNode != null) {
            Property p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.creatorResource, p, null);
            if (comment != null) {
                p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
                this.creatorResource.addProperty(p, comment);
            }
        }
    }

    public SPDXCreatorInformation(String[] creators, String createdDate, String comment, String licenseListVersion) {
        this.creators = creators;
        this.createdDate = createdDate;
        this.comment = comment;
        this.licenseListVersion = licenseListVersion;
    }

    public SPDXCreatorInformation(Model spdxModel, Node creatorNode) throws InvalidSPDXAnalysisException {
        Triple t;
        this.model = spdxModel;
        this.creatorNode = creatorNode;
        if (creatorNode.isBlank()) {
            this.creatorResource = this.model.createResource(new AnonId(creatorNode.getBlankNodeId()));
        } else if (creatorNode.isURI()) {
            this.creatorResource = this.model.createResource(creatorNode.getURI());
        } else {
            throw new InvalidSPDXAnalysisException("Creator node can not be a literal");
        }
        Node p = spdxModel.getProperty("http://spdx.org/rdf/terms#", "creator").asNode();
        Triple m = Triple.createMatch((Node)creatorNode, (Node)p, null);
        ExtendedIterator tripleIter = spdxModel.getGraph().find(m);
        ArrayList alCreators = Lists.newArrayList();
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alCreators.add(t.getObject().toString(false));
        }
        this.creators = alCreators.toArray(new String[alCreators.size()]);
        p = spdxModel.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m = Triple.createMatch((Node)creatorNode, (Node)p, null);
        tripleIter = spdxModel.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.comment = t.getObject().toString(false);
        }
        p = spdxModel.getProperty("http://spdx.org/rdf/terms#", "created").asNode();
        m = Triple.createMatch((Node)creatorNode, (Node)p, null);
        tripleIter = spdxModel.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.createdDate = t.getObject().toString(false);
        }
        p = spdxModel.getProperty("http://spdx.org/rdf/terms#", "licenseListVersion").asNode();
        m = Triple.createMatch((Node)creatorNode, (Node)p, null);
        tripleIter = spdxModel.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.licenseListVersion = t.getObject().toString(false);
        }
    }

    public Resource createResource(Model model) {
        Property createdDateProperty;
        this.model = model;
        Resource type = model.createResource("http://spdx.org/rdf/terms#CreationInfo");
        Resource r = model.createResource(type);
        if (this.creators != null && this.creators.length > 0) {
            Property nameProperty = model.createProperty("http://spdx.org/rdf/terms#", "creator");
            for (int i = 0; i < this.creators.length; ++i) {
                r.addProperty(nameProperty, this.creators[i]);
            }
        }
        if (this.comment != null) {
            Property commentProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            r.addProperty(commentProperty, this.comment);
        }
        if (this.createdDate != null) {
            createdDateProperty = model.createProperty("http://spdx.org/rdf/terms#", "created");
            r.addProperty(createdDateProperty, this.createdDate);
        }
        if (this.licenseListVersion != null) {
            createdDateProperty = model.createProperty("http://spdx.org/rdf/terms#", "licenseListVersion");
            r.addProperty(createdDateProperty, this.licenseListVersion);
        }
        this.creatorNode = r.asNode();
        this.creatorResource = r;
        return r;
    }

    public String getCreated() {
        return this.createdDate;
    }

    public void setCreated(String createdDate) {
        this.createdDate = createdDate;
        if (this.creatorNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "created");
            this.model.removeAll(this.creatorResource, p, null);
            if (createdDate != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "created");
                this.creatorResource.addProperty(p, createdDate);
            }
        }
    }

    public int hashCode() {
        int retval = 41;
        if (this.getCreated() != null) {
            retval ^= this.getCreated().hashCode();
        }
        if (this.getComment() != null) {
            retval ^= this.getComment().hashCode();
        }
        if (this.getCreators() != null) {
            String[] creators = this.getCreators();
            for (int i = 0; i < creators.length; ++i) {
                retval ^= creators[i].hashCode();
            }
        }
        return retval;
    }

    public boolean equals(Object o) {
        String[] compNames;
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPDXCreatorInformation)) {
            return false;
        }
        SPDXCreatorInformation compCreator = (SPDXCreatorInformation)o;
        if (compCreator.getCreated() == null) {
            if (this.getCreated() != null) {
                return false;
            }
        } else {
            if (this.createdDate == null) {
                return false;
            }
            if (!compCreator.getCreated().equals(this.createdDate)) {
                return false;
            }
        }
        if (compCreator.getComment() == null) {
            if (this.getComment() != null) {
                return false;
            }
        } else {
            if (this.getComment() == null) {
                return false;
            }
            if (!compCreator.getComment().equals(this.comment)) {
                return false;
            }
        }
        if ((compNames = compCreator.getCreators()) == null) {
            if (this.creators != null) {
                return false;
            }
        } else {
            if (this.creators == null) {
                return false;
            }
            if (compNames.length != this.creators.length) {
                return false;
            }
            for (int i = 0; i < compNames.length; ++i) {
                boolean found = false;
                for (int j = 0; j < this.creators.length; ++j) {
                    if (!compNames[i].equals(this.creators[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        if (compCreator.licenseListVersion == null) {
            if (this.licenseListVersion != null) {
                return false;
            }
        } else {
            if (this.licenseListVersion == null) {
                return false;
            }
            if (!this.licenseListVersion.equals(compCreator.licenseListVersion)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.creators != null && this.creators.length > 0) {
            sb.append(this.creators[0]);
            for (int i = 0; i < this.creators.length; ++i) {
                sb.append(", ");
                sb.append(this.creators[i]);
            }
        }
        if (this.createdDate != null && !this.createdDate.isEmpty()) {
            sb.append("; Created on ");
            sb.append(this.createdDate);
        }
        if (this.licenseListVersion != null && !this.licenseListVersion.isEmpty()) {
            sb.append("; License List Version=");
            sb.append(this.licenseListVersion);
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            sb.append("; Comment: ");
            sb.append(this.comment);
        }
        return sb.toString();
    }

    public List<String> verify() {
        String verify;
        String verify2;
        ArrayList retval = Lists.newArrayList();
        String[] creators = this.getCreators();
        if (creators == null || creators.length == 0) {
            retval.add("Missing required creators");
        } else {
            for (int i = 0; i < creators.length; ++i) {
                verify2 = SpdxVerificationHelper.verifyCreator(creators[i]);
                if (verify2 == null) continue;
                retval.add(verify2);
            }
        }
        String creationDate = this.getCreated();
        if (creationDate == null || creationDate.isEmpty()) {
            retval.add("Missing required created date");
        } else {
            verify2 = SpdxVerificationHelper.verifyDate(creationDate);
            if (verify2 != null) {
                retval.add(verify2);
            }
        }
        String licenseListVersion = this.getLicenseListVersion();
        if (licenseListVersion != null && (verify = this.verifyLicenseListVersion(licenseListVersion)) != null) {
            retval.add(verify);
        }
        return retval;
    }

    private String verifyLicenseListVersion(String version) {
        return null;
    }
}

