/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
        super(baseType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> type, String name) {
    }

    @Override
    public String idFromValue(Object value) {
        return this._idFrom(value, value.getClass());
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> type) {
        return this._idFrom(value, type);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String id) {
        return this._typeFromId(id, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        return this._typeFromId(id, context.getTypeFactory());
    }

    protected JavaType _typeFromId(String id, TypeFactory typeFactory) {
        if (id.indexOf(60) > 0) {
            JavaType t = typeFactory.constructFromCanonical(id);
            return t;
        }
        try {
            Class<?> cls = typeFactory.findClass(id);
            return typeFactory.constructSpecializedType(this._baseType, cls);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Invalid type id '" + id + "' (for id type 'Id.class'): no such class found");
        }
        catch (Exception e3) {
            throw new IllegalArgumentException("Invalid type id '" + id + "' (for id type 'Id.class'): " + e3.getMessage(), e3);
        }
    }

    protected final String _idFrom(Object value, Class<?> cls) {
        Class<?> staticType;
        Class<?> outer;
        String str2;
        if (Enum.class.isAssignableFrom(cls) && !cls.isEnum()) {
            cls = cls.getSuperclass();
        }
        if ((str2 = cls.getName()).startsWith("java.util")) {
            if (value instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value);
                str2 = this._typeFactory.constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value);
                Class<Object> valueClass = Object.class;
                str2 = this._typeFactory.constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            } else {
                String end = str2.substring(9);
                if ((end.startsWith(".Arrays$") || end.startsWith(".Collections$")) && str2.indexOf("List") >= 0) {
                    str2 = "java.util.ArrayList";
                }
            }
        } else if (str2.indexOf(36) >= 0 && (outer = ClassUtil.getOuterClass(cls)) != null && ClassUtil.getOuterClass(staticType = this._baseType.getRawClass()) == null) {
            cls = this._baseType.getRawClass();
            str2 = cls.getName();
        }
        return str2;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

