/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.util.Map;

public class MapGuard
implements Predicate<Object[]> {
    private final int scopeIndex;
    private final String name;
    private final boolean contains;
    private final Wrapper[] wrappers;

    public MapGuard(int scopeIndex, String name, boolean contains, Wrapper[] wrappers) {
        this.scopeIndex = scopeIndex;
        this.name = name;
        this.contains = contains;
        this.wrappers = wrappers;
    }

    @Override
    public boolean apply(Object[] objects) {
        Object scope = objects[this.scopeIndex];
        if (this.wrappers != null) {
            for (Wrapper wrapper : this.wrappers) {
                scope = wrapper.call(new Object[]{scope});
            }
        }
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (this.contains) {
                return map.containsKey(this.name);
            }
            return !map.containsKey(this.name);
        }
        return true;
    }
}

