/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.uri;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.EvalContext;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.uri.URIExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIExtractor11
implements URIExtractor {
    private Set<Setting> settings;
    private final Resolver resolver;

    public URIExtractor11(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void setSettings(Set<Setting> settings) {
        this.settings = settings;
    }

    @Override
    public String getURI(StartElement element, QName attrName, EvalContext context) {
        Attribute attr = element.getAttributeByName(attrName);
        if (attr == null) {
            return null;
        }
        if (attrName.equals(Constants.href) || attrName.equals(Constants.src)) {
            if (attr.getValue().length() == 0) {
                return context.getBase();
            }
            return this.resolver.resolve(context.getBase(), attr.getValue());
        }
        if (attrName.equals(Constants.about) || attrName.equals(Constants.resource)) {
            return this.expandSafeCURIE(element, attr.getValue(), context);
        }
        if (attrName.equals(Constants.datatype)) {
            String val = attr.getValue();
            if (val.length() == 0) {
                return "";
            }
            return this.expandCURIE(element, attr.getValue(), context);
        }
        throw new RuntimeException("Unexpected attribute: " + attr);
    }

    @Override
    public List<String> getURIs(StartElement element, QName attrName, EvalContext context) {
        String[] curies;
        Attribute attr = element.getAttributeByName(attrName);
        if (attr == null) {
            return null;
        }
        LinkedList<String> uris = new LinkedList<String>();
        for (String curie : curies = attr.getValue().split("\\s+")) {
            String uri = this.expandCURIE(element, curie, context);
            if (uri == null || uri == "__NONE__") continue;
            uris.add(uri);
        }
        return uris;
    }

    public String expandCURIE(StartElement element, String value, EvalContext context) {
        String namespaceURI;
        if (value.startsWith("_:")) {
            if (!this.settings.contains((Object)Setting.ManualNamespaces)) {
                return value;
            }
            if (context.getPrefix("_") == null) {
                return value;
            }
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        int offset = value.indexOf(":") + 1;
        if (offset == 0) {
            if (context.getURIForTerm(value) != null) {
                return context.getURIForTerm(value);
            }
            String vocab = context.getVocab();
            if (vocab != null) {
                return vocab + value;
            }
            return "__NONE__";
        }
        String prefix = value.substring(0, offset - 1);
        String string = namespaceURI = prefix.length() == 0 ? "http://www.w3.org/1999/xhtml/vocab#" : context.getURIForPrefix(prefix);
        if (namespaceURI == null) {
            return value;
        }
        return namespaceURI + value.substring(offset);
    }

    public String expandSafeCURIE(StartElement element, String value, EvalContext context) {
        if (value.startsWith("[") && value.endsWith("]")) {
            return this.expandCURIE(element, value.substring(1, value.length() - 1), context);
        }
        String epd = this.expandCURIE(element, value, context);
        if (epd != null && epd != "__NONE__" && !value.equals(epd)) {
            return epd;
        }
        if (value.length() == 0) {
            return context.getBase();
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        return this.resolver.resolve(context.getBase(), value);
    }

    @Override
    public String resolveURI(String uri, EvalContext context) {
        return this.resolver.resolve(context.getBase(), uri);
    }
}

