/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.impl.CoalescingTreeBuilder;
import nu.validator.htmlparser.impl.HtmlAttributes;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DOMTreeBuilder
extends CoalescingTreeBuilder<Element> {
    private DOMImplementation implementation;
    private Document document;

    protected DOMTreeBuilder(DOMImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    protected void addAttributesToElement(Element element, HtmlAttributes attributes) throws SAXException {
        try {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String localName = attributes.getLocalName(i);
                String uri = attributes.getURI(i);
                if (element.hasAttributeNS(uri, localName)) continue;
                element.setAttributeNS(uri, localName, attributes.getValue(i));
            }
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected void appendCharacters(Element parent, String text) throws SAXException {
        try {
            parent.appendChild(this.document.createTextNode(text));
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        try {
            while (oldParent.hasChildNodes()) {
                newParent.appendChild(oldParent.getFirstChild());
            }
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected void appendComment(Element parent, String comment) throws SAXException {
        try {
            parent.appendChild(this.document.createComment(comment));
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected void appendCommentToDocument(String comment) throws SAXException {
        try {
            this.document.appendChild(this.document.createComment(comment));
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS(ns, name);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                if (attributes.getType(i) != "ID") continue;
                rv.setIdAttributeNS(null, attributes.getLocalName(i), true);
            }
            return rv;
        }
        catch (DOMException e2) {
            this.fatal(e2);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS("http://www.w3.org/1999/xhtml", "html");
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            }
            this.document.appendChild(rv);
            return rv;
        }
        catch (DOMException e2) {
            this.fatal(e2);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void appendElement(Element child, Element newParent) throws SAXException {
        try {
            newParent.appendChild(child);
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected boolean hasChildren(Element element) throws SAXException {
        try {
            return element.hasChildNodes();
        }
        catch (DOMException e2) {
            this.fatal(e2);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element shallowClone(Element element) throws SAXException {
        try {
            return (Element)element.cloneNode(false);
        }
        catch (DOMException e2) {
            this.fatal(e2);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element form) throws SAXException {
        try {
            Element rv = this.createElement(ns, name, attributes);
            rv.setUserData("nu.validator.form-pointer", form, null);
            return rv;
        }
        catch (DOMException e2) {
            this.fatal(e2);
            return null;
        }
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.document = this.implementation.createDocument(null, null, null);
    }

    @Override
    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        this.document.setUserData("nu.validator.document-mode", (Object)mode, null);
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = this.document.createDocumentFragment();
        Node rootElt = this.document.getFirstChild();
        while (rootElt.hasChildNodes()) {
            rv.appendChild(rootElt.getFirstChild());
        }
        this.document = null;
        return rv;
    }

    @Override
    protected void insertFosterParentedCharacters(String text, Element table, Element stackParent) throws SAXException {
        try {
            Text child = this.document.createTextNode(text);
            Node parent = table.getParentNode();
            if (parent != null) {
                parent.insertBefore(child, table);
            } else {
                stackParent.appendChild(child);
            }
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected void insertFosterParentedChild(Element child, Element table, Element stackParent) throws SAXException {
        try {
            Node parent = table.getParentNode();
            if (parent != null) {
                parent.insertBefore(child, table);
            } else {
                stackParent.appendChild(child);
            }
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        try {
            Node parent = element.getParentNode();
            if (parent != null) {
                parent.removeChild(element);
            }
        }
        catch (DOMException e2) {
            this.fatal(e2);
        }
    }
}

