/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.common.EncodingDeclarationHandler;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeName;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.LocatorImpl;
import nu.validator.htmlparser.impl.NamedCharacters;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.PushedLocation;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.htmlparser.impl.UTF16Buffer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Tokenizer
implements Locator {
    public static final int DATA = 0;
    public static final int RCDATA = 1;
    public static final int CDATA = 2;
    public static final int PLAINTEXT = 3;
    private static final int TAG_OPEN = 49;
    private static final int CLOSE_TAG_OPEN_PCDATA = 50;
    private static final int TAG_NAME = 58;
    private static final int BEFORE_ATTRIBUTE_NAME = 4;
    private static final int ATTRIBUTE_NAME = 5;
    private static final int AFTER_ATTRIBUTE_NAME = 6;
    private static final int BEFORE_ATTRIBUTE_VALUE = 7;
    private static final int ATTRIBUTE_VALUE_DOUBLE_QUOTED = 8;
    private static final int ATTRIBUTE_VALUE_SINGLE_QUOTED = 9;
    private static final int ATTRIBUTE_VALUE_UNQUOTED = 10;
    private static final int AFTER_ATTRIBUTE_VALUE_QUOTED = 11;
    private static final int BOGUS_COMMENT = 12;
    private static final int MARKUP_DECLARATION_OPEN = 13;
    private static final int DOCTYPE = 14;
    private static final int BEFORE_DOCTYPE_NAME = 15;
    private static final int DOCTYPE_NAME = 16;
    private static final int AFTER_DOCTYPE_NAME = 17;
    private static final int BEFORE_DOCTYPE_PUBLIC_IDENTIFIER = 18;
    private static final int DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED = 19;
    private static final int DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED = 20;
    private static final int AFTER_DOCTYPE_PUBLIC_IDENTIFIER = 21;
    private static final int BEFORE_DOCTYPE_SYSTEM_IDENTIFIER = 22;
    private static final int DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED = 23;
    private static final int DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED = 24;
    private static final int AFTER_DOCTYPE_SYSTEM_IDENTIFIER = 25;
    private static final int BOGUS_DOCTYPE = 26;
    private static final int COMMENT_START = 27;
    private static final int COMMENT_START_DASH = 28;
    private static final int COMMENT = 29;
    private static final int COMMENT_END_DASH = 30;
    private static final int COMMENT_END = 31;
    private static final int CLOSE_TAG_OPEN_NOT_PCDATA = 32;
    private static final int MARKUP_DECLARATION_HYPHEN = 33;
    private static final int MARKUP_DECLARATION_OCTYPE = 34;
    private static final int DOCTYPE_UBLIC = 35;
    private static final int DOCTYPE_YSTEM = 36;
    private static final int CONSUME_CHARACTER_REFERENCE = 37;
    private static final int CONSUME_NCR = 38;
    private static final int CHARACTER_REFERENCE_LOOP = 39;
    private static final int HEX_NCR_LOOP = 41;
    private static final int DECIMAL_NRC_LOOP = 42;
    private static final int HANDLE_NCR_VALUE = 43;
    private static final int SELF_CLOSING_START_TAG = 44;
    private static final int CDATA_START = 45;
    private static final int CDATA_SECTION = 46;
    private static final int CDATA_RSQB = 47;
    private static final int CDATA_RSQB_RSQB = 48;
    private static final int TAG_OPEN_NON_PCDATA = 51;
    private static final int ESCAPE_EXCLAMATION = 52;
    private static final int ESCAPE_EXCLAMATION_HYPHEN = 53;
    private static final int ESCAPE = 54;
    private static final int ESCAPE_HYPHEN = 55;
    private static final int ESCAPE_HYPHEN_HYPHEN = 56;
    private static final int BOGUS_COMMENT_HYPHEN = 57;
    private static final int LEAD_OFFSET = 55232;
    private static final int SURROGATE_OFFSET = -56613888;
    @NoLength
    private static final char[] LT_GT = new char[]{'<', '>'};
    @NoLength
    private static final char[] LT_SOLIDUS = new char[]{'<', '/'};
    @NoLength
    private static final char[] RSQB_RSQB = new char[]{']', ']'};
    @NoLength
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};
    @NoLength
    private static final char[] SPACE = new char[]{' '};
    @NoLength
    private static final char[] LF = new char[]{'\n'};
    private static final int BUFFER_GROW_BY = 1024;
    @NoLength
    private static final char[] CDATA_LSQB = "CDATA[".toCharArray();
    @NoLength
    private static final char[] OCTYPE = "octype".toCharArray();
    @NoLength
    private static final char[] UBLIC = "ublic".toCharArray();
    @NoLength
    private static final char[] YSTEM = "ystem".toCharArray();
    private static final char[] TITLE_ARR = new char[]{'t', 'i', 't', 'l', 'e'};
    private static final char[] SCRIPT_ARR = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private static final char[] STYLE_ARR = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final char[] PLAINTEXT_ARR = new char[]{'p', 'l', 'a', 'i', 'n', 't', 'e', 'x', 't'};
    private static final char[] XMP_ARR = new char[]{'x', 'm', 'p'};
    private static final char[] TEXTAREA_ARR = new char[]{'t', 'e', 'x', 't', 'a', 'r', 'e', 'a'};
    private static final char[] IFRAME_ARR = new char[]{'i', 'f', 'r', 'a', 'm', 'e'};
    private static final char[] NOEMBED_ARR = new char[]{'n', 'o', 'e', 'm', 'b', 'e', 'd'};
    private static final char[] NOSCRIPT_ARR = new char[]{'n', 'o', 's', 'c', 'r', 'i', 'p', 't'};
    private static final char[] NOFRAMES_ARR = new char[]{'n', 'o', 'f', 'r', 'a', 'm', 'e', 's'};
    private final TokenHandler tokenHandler;
    private final EncodingDeclarationHandler encodingDeclarationHandler;
    private ErrorHandler errorHandler;
    private char prev;
    private int line;
    private int linePrev;
    private int col;
    private int colPrev;
    private boolean nextCharOnNewLine;
    private int stateSave;
    private int returnStateSave;
    private int index;
    private boolean forceQuirks;
    private char additional;
    private int entCol;
    private int lo;
    private int hi;
    private int candidate;
    private int strBufMark;
    private int prevValue;
    private int value;
    private boolean seenDigits;
    private int pos;
    private int endPos;
    @NoLength
    private char[] buf;
    private int cstart;
    private String publicId;
    private String systemId;
    private char[] strBuf;
    private int strBufLen;
    private char[] longStrBuf;
    private int longStrBufLen;
    private HtmlAttributes attributes;
    private final char[] bmpChar;
    private final char[] astralChar;
    private boolean alreadyWarnedAboutPrivateUseCharacters;
    private ElementName contentModelElement = null;
    private char[] contentModelElementNameAsArray;
    private boolean endTag;
    private ElementName tagName = null;
    private AttributeName attributeName = null;
    private boolean wantsComments = false;
    private boolean html4;
    private boolean alreadyComplainedAboutNonAscii;
    private boolean metaBoundaryPassed;
    @Local
    private String doctypeName;
    private String publicIdentifier;
    private String systemIdentifier;
    private XmlViolationPolicy contentSpacePolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy contentNonXmlCharPolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy commentPolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy xmlnsPolicy = XmlViolationPolicy.ALTER_INFOSET;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.ALTER_INFOSET;
    private boolean html4ModeCompatibleWithXhtml1Schemata;
    private final boolean newAttributesEachTime;
    private int mappingLangToXmlLang;
    private boolean shouldSuspend;
    private boolean confident;
    private PushedLocation pushedLocation;
    private LocatorImpl ampersandLocation;

    public Tokenizer(TokenHandler tokenHandler, EncodingDeclarationHandler encodingDeclarationHandler, boolean newAttributesEachTime) {
        this.tokenHandler = tokenHandler;
        this.encodingDeclarationHandler = encodingDeclarationHandler;
        this.newAttributesEachTime = newAttributesEachTime;
        this.bmpChar = new char[1];
        this.astralChar = new char[2];
    }

    public Tokenizer(TokenHandler tokenHandler) {
        this.tokenHandler = tokenHandler;
        this.encodingDeclarationHandler = null;
        this.newAttributesEachTime = false;
        this.bmpChar = new char[1];
        this.astralChar = new char[2];
    }

    public Tokenizer(TokenHandler tokenHandler, EncodingDeclarationHandler encodingDeclarationHandler) {
        this.tokenHandler = tokenHandler;
        this.encodingDeclarationHandler = encodingDeclarationHandler;
        this.newAttributesEachTime = false;
        this.bmpChar = new char[1];
        this.astralChar = new char[2];
    }

    public void initLocation(String newPublicId, String newSystemId) {
        this.systemId = newSystemId;
        this.publicId = newPublicId;
    }

    void destructor() {
        Portability.releaseArray(this.bmpChar);
        Portability.releaseArray(this.astralChar);
    }

    public boolean isMappingLangToXmlLang() {
        return this.mappingLangToXmlLang == 3;
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.mappingLangToXmlLang = mappingLangToXmlLang ? 3 : 0;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.commentPolicy = commentPolicy;
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.contentNonXmlCharPolicy = contentNonXmlCharPolicy;
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.contentSpacePolicy = contentSpacePolicy;
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        if (xmlnsPolicy == XmlViolationPolicy.FATAL) {
            throw new IllegalArgumentException("Can't use FATAL here.");
        }
        this.xmlnsPolicy = xmlnsPolicy;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.html4ModeCompatibleWithXhtml1Schemata = html4ModeCompatibleWithXhtml1Schemata;
    }

    public void setContentModelFlag(int contentModelFlag, @Local String contentModelElement) {
        this.stateSave = contentModelFlag;
        if (contentModelFlag == 0) {
            return;
        }
        char[] asArray = Portability.newCharArrayFromLocal(contentModelElement);
        this.contentModelElement = ElementName.elementNameByBuffer(asArray, 0, asArray.length);
        Portability.releaseArray(asArray);
        this.contentModelElementToArray();
    }

    public void setContentModelFlag(int contentModelFlag, ElementName contentModelElement) {
        this.stateSave = contentModelFlag;
        this.contentModelElement = contentModelElement;
        this.contentModelElementToArray();
    }

    private void contentModelElementToArray() {
        switch (this.contentModelElement.group) {
            case 36: {
                this.contentModelElementNameAsArray = TITLE_ARR;
                return;
            }
            case 31: {
                this.contentModelElementNameAsArray = SCRIPT_ARR;
                return;
            }
            case 33: {
                this.contentModelElementNameAsArray = STYLE_ARR;
                return;
            }
            case 30: {
                this.contentModelElementNameAsArray = PLAINTEXT_ARR;
                return;
            }
            case 38: {
                this.contentModelElementNameAsArray = XMP_ARR;
                return;
            }
            case 35: {
                this.contentModelElementNameAsArray = TEXTAREA_ARR;
                return;
            }
            case 47: {
                this.contentModelElementNameAsArray = IFRAME_ARR;
                return;
            }
            case 60: {
                this.contentModelElementNameAsArray = NOEMBED_ARR;
                return;
            }
            case 26: {
                this.contentModelElementNameAsArray = NOSCRIPT_ARR;
                return;
            }
            case 25: {
                this.contentModelElementNameAsArray = NOFRAMES_ARR;
                return;
            }
        }
        assert (false);
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        if (this.line > 0) {
            return this.line;
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.col > 0) {
            return this.col;
        }
        return -1;
    }

    public void notifyAboutMetaBoundary() {
        this.metaBoundaryPassed = true;
    }

    void turnOnAdditionalHtml4Errors() {
        this.html4 = true;
    }

    HtmlAttributes emptyAttributes() {
        if (this.newAttributesEachTime) {
            return new HtmlAttributes(this.mappingLangToXmlLang);
        }
        return HtmlAttributes.EMPTY_ATTRIBUTES;
    }

    private void detachStrBuf() {
    }

    private void detachLongStrBuf() {
    }

    private void clearStrBufAndAppendCurrentC(char c) {
        this.strBuf[0] = c;
        this.strBufLen = 1;
    }

    private void clearStrBufAndAppendForceWrite(char c) {
        this.strBuf[0] = c;
        this.strBufLen = 1;
    }

    private void clearStrBufForNextState() {
        this.strBufLen = 0;
    }

    private void appendStrBuf(char c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + 1024];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            Portability.releaseArray(this.strBuf);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = c;
    }

    private void appendStrBufForceWrite(char c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + 1024];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            Portability.releaseArray(this.strBuf);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = c;
    }

    private String strBufToString() {
        return Portability.newStringFromBuffer(this.strBuf, 0, this.strBufLen);
    }

    @Local
    private String strBufToDoctypeName() {
        return Portability.newLocalNameFromBuffer(this.strBuf, 0, this.strBufLen);
    }

    private void emitStrBuf() throws SAXException {
        if (this.strBufLen > 0) {
            this.tokenHandler.characters(this.strBuf, 0, this.strBufLen);
        }
    }

    private void clearLongStrBufForNextState() {
        this.longStrBufLen = 0;
    }

    private void clearLongStrBuf() {
        this.longStrBufLen = 0;
    }

    private void clearLongStrBufAndAppendCurrentC() {
        this.longStrBuf[0] = this.buf[this.pos];
        this.longStrBufLen = 1;
    }

    private void clearLongStrBufAndAppendToComment(char c) {
        this.longStrBuf[0] = c;
        this.longStrBufLen = 1;
    }

    private void appendLongStrBuf(char c) {
        if (this.longStrBufLen == this.longStrBuf.length) {
            char[] newBuf = new char[this.longStrBufLen + (this.longStrBufLen >> 1)];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            Portability.releaseArray(this.longStrBuf);
            this.longStrBuf = newBuf;
        }
        this.longStrBuf[this.longStrBufLen++] = c;
    }

    private void appendSecondHyphenToBogusComment() throws SAXException {
        switch (this.commentPolicy) {
            case ALTER_INFOSET: {
                this.appendLongStrBuf(' ');
            }
            case ALLOW: {
                this.warn("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
                this.appendLongStrBuf('-');
                break;
            }
            case FATAL: {
                this.fatal("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
            }
        }
    }

    private void maybeAppendSpaceToBogusComment() throws SAXException {
        switch (this.commentPolicy) {
            case ALTER_INFOSET: {
                this.appendLongStrBuf(' ');
            }
            case ALLOW: {
                this.warn("The document is not mappable to XML 1.0 due to a trailing hyphen in a comment.");
                break;
            }
            case FATAL: {
                this.fatal("The document is not mappable to XML 1.0 due to a trailing hyphen in a comment.");
            }
        }
    }

    private void adjustDoubleHyphenAndAppendToLongStrBuf(char c) throws SAXException {
        switch (this.commentPolicy) {
            case ALTER_INFOSET: {
                --this.longStrBufLen;
                this.appendLongStrBuf(' ');
                this.appendLongStrBuf('-');
            }
            case ALLOW: {
                this.warn("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
                this.appendLongStrBuf(c);
                break;
            }
            case FATAL: {
                this.fatal("The document is not mappable to XML 1.0 due to two consecutive hyphens in a comment.");
            }
        }
    }

    private void appendLongStrBuf(char[] buffer, int offset, int length) {
        int reqLen = this.longStrBufLen + length;
        if (this.longStrBuf.length < reqLen) {
            char[] newBuf = new char[reqLen + (reqLen >> 1)];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            Portability.releaseArray(this.longStrBuf);
            this.longStrBuf = newBuf;
        }
        System.arraycopy(buffer, offset, this.longStrBuf, this.longStrBufLen, length);
        this.longStrBufLen = reqLen;
    }

    private void appendLongStrBuf(char[] arr) {
        this.appendLongStrBuf(arr, 0, arr.length);
    }

    private void appendStrBufToLongStrBuf() {
        this.appendLongStrBuf(this.strBuf, 0, this.strBufLen);
    }

    private String longStrBufToString() {
        return Portability.newStringFromBuffer(this.longStrBuf, 0, this.longStrBufLen);
    }

    private void emitComment(int provisionalHyphens) throws SAXException {
        if (this.wantsComments) {
            this.tokenHandler.comment(this.longStrBuf, 0, this.longStrBufLen - provisionalHyphens);
        }
        this.cstart = this.pos + 1;
    }

    private String toUPlusString(char c) {
        String hexString = Integer.toHexString(c);
        switch (hexString.length()) {
            case 1: {
                return "U+000" + hexString;
            }
            case 2: {
                return "U+00" + hexString;
            }
            case 3: {
                return "U+0" + hexString;
            }
            case 4: {
                return "U+" + hexString;
            }
        }
        throw new RuntimeException("Unreachable.");
    }

    private void warnAboutPrivateUseChar() throws SAXException {
        if (!this.alreadyWarnedAboutPrivateUseCharacters) {
            this.warn("Document uses the Unicode Private Use Area(s), which should not be used in publicly exchanged documents. (Charmod C073)");
            this.alreadyWarnedAboutPrivateUseCharacters = true;
        }
    }

    private boolean isPrivateUse(char c) {
        return c >= '\ue000' && c <= '\uf8ff';
    }

    private boolean isAstralPrivateUse(int c) {
        return c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    private boolean isNonCharacter(int c) {
        return (c & 0xFFFE) == 65534;
    }

    private void flushChars() throws SAXException {
        if (this.pos > this.cstart) {
            int currLine = this.line;
            int currCol = this.col;
            this.line = this.linePrev;
            this.col = this.colPrev;
            this.tokenHandler.characters(this.buf, this.cstart, this.pos - this.cstart);
            this.line = currLine;
            this.col = currCol;
        }
        this.cstart = Integer.MAX_VALUE;
    }

    public void fatal(String message) throws SAXException {
        SAXParseException spe = new SAXParseException(message, this);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    public void err(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        this.errorHandler.error(spe);
    }

    public void errTreeBuilder(String message) throws SAXException {
        ErrorHandler eh = null;
        if (this.tokenHandler instanceof TreeBuilder) {
            TreeBuilder treeBuilder = (TreeBuilder)this.tokenHandler;
            eh = treeBuilder.getErrorHandler();
        }
        if (eh == null) {
            eh = this.errorHandler;
        }
        if (eh == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        eh.error(spe);
    }

    public void warn(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        this.errorHandler.warning(spe);
    }

    private void resetAttributes() {
        if (this.newAttributesEachTime) {
            this.attributes = null;
        } else {
            this.attributes.clear(this.mappingLangToXmlLang);
        }
    }

    private ElementName strBufToElementNameString() {
        return ElementName.elementNameByBuffer(this.strBuf, 0, this.strBufLen);
    }

    private int emitCurrentTagToken(boolean selfClosing) throws SAXException {
        HtmlAttributes attrs;
        this.cstart = this.pos + 1;
        if (selfClosing && this.endTag) {
            this.err("Stray \u201c/\u201d at the end of an end tag.");
        }
        this.stateSave = 0;
        HtmlAttributes htmlAttributes = attrs = this.attributes == null ? HtmlAttributes.EMPTY_ATTRIBUTES : this.attributes;
        if (this.endTag) {
            if (attrs.getLength() != 0) {
                this.err("End tag had attributes.");
            }
            this.tokenHandler.endTag(this.tagName);
        } else {
            this.tokenHandler.startTag(this.tagName, attrs, selfClosing);
        }
        this.resetAttributes();
        return this.stateSave;
    }

    private void attributeNameComplete() throws SAXException {
        this.attributeName = AttributeName.nameByBuffer(this.strBuf, 0, this.strBufLen, this.namePolicy != XmlViolationPolicy.ALLOW);
        if (this.attributes == null) {
            this.attributes = new HtmlAttributes(this.mappingLangToXmlLang);
        }
        if (this.attributes.contains(this.attributeName)) {
            this.err("Duplicate attribute \u201c" + this.attributeName.getLocal(0) + "\u201d.");
            this.attributeName.release();
            this.attributeName = null;
        }
    }

    private void addAttributeWithoutValue() throws SAXException {
        if (this.metaBoundaryPassed && AttributeName.CHARSET == this.attributeName && ElementName.META == this.tagName) {
            this.err("A \u201ccharset\u201d attribute on a \u201cmeta\u201d element found after the first 512 bytes.");
        }
        if (this.attributeName != null) {
            if (this.html4) {
                if (this.attributeName.isBoolean()) {
                    if (this.html4ModeCompatibleWithXhtml1Schemata) {
                        this.attributes.addAttribute(this.attributeName, this.attributeName.getLocal(0), this.xmlnsPolicy);
                    } else {
                        this.attributes.addAttribute(this.attributeName, "", this.xmlnsPolicy);
                    }
                } else {
                    this.err("Attribute value omitted for a non-boolean attribute. (HTML4-only error.)");
                    this.attributes.addAttribute(this.attributeName, "", this.xmlnsPolicy);
                }
            } else {
                if (AttributeName.SRC == this.attributeName || AttributeName.HREF == this.attributeName) {
                    this.warn("Attribute \u201c" + this.attributeName.getLocal(0) + "\u201d without an explicit value seen. The attribute may be dropped by IE7.");
                }
                this.attributes.addAttribute(this.attributeName, Portability.newEmptyString(), this.xmlnsPolicy);
            }
        }
    }

    private void addAttributeWithValue() throws SAXException {
        if (this.metaBoundaryPassed && ElementName.META == this.tagName && AttributeName.CHARSET == this.attributeName) {
            this.err("A \u201ccharset\u201d attribute on a \u201cmeta\u201d element found after the first 512 bytes.");
        }
        if (this.attributeName != null) {
            String value = this.longStrBufToString();
            if (!this.endTag && this.html4 && this.html4ModeCompatibleWithXhtml1Schemata && this.attributeName.isCaseFolded()) {
                value = Tokenizer.newAsciiLowerCaseStringFromString(value);
            }
            this.attributes.addAttribute(this.attributeName, value, this.xmlnsPolicy);
        }
    }

    private static String newAsciiLowerCaseStringFromString(String str2) {
        if (str2 == null) {
            return null;
        }
        char[] buf = new char[str2.length()];
        for (int i = 0; i < str2.length(); ++i) {
            char c = str2.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    public void start() throws SAXException {
        this.confident = false;
        this.strBuf = new char[64];
        this.strBufLen = 0;
        this.longStrBuf = new char[1024];
        this.longStrBufLen = 0;
        this.stateSave = 0;
        this.linePrev = 0;
        this.line = 0;
        this.colPrev = 1;
        this.col = 1;
        this.nextCharOnNewLine = true;
        this.prev = '\u0000';
        this.html4 = false;
        this.alreadyWarnedAboutPrivateUseCharacters = false;
        this.alreadyComplainedAboutNonAscii = false;
        this.metaBoundaryPassed = false;
        this.tokenHandler.startTokenization(this);
        this.wantsComments = this.tokenHandler.wantsComments();
        this.index = 0;
        this.forceQuirks = false;
        this.additional = '\u0000';
        this.entCol = -1;
        this.lo = 0;
        this.hi = NamedCharacters.NAMES.length - 1;
        this.candidate = -1;
        this.strBufMark = 0;
        this.prevValue = -1;
        this.value = 0;
        this.seenDigits = false;
        this.shouldSuspend = false;
        if (!this.newAttributesEachTime) {
            this.attributes = new HtmlAttributes(this.mappingLangToXmlLang);
        }
    }

    public boolean tokenizeBuffer(UTF16Buffer buffer) throws SAXException {
        this.buf = buffer.getBuffer();
        int state = this.stateSave;
        int returnState = this.returnStateSave;
        char c = '\u0000';
        this.shouldSuspend = false;
        int start = buffer.getStart();
        this.pos = start - 1;
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                this.cstart = start;
                break;
            }
            default: {
                this.cstart = Integer.MAX_VALUE;
            }
        }
        this.endPos = buffer.getEnd();
        boolean reconsume = false;
        this.stateLoop(state, c, reconsume, returnState);
        this.detachStrBuf();
        this.detachLongStrBuf();
        if (this.pos == this.endPos) {
            buffer.setStart(this.pos);
        } else {
            buffer.setStart(this.pos + 1);
        }
        if (this.prev == '\r') {
            this.prev = (char)32;
            return true;
        }
        return false;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void stateLoop(int state, char c, boolean reconsume, int returnState) throws SAXException {
        block314: while (true) {
            block465: {
                block464: {
                    cfr_temp_0 = -2147483648;
                    block315: do {
                        switch (cfr_temp_0 == -2147483648 ? state : cfr_temp_0) {
                            case 0: {
                                ** break;
                            }
                            case 10: {
                                ** GOTO lbl417
                            }
                            case 6: {
                                ** GOTO lbl453
                            }
                            case 12: {
                                ** GOTO lbl483
                            }
                            case 13: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        this.clearLongStrBufAndAppendToComment(c);
                                        state = 33;
                                        break;
                                    }
                                    case 'D': 
                                    case 'd': {
                                        this.clearLongStrBufAndAppendToComment(c);
                                        this.index = 0;
                                        state = 34;
                                        continue block314;
                                    }
                                    case '[': {
                                        if (this.tokenHandler.inForeign()) {
                                            this.clearLongStrBufAndAppendToComment(c);
                                            this.index = 0;
                                            state = 45;
                                            continue block314;
                                        }
                                    }
                                    default: {
                                        this.err("Bogus comment.");
                                        this.clearLongStrBuf();
                                        state = 12;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 33: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        this.clearLongStrBufForNextState();
                                        state = 27;
                                        break;
                                    }
                                    default: {
                                        this.err("Bogus comment.");
                                        state = 12;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 27: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        this.appendLongStrBuf(c);
                                        state = 28;
                                        continue block314;
                                    }
                                    case '>': {
                                        this.err("Premature end of comment. Use \u201c-->\u201d to end a comment properly.");
                                        this.emitComment(0);
                                        state = 0;
                                        continue block314;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        state = 29;
                                    }
                                }
                            }
                            case 29: {
                                ** GOTO lbl522
                            }
                            case 28: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        this.appendLongStrBuf(c);
                                        state = 31;
                                        break;
                                    }
                                    case '>': {
                                        this.err("Premature end of comment. Use \u201c-->\u201d to end a comment properly.");
                                        this.emitComment(1);
                                        state = 0;
                                        break;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        state = 29;
                                        break;
                                    }
                                }
                                continue block314;
                            }
                            case 34: {
                                ** GOTO lbl568
                            }
                            case 25: {
                                ** GOTO lbl790
                            }
                            case 36: {
                                c = this.read();
                                if (c == '\u0000') break block314;
                                if (this.index < 5) {
                                    folded = c;
                                    if (c >= 'A' && c <= 'Z') {
                                        folded = (char)(folded + 32);
                                    }
                                    if (folded != Tokenizer.YSTEM[this.index]) {
                                        this.bogusDoctype();
                                        state = 26;
                                        reconsume = true;
                                        continue block314;
                                    }
                                    ++this.index;
                                    continue block314;
                                }
                                state = 22;
                                reconsume = true;
                            }
                            case 22: {
                                ** GOTO lbl821
                            }
                            case 20: {
                                ** GOTO lbl873
                            }
                            case 45: {
                                ** GOTO lbl894
                            }
                            case 9: {
                                ** GOTO lbl955
                            }
                            case 38: {
                                c = this.read();
                                this.prevValue = -1;
                                this.value = 0;
                                this.seenDigits = false;
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case 'X': 
                                    case 'x': {
                                        this.appendStrBuf(c);
                                        state = 41;
                                        continue block314;
                                    }
                                    default: {
                                        state = 42;
                                        reconsume = true;
                                    }
                                }
                            }
                            case 42: {
                                ** GOTO lbl1066
                            }
                            case 41: {
                                ** GOTO lbl1114
                            }
                            case 3: {
                                ** GOTO lbl1161
                            }
                            case 2: {
                                ** GOTO lbl1170
                            }
                            case 32: {
                                break block464;
                            }
                            case 50: {
                                c = this.read();
                                if (c == '\u0000') break block314;
                                if (c >= 'A' && c <= 'Z') {
                                    this.endTag = true;
                                    this.clearStrBufAndAppendForceWrite((char)(c + 32));
                                    state = 58;
                                    continue block314;
                                }
                                if (c >= 'a' && c <= 'z') {
                                    this.endTag = true;
                                    this.clearStrBufAndAppendCurrentC(c);
                                    state = 58;
                                    continue block314;
                                }
                                if (c == '>') {
                                    this.err("Saw \u201c</>\u201d. Probable causes: Unescaped \u201c<\u201d (escape as \u201c&lt;\u201d) or mistyped end tag.");
                                    this.cstart = this.pos + 1;
                                    state = 0;
                                    continue block314;
                                }
                                this.err("Garbage after \u201c</\u201d.");
                                this.clearLongStrBufAndAppendToComment(c);
                                state = 12;
                                continue block314;
                            }
                            case 1: {
                                break block465;
                            }
                            default: {
                                continue block314;
                            }
lbl170:
                            // 1 sources

                            block316: while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '&': {
                                        this.flushChars();
                                        this.clearStrBufAndAppendCurrentC(c);
                                        this.additional = '\u0000';
                                        this.rememberAmpersandLocation();
                                        returnState = state;
                                        state = 37;
                                        continue block314;
                                    }
                                    case '<': {
                                        this.flushChars();
                                        state = 49;
                                        cfr_temp_0 = 49;
                                        ** break;
                                    }
                                    default: {
                                        continue block316;
                                    }
                                }
                                break;
                            }
                            case 49: {
                                c = this.read();
                                if (c < 'A' || c > 'Z') ** GOTO lbl200
                                this.endTag = false;
                                this.clearStrBufAndAppendForceWrite((char)(c + 32));
                                state = 58;
                                ** GOTO lbl233
lbl200:
                                // 1 sources

                                if (c >= 'a' && c <= 'z') {
                                    this.endTag = false;
                                    this.clearStrBufAndAppendCurrentC(c);
                                    state = 58;
                                } else {
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '!': {
                                            state = 13;
                                            break;
                                        }
                                        case '/': {
                                            state = 50;
                                            break;
                                        }
                                        case '?': {
                                            this.err("Saw \u201c<?\u201d. Probable cause: Attempt to use an XML processing instruction in HTML. (XML processing instructions are not supported in HTML.)");
                                            this.clearLongStrBufAndAppendToComment('?');
                                            state = 12;
                                            break;
                                        }
                                        case '>': {
                                            this.err("Saw \u201c<>\u201d. Probable causes: Unescaped \u201c<\u201d (escape as \u201c&lt;\u201d) or mistyped start tag.");
                                            this.tokenHandler.characters(Tokenizer.LT_GT, 0, 2);
                                            this.cstart = this.pos + 1;
                                            state = 0;
                                            break;
                                        }
                                        default: {
                                            this.err("Bad character \u201c" + c + "\u201d after \u201c<\u201d. Probable cause: Unescaped \u201c<\u201d. Try escaping it as \u201c&lt;\u201d.");
                                            this.tokenHandler.characters(Tokenizer.LT_GT, 0, 1);
                                            this.cstart = this.pos;
                                            state = 0;
                                            reconsume = true;
                                            break;
                                        }
                                    }
                                    continue block314;
                                }
                            }
lbl233:
                            // 3 sources

                            case 58: {
                                block317: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            this.tagName = this.strBufToElementNameString();
                                            state = 4;
                                            break block317;
                                        }
                                        case '/': {
                                            this.tagName = this.strBufToElementNameString();
                                            state = 44;
                                            continue block314;
                                        }
                                        case '>': {
                                            this.tagName = this.strBufToElementNameString();
                                            state = this.emitCurrentTagToken(false);
                                            if (!this.shouldSuspend) continue block314;
                                            break block314;
                                        }
                                        default: {
                                            if (c >= 'A' && c <= 'Z') {
                                                this.appendStrBufForceWrite((char)(c + 32));
                                                continue block317;
                                            }
                                            this.appendStrBuf(c);
                                            continue block317;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 4: {
                                block318: while (true) {
                                    if (reconsume) {
                                        reconsume = false;
                                    } else {
                                        c = this.read();
                                    }
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            continue block318;
                                        }
                                        case '/': {
                                            state = 44;
                                            continue block314;
                                        }
                                        case '>': {
                                            state = this.emitCurrentTagToken(false);
                                            if (!this.shouldSuspend) continue block314;
                                            break block314;
                                        }
                                        case '\"': 
                                        case '\'': 
                                        case '=': {
                                            if (c == '=') {
                                                this.err("Saw \u201c=\u201d when expecting an attribute name. Probable cause: Attribute name missing.");
                                            } else {
                                                this.errQuoteBeforeAttributeName(c);
                                            }
                                        }
                                        default: {
                                            if (c >= 'A' && c <= 'Z') {
                                                this.clearStrBufAndAppendForceWrite((char)(c + 32));
                                            } else {
                                                this.clearStrBufAndAppendCurrentC(c);
                                            }
                                            state = 5;
                                            break block318;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 5: {
                                block319: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            this.attributeNameComplete();
                                            state = 6;
                                            continue block314;
                                        }
                                        case '/': {
                                            this.attributeNameComplete();
                                            this.addAttributeWithoutValue();
                                            state = 44;
                                            continue block314;
                                        }
                                        case '=': {
                                            this.attributeNameComplete();
                                            state = 7;
                                            break block319;
                                        }
                                        case '>': {
                                            this.attributeNameComplete();
                                            this.addAttributeWithoutValue();
                                            state = this.emitCurrentTagToken(false);
                                            if (!this.shouldSuspend) continue block314;
                                            break block314;
                                        }
                                        case '\"': 
                                        case '\'': {
                                            this.errQuoteInAttributeName(c);
                                        }
                                        default: {
                                            if (c >= 'A' && c <= 'Z') {
                                                this.appendStrBufForceWrite((char)(c + 32));
                                                continue block319;
                                            }
                                            this.appendStrBuf(c);
                                            continue block319;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 7: {
                                block320: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            continue block320;
                                        }
                                        case '\"': {
                                            this.clearLongStrBufForNextState();
                                            state = 8;
                                            break block320;
                                        }
                                        case '&': {
                                            this.clearLongStrBuf();
                                            state = 10;
                                            reconsume = true;
                                            continue block314;
                                        }
                                        case '\'': {
                                            this.clearLongStrBufForNextState();
                                            state = 9;
                                            continue block314;
                                        }
                                        case '>': {
                                            this.err("Attribute value missing.");
                                            this.addAttributeWithoutValue();
                                            state = this.emitCurrentTagToken(false);
                                            if (!this.shouldSuspend) continue block314;
                                            break block314;
                                        }
                                        case '=': {
                                            this.err("\u201c=\u201d in an unquoted attribute value. Probable cause: Stray duplicate equals sign.");
                                        }
                                        default: {
                                            if (!(!this.html4 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ':')) {
                                                this.err("Non-name character in an unquoted attribute value. (This is an HTML4-only error.)");
                                            }
                                            this.clearLongStrBufAndAppendCurrentC();
                                            state = 10;
                                            continue block314;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 8: {
                                block321: while (true) {
                                    if (reconsume) {
                                        reconsume = false;
                                    } else {
                                        c = this.read();
                                    }
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\"': {
                                            this.addAttributeWithValue();
                                            state = 11;
                                            break block321;
                                        }
                                        case '&': {
                                            this.detachLongStrBuf();
                                            this.clearStrBufAndAppendCurrentC(c);
                                            this.additional = (char)34;
                                            this.rememberAmpersandLocation();
                                            returnState = state;
                                            state = 37;
                                            continue block314;
                                        }
                                        default: {
                                            this.appendLongStrBuf(c);
                                            continue block321;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 11: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': {
                                        state = 4;
                                        continue block314;
                                    }
                                    case '/': {
                                        state = 44;
                                        break;
                                    }
                                    case '>': {
                                        state = this.emitCurrentTagToken(false);
                                        if (!this.shouldSuspend) continue block314;
                                        break block314;
                                    }
                                    default: {
                                        this.err("No space between attributes.");
                                        state = 4;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 44: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '>': {
                                        if (this.html4) {
                                            this.err("The \u201c/>\u201d syntax on void elements is not allowed.  (This is an HTML4-only error.)");
                                        }
                                        state = this.emitCurrentTagToken(true);
                                        if (!this.shouldSuspend) break;
                                        break block314;
                                    }
                                    default: {
                                        this.err("A slash was not immediate followed by \u201c>\u201d.");
                                        state = 4;
                                        reconsume = true;
                                        break;
                                    }
                                }
                                continue block314;
                            }
lbl417:
                            // 1 sources

                            while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': {
                                        this.addAttributeWithValue();
                                        state = 4;
                                        continue block314;
                                    }
                                    case '&': {
                                        this.detachLongStrBuf();
                                        this.clearStrBufAndAppendCurrentC(c);
                                        this.additional = '\u0000';
                                        this.rememberAmpersandLocation();
                                        returnState = state;
                                        state = 37;
                                        continue block314;
                                    }
                                    case '>': {
                                        this.addAttributeWithValue();
                                        state = this.emitCurrentTagToken(false);
                                        if (!this.shouldSuspend) continue block314;
                                        break block314;
                                    }
                                    case '\"': 
                                    case '\'': 
                                    case '<': 
                                    case '=': {
                                        if (c == '<') {
                                            this.warn("\u201c<\u201d in an unquoted attribute value. This does not end the tag. Probable cause: Missing \u201c>\u201d immediately before.");
                                        } else {
                                            this.err("\u201c" + c + "\u201d in an unquoted attribute value. Probable causes: Attributes running together or a URL query string in an unquoted attribute value.");
                                        }
                                    }
                                    default: {
                                        if (!(!this.html4 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ':')) {
                                            this.err("Non-name character in an unquoted attribute value. (This is an HTML4-only error.)");
                                        }
                                        this.appendLongStrBuf(c);
                                        break;
                                    }
                                }
                            }
lbl453:
                            // 1 sources

                            block323: while (true) {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': {
                                        continue block323;
                                    }
                                    case '/': {
                                        this.addAttributeWithoutValue();
                                        state = 44;
                                        break block323;
                                    }
                                    case '=': {
                                        state = 7;
                                        break block323;
                                    }
                                    case '>': {
                                        this.addAttributeWithoutValue();
                                        state = this.emitCurrentTagToken(false);
                                        if (!this.shouldSuspend) break block323;
                                        break block314;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        this.errQuoteInAttributeName(c);
                                    }
                                    default: {
                                        this.addAttributeWithoutValue();
                                        if (c >= 'A' && c <= 'Z') {
                                            this.clearStrBufAndAppendForceWrite((char)(c + 32));
                                        } else {
                                            this.clearStrBufAndAppendCurrentC(c);
                                        }
                                        state = 5;
                                        break block323;
                                    }
                                }
                                break;
                            }
                            continue block314;
lbl483:
                            // 1 sources

                            block324: while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '>': {
                                        this.emitComment(0);
                                        state = 0;
                                        continue block314;
                                    }
                                    case '-': {
                                        this.appendLongStrBuf(c);
                                        state = 57;
                                        cfr_temp_0 = 57;
                                        ** break;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        continue block324;
                                    }
                                }
                                break;
                            }
                            case 57: {
                                block325: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '>': {
                                            this.maybeAppendSpaceToBogusComment();
                                            this.emitComment(0);
                                            state = 0;
                                            break block325;
                                        }
                                        case '-': {
                                            this.appendSecondHyphenToBogusComment();
                                            continue block325;
                                        }
                                        default: {
                                            this.appendLongStrBuf(c);
                                            state = 12;
                                            break block325;
                                        }
                                    }
                                    break;
                                }
                                continue block314;
                            }
lbl522:
                            // 1 sources

                            block326: while (true) {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        this.appendLongStrBuf(c);
                                        state = 30;
                                        cfr_temp_0 = 30;
                                        ** break;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        continue block326;
                                    }
                                }
                                break;
                            }
                            case 30: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        this.appendLongStrBuf(c);
                                        state = 31;
                                        break;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        state = 29;
                                        continue block314;
                                    }
                                }
                            }
                            case 31: {
                                block327: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '>': {
                                            this.emitComment(2);
                                            state = 0;
                                            break block327;
                                        }
                                        case '-': {
                                            this.err("Consecutive hyphens did not terminate a comment. \u201c--\u201d is not permitted inside a comment, but e.g. \u201c- -\u201d is.");
                                            this.adjustDoubleHyphenAndAppendToLongStrBuf(c);
                                            continue block327;
                                        }
                                        default: {
                                            this.err("Consecutive hyphens did not terminate a comment. \u201c--\u201d is not permitted inside a comment, but e.g. \u201c- -\u201d is.");
                                            this.adjustDoubleHyphenAndAppendToLongStrBuf(c);
                                            state = 29;
                                            break block327;
                                        }
                                    }
                                    break;
                                }
                                continue block314;
                            }
lbl568:
                            // 2 sources

                            while ((c = this.read()) != '\u0000') {
                                if (this.index < 6) {
                                    folded = c;
                                    if (c >= 'A' && c <= 'Z') {
                                        folded = (char)(folded + 32);
                                    }
                                    if (folded == Tokenizer.OCTYPE[this.index]) {
                                        this.appendLongStrBuf(c);
                                        ++this.index;
                                        continue;
                                    }
                                    this.err("Bogus comment.");
                                    state = 12;
                                    reconsume = true;
                                    continue block314;
                                }
                                state = 14;
                                cfr_temp_0 = 14;
                                reconsume = true;
                                continue block315;
                            }
                            break block314;
                            case 14: {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                this.doctypeName = "";
                                this.systemIdentifier = null;
                                this.publicIdentifier = null;
                                this.forceQuirks = false;
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': {
                                        state = 15;
                                        break;
                                    }
                                    default: {
                                        this.err("Missing space before doctype name.");
                                        state = 15;
                                        reconsume = true;
                                    }
                                }
                            }
                            case 15: {
                                block329: while (true) {
                                    if (reconsume) {
                                        reconsume = false;
                                    } else {
                                        c = this.read();
                                    }
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            continue block329;
                                        }
                                        case '>': {
                                            this.err("Nameless doctype.");
                                            this.forceQuirks = true;
                                            this.emitDoctypeToken();
                                            this.cstart = this.pos + 1;
                                            state = 0;
                                            continue block314;
                                        }
                                        default: {
                                            if (c >= 'A' && c <= 'Z') {
                                                this.clearStrBufAndAppendForceWrite((char)(c + 32));
                                            } else {
                                                this.clearStrBufAndAppendCurrentC(c);
                                            }
                                            state = 16;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 16: {
                                block330: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            this.doctypeName = this.strBufToDoctypeName();
                                            state = 17;
                                            break block330;
                                        }
                                        case '>': {
                                            this.doctypeName = this.strBufToDoctypeName();
                                            this.emitDoctypeToken();
                                            this.cstart = this.pos + 1;
                                            state = 0;
                                            continue block314;
                                        }
                                        default: {
                                            if (c >= 'A' && c <= 'Z') {
                                                c = (char)(c + 32);
                                            }
                                            this.appendStrBuf(c);
                                            continue block330;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 17: {
                                block331: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case ' ': {
                                            continue block331;
                                        }
                                        case '>': {
                                            this.emitDoctypeToken();
                                            this.cstart = this.pos + 1;
                                            state = 0;
                                            continue block314;
                                        }
                                        case 'P': 
                                        case 'p': {
                                            this.index = 0;
                                            state = 35;
                                            break block331;
                                        }
                                        case 'S': 
                                        case 's': {
                                            this.index = 0;
                                            state = 36;
                                            continue block314;
                                        }
                                        default: {
                                            this.bogusDoctype();
                                            state = 26;
                                            continue block314;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 35: {
                                while ((c = this.read()) != '\u0000') {
                                    if (this.index < 5) {
                                        folded = c;
                                        if (c >= 'A' && c <= 'Z') {
                                            folded = (char)(folded + 32);
                                        }
                                        if (folded != Tokenizer.UBLIC[this.index]) {
                                            this.bogusDoctype();
                                            state = 26;
                                            reconsume = true;
                                            continue block314;
                                        }
                                        ++this.index;
                                        continue;
                                    }
                                    state = 18;
                                    reconsume = true;
                                }
                                break block314;
                            }
                            {
                                case 18: {
                                    block333: while (true) {
                                        if (reconsume) {
                                            reconsume = false;
                                        } else {
                                            c = this.read();
                                        }
                                        switch (c) {
                                            case '\u0000': {
                                                break block314;
                                            }
                                            case '\t': 
                                            case '\n': 
                                            case '\f': 
                                            case ' ': {
                                                continue block333;
                                            }
                                            case '\"': {
                                                this.clearLongStrBufForNextState();
                                                state = 19;
                                                break block333;
                                            }
                                            case '\'': {
                                                this.clearLongStrBufForNextState();
                                                state = 20;
                                                continue block314;
                                            }
                                            case '>': {
                                                this.err("Expected a public identifier but the doctype ended.");
                                                this.forceQuirks = true;
                                                this.emitDoctypeToken();
                                                this.cstart = this.pos + 1;
                                                state = 0;
                                                continue block314;
                                            }
                                            default: {
                                                this.bogusDoctype();
                                                state = 26;
                                                continue block314;
                                            }
                                        }
                                        break;
                                    }
                                }
                                case 19: {
                                    block334: while (true) {
                                        c = this.read();
                                        switch (c) {
                                            case '\u0000': {
                                                break block314;
                                            }
                                            case '\"': {
                                                this.publicIdentifier = this.longStrBufToString();
                                                state = 21;
                                                break block334;
                                            }
                                            case '>': {
                                                this.err("\u201c>\u201d in public identifier.");
                                                this.forceQuirks = true;
                                                this.publicIdentifier = this.longStrBufToString();
                                                this.emitDoctypeToken();
                                                this.cstart = this.pos + 1;
                                                state = 0;
                                                continue block314;
                                            }
                                            default: {
                                                this.appendLongStrBuf(c);
                                                continue block334;
                                            }
                                        }
                                        break;
                                    }
                                }
                                case 21: {
                                    block335: while (true) {
                                        c = this.read();
                                        switch (c) {
                                            case '\u0000': {
                                                break block314;
                                            }
                                            case '\t': 
                                            case '\n': 
                                            case '\f': 
                                            case ' ': {
                                                continue block335;
                                            }
                                            case '\"': {
                                                this.clearLongStrBufForNextState();
                                                state = 23;
                                                break block335;
                                            }
                                            case '\'': {
                                                this.clearLongStrBufForNextState();
                                                state = 24;
                                                continue block314;
                                            }
                                            case '>': {
                                                this.emitDoctypeToken();
                                                this.cstart = this.pos + 1;
                                                state = 0;
                                                continue block314;
                                            }
                                            default: {
                                                this.bogusDoctype();
                                                state = 26;
                                                continue block314;
                                            }
                                        }
                                        break;
                                    }
                                }
                                case 23: {
                                    while (true) {
                                        c = this.read();
                                        switch (c) {
                                            case '\u0000': {
                                                break block314;
                                            }
                                            case '\"': {
                                                this.systemIdentifier = this.longStrBufToString();
                                                state = 25;
                                                continue block314;
                                            }
                                            case '>': {
                                                this.err("\u201c>\u201d in system identifier.");
                                                this.forceQuirks = true;
                                                this.systemIdentifier = this.longStrBufToString();
                                                this.emitDoctypeToken();
                                                this.cstart = this.pos + 1;
                                                state = 0;
                                                continue block314;
                                            }
                                            default: {
                                                this.appendLongStrBuf(c);
                                                break;
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
lbl790:
                            // 1 sources

                            block337: while (true) {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': {
                                        continue block337;
                                    }
                                    case '>': {
                                        this.emitDoctypeToken();
                                        this.cstart = this.pos + 1;
                                        state = 0;
                                        continue block314;
                                    }
                                    default: {
                                        this.bogusDoctypeWithoutQuirks();
                                        cfr_temp_0 = 26;
                                        state = 26;
                                    }
                                }
                                break;
                            }
                            case 26: {
                                while (true) {
                                    if (reconsume) {
                                        reconsume = false;
                                    } else {
                                        c = this.read();
                                    }
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '>': {
                                            this.emitDoctypeToken();
                                            this.cstart = this.pos + 1;
                                            state = 0;
                                            continue block314;
                                        }
                                    }
                                }
                            }
lbl821:
                            // 1 sources

                            block339: while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': {
                                        continue block339;
                                    }
                                    case '\"': {
                                        this.clearLongStrBufForNextState();
                                        state = 23;
                                        continue block314;
                                    }
                                    case '\'': {
                                        this.clearLongStrBufForNextState();
                                        state = 24;
                                        cfr_temp_0 = 24;
                                        ** break;
                                    }
                                    case '>': {
                                        this.err("Expected a system identifier but the doctype ended.");
                                        this.forceQuirks = true;
                                        this.emitDoctypeToken();
                                        this.cstart = this.pos + 1;
                                        state = 0;
                                        continue block314;
                                    }
                                    default: {
                                        this.bogusDoctype();
                                        state = 26;
                                        continue block314;
                                    }
                                }
                                break;
                            }
                            case 24: {
                                while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '\'': {
                                            this.systemIdentifier = this.longStrBufToString();
                                            state = 25;
                                            continue block314;
                                        }
                                        case '>': {
                                            this.err("\u201c>\u201d in system identifier.");
                                            this.forceQuirks = true;
                                            this.systemIdentifier = this.longStrBufToString();
                                            this.emitDoctypeToken();
                                            this.cstart = this.pos + 1;
                                            state = 0;
                                            continue block314;
                                        }
                                        default: {
                                            this.appendLongStrBuf(c);
                                            break;
                                        }
                                    }
                                }
                            }
lbl873:
                            // 1 sources

                            while (true) {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\'': {
                                        this.publicIdentifier = this.longStrBufToString();
                                        state = 21;
                                        continue block314;
                                    }
                                    case '>': {
                                        this.err("\u201c>\u201d in public identifier.");
                                        this.forceQuirks = true;
                                        this.publicIdentifier = this.longStrBufToString();
                                        this.emitDoctypeToken();
                                        this.cstart = this.pos + 1;
                                        state = 0;
                                        continue block314;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        break;
                                    }
                                }
                            }
lbl894:
                            // 2 sources

                            while ((c = this.read()) != '\u0000') {
                                if (this.index < 6) {
                                    if (c == Tokenizer.CDATA_LSQB[this.index]) {
                                        this.appendLongStrBuf(c);
                                        ++this.index;
                                        continue;
                                    }
                                    this.err("Bogus comment.");
                                    state = 12;
                                    reconsume = true;
                                    continue block314;
                                }
                                this.cstart = this.pos;
                                state = 46;
                                cfr_temp_0 = 46;
                                reconsume = true;
                                continue block315;
                            }
                            break block314;
                            case 46: {
                                block343: while (true) {
                                    if (reconsume) {
                                        reconsume = false;
                                    } else {
                                        c = this.read();
                                    }
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case ']': {
                                            this.flushChars();
                                            state = 47;
                                            break block343;
                                        }
                                        default: {
                                            continue block343;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 47: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case ']': {
                                        state = 48;
                                        break;
                                    }
                                    default: {
                                        this.tokenHandler.characters(Tokenizer.RSQB_RSQB, 0, 1);
                                        this.cstart = this.pos;
                                        state = 46;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 48: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '>': {
                                        this.cstart = this.pos + 1;
                                        state = 0;
                                        break;
                                    }
                                    default: {
                                        this.tokenHandler.characters(Tokenizer.RSQB_RSQB, 0, 2);
                                        this.cstart = this.pos;
                                        state = 46;
                                        reconsume = true;
                                        break;
                                    }
                                }
                                continue block314;
                            }
lbl955:
                            // 1 sources

                            block344: while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '\'': {
                                        this.addAttributeWithValue();
                                        state = 11;
                                        continue block314;
                                    }
                                    case '&': {
                                        this.detachLongStrBuf();
                                        this.clearStrBufAndAppendCurrentC(c);
                                        this.additional = (char)39;
                                        this.rememberAmpersandLocation();
                                        returnState = state;
                                        state = 37;
                                        cfr_temp_0 = 37;
                                        ** break;
                                    }
                                    default: {
                                        this.appendLongStrBuf(c);
                                        continue block344;
                                    }
                                }
                                break;
                            }
                            case 37: {
                                c = this.read();
                                if (c == '\u0000') break block314;
                                switch (c) {
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case ' ': 
                                    case '&': 
                                    case '<': {
                                        this.emitOrAppendStrBuf(returnState);
                                        if ((returnState & -2) == 0) {
                                            this.cstart = this.pos;
                                        }
                                        state = returnState;
                                        reconsume = true;
                                        continue block314;
                                    }
                                    case '#': {
                                        this.appendStrBuf('#');
                                        state = 38;
                                        continue block314;
                                    }
                                }
                                if (c == this.additional) {
                                    this.emitOrAppendStrBuf(returnState);
                                    state = returnState;
                                    reconsume = true;
                                    continue block314;
                                }
                                this.entCol = -1;
                                this.lo = 0;
                                this.hi = NamedCharacters.NAMES.length - 1;
                                this.candidate = -1;
                                this.strBufMark = 0;
                                state = 39;
                                reconsume = true;
                            }
                            case 39: {
                                block345: while (true) {
                                    if (reconsume) {
                                        reconsume = false;
                                    } else {
                                        c = this.read();
                                    }
                                    if (c == '\u0000') break block314;
                                    ++this.entCol;
                                    while (this.hi != -1 && this.entCol != NamedCharacters.NAMES[this.hi].length) {
                                        if (this.entCol > NamedCharacters.NAMES[this.hi].length) break block345;
                                        if (c >= NamedCharacters.NAMES[this.hi][this.entCol]) break;
                                        --this.hi;
                                    }
                                    while (this.hi >= this.lo) {
                                        if (this.entCol == NamedCharacters.NAMES[this.lo].length) {
                                            this.candidate = this.lo++;
                                            this.strBufMark = this.strBufLen;
                                            continue;
                                        }
                                        if (this.entCol > NamedCharacters.NAMES[this.lo].length) break block345;
                                        if (c > NamedCharacters.NAMES[this.lo][this.entCol]) {
                                            ++this.lo;
                                            continue;
                                        }
                                        if (this.hi < this.lo) break block345;
                                        this.appendStrBuf(c);
                                        continue block345;
                                    }
                                    break;
                                }
                                if (this.candidate == -1) {
                                    this.errNoNamedCharacterMatch();
                                    this.emitOrAppendStrBuf(returnState);
                                    if ((returnState & -2) == 0) {
                                        this.cstart = this.pos;
                                    }
                                    state = returnState;
                                    reconsume = true;
                                    continue block314;
                                }
                                candidateArr = NamedCharacters.NAMES[this.candidate];
                                if (candidateArr[candidateArr.length - 1] != ';') {
                                    if ((returnState & -2) != 0 && ((ch = this.strBufMark == this.strBufLen ? c : this.strBuf[this.strBufMark]) >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                                        this.errNotSemicolonMatchInAttribute();
                                        this.appendStrBufToLongStrBuf();
                                        state = returnState;
                                        reconsume = true;
                                        continue block314;
                                    }
                                    if ((returnState & -2) != 0) {
                                        this.errUnescapedAmpersandInterpretedAsCharacterReference();
                                    } else {
                                        this.errNotSemicolonTerminated();
                                    }
                                }
                                val = NamedCharacters.VALUES[this.candidate];
                                this.emitOrAppend(val, returnState);
                                if (this.strBufMark < this.strBufLen) {
                                    if ((returnState & -2) != 0) {
                                        for (i = this.strBufMark; i < this.strBufLen; ++i) {
                                            this.appendLongStrBuf(this.strBuf[i]);
                                        }
                                    } else {
                                        this.tokenHandler.characters(this.strBuf, this.strBufMark, this.strBufLen - this.strBufMark);
                                    }
                                }
                                if ((returnState & -2) == 0) {
                                    this.cstart = this.pos;
                                }
                                state = returnState;
                                reconsume = true;
                                continue block314;
                            }
lbl1066:
                            // 1 sources

                            while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                if (c == '\u0000') break block314;
                                if (this.value < this.prevValue) {
                                    this.value = 0x110000;
                                }
                                this.prevValue = this.value;
                                if (c < '0' || c > '9') break;
                                this.seenDigits = true;
                                this.value *= 10;
                                this.value += c - 48;
                            }
                            if (c == ';') {
                                if (this.seenDigits) {
                                    state = 43;
                                    cfr_temp_0 = 43;
                                    if ((returnState & -2) != 0) continue block315;
                                    this.cstart = this.pos + 1;
                                    cfr_temp_0 = 43;
                                    continue block315;
                                }
                                this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
                                this.appendStrBuf(';');
                                this.emitOrAppendStrBuf(returnState);
                                if ((returnState & -2) == 0) {
                                    this.cstart = this.pos + 1;
                                }
                                state = returnState;
                                continue block314;
                            }
                            if (!this.seenDigits) {
                                this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
                                this.emitOrAppendStrBuf(returnState);
                                if ((returnState & -2) == 0) {
                                    this.cstart = this.pos;
                                }
                                state = returnState;
                                reconsume = true;
                                continue block314;
                            }
                            this.err("Character reference was not terminated by a semicolon.");
                            state = 43;
                            reconsume = true;
                            cfr_temp_0 = 43;
                            if ((returnState & -2) != 0) continue block315;
                            cfr_temp_0 = 43;
                            this.cstart = this.pos;
                            case 43: {
                                this.handleNcrValue(returnState);
                                state = returnState;
                                continue block314;
                            }
lbl1114:
                            // 4 sources

                            while ((c = this.read()) != '\u0000') {
                                if (this.value < this.prevValue) {
                                    this.value = 0x110000;
                                }
                                this.prevValue = this.value;
                                if (c >= '0' && c <= '9') {
                                    this.seenDigits = true;
                                    this.value *= 16;
                                    this.value += c - 48;
                                    continue;
                                }
                                if (c >= 'A' && c <= 'F') {
                                    this.seenDigits = true;
                                    this.value *= 16;
                                    this.value += c - 65 + 10;
                                    continue;
                                }
                                if (c >= 'a' && c <= 'f') {
                                    this.seenDigits = true;
                                    this.value *= 16;
                                    this.value += c - 97 + 10;
                                    continue;
                                }
                                if (c == ';') {
                                    if (this.seenDigits) {
                                        if ((returnState & -2) == 0) {
                                            this.cstart = this.pos + 1;
                                        }
                                        state = 43;
                                        continue block314;
                                    }
                                    this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
                                    this.appendStrBuf(';');
                                    this.emitOrAppendStrBuf(returnState);
                                    if ((returnState & -2) == 0) {
                                        this.cstart = this.pos + 1;
                                    }
                                    state = returnState;
                                    continue block314;
                                }
                                if (!this.seenDigits) {
                                    this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
                                    this.emitOrAppendStrBuf(returnState);
                                    if ((returnState & -2) == 0) {
                                        this.cstart = this.pos;
                                    }
                                    state = returnState;
                                    reconsume = true;
                                    continue block314;
                                }
                                this.err("Character reference was not terminated by a semicolon.");
                                if ((returnState & -2) == 0) {
                                    this.cstart = this.pos;
                                }
                                state = 43;
                                reconsume = true;
                                continue block314;
                            }
                            break block314;
lbl1161:
                            // 1 sources

                            while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                }
                            }
lbl1170:
                            // 1 sources

                            block352: while (true) {
                                if (reconsume) {
                                    reconsume = false;
                                } else {
                                    c = this.read();
                                }
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '<': {
                                        this.flushChars();
                                        returnState = state;
                                        state = 51;
                                        cfr_temp_0 = 51;
                                        ** break;
                                    }
                                    default: {
                                        continue block352;
                                    }
                                }
                                break;
                            }
                            case 51: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '!': {
                                        this.tokenHandler.characters(Tokenizer.LT_GT, 0, 1);
                                        this.cstart = this.pos;
                                        state = 52;
                                        break;
                                    }
                                    case '/': {
                                        if (this.contentModelElement != null) {
                                            this.index = 0;
                                            this.clearStrBufForNextState();
                                            state = 32;
                                            continue block314;
                                        }
                                    }
                                    default: {
                                        this.tokenHandler.characters(Tokenizer.LT_GT, 0, 1);
                                        this.cstart = this.pos;
                                        state = returnState;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 52: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        state = 53;
                                        break;
                                    }
                                    default: {
                                        state = returnState;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 53: {
                                c = this.read();
                                switch (c) {
                                    case '\u0000': {
                                        break block314;
                                    }
                                    case '-': {
                                        state = 56;
                                        break;
                                    }
                                    default: {
                                        state = returnState;
                                        reconsume = true;
                                        continue block314;
                                    }
                                }
                            }
                            case 56: {
                                block353: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '-': {
                                            continue block353;
                                        }
                                        case '>': {
                                            state = returnState;
                                            continue block314;
                                        }
                                        default: {
                                            state = 54;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 54: {
                                block354: while (true) {
                                    c = this.read();
                                    switch (c) {
                                        case '\u0000': {
                                            break block314;
                                        }
                                        case '-': {
                                            state = 55;
                                            break block354;
                                        }
                                        default: {
                                            continue block354;
                                        }
                                    }
                                    break;
                                }
                            }
                            case 55: 
                        }
                        break;
lbl1258:
                        // 13 sources

                    } while (true);
                    c = this.read();
                    switch (c) {
                        case '\u0000': {
                            break block314;
                        }
                        case '-': {
                            state = 56;
                            break;
                        }
                        default: {
                            state = 54;
                            break;
                        }
                    }
                    continue;
                }
                while ((c = this.read()) != '\u0000') {
                    if (!Tokenizer.$assertionsDisabled && this.contentModelElement == null) {
                        throw new AssertionError();
                    }
                    if (this.index < this.contentModelElementNameAsArray.length) {
                        e = this.contentModelElementNameAsArray[this.index];
                        folded = c;
                        if (c >= 'A' && c <= 'Z') {
                            folded = (char)(folded + 32);
                        }
                        if (folded != e) {
                            if (this.html4 && (this.index > 0 || folded >= 'a' && folded <= 'z') && ElementName.IFRAME != this.contentModelElement) {
                                this.err((this.stateSave == 0 ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement.name + "\u201d contained the string \u201c</\u201d, but it was not the start of the end tag. (HTML4-only error)");
                            }
                            this.tokenHandler.characters(Tokenizer.LT_SOLIDUS, 0, 2);
                            this.emitStrBuf();
                            this.cstart = this.pos;
                            state = returnState;
                            reconsume = true;
                            continue block314;
                        }
                        this.appendStrBuf(c);
                        ++this.index;
                        continue;
                    }
                    this.endTag = true;
                    this.tagName = this.contentModelElement;
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case ' ': {
                            state = 4;
                            break;
                        }
                        case '>': {
                            state = this.emitCurrentTagToken(false);
                            if (!this.shouldSuspend) break;
                            break block314;
                        }
                        case '/': {
                            state = 44;
                            break;
                        }
                        default: {
                            if (this.html4) {
                                this.err((this.stateSave == 0 ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement + "\u201d contained the string \u201c</\u201d, but it was not the start of the end tag. (HTML4-only error)");
                            } else {
                                this.warn((this.stateSave == 0 ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement + "\u201d contained the string \u201c</\u201d, but this did not close the element.");
                            }
                            this.tokenHandler.characters(Tokenizer.LT_SOLIDUS, 0, 2);
                            this.emitStrBuf();
                            this.cstart = this.pos;
                            state = returnState;
                            break;
                        }
                    }
                    continue block314;
                }
                break;
            }
            block356: while (true) {
                if (reconsume) {
                    reconsume = false;
                } else {
                    c = this.read();
                }
                switch (c) {
                    case '\u0000': {
                        break block314;
                    }
                    case '&': {
                        this.flushChars();
                        this.clearStrBufAndAppendCurrentC(c);
                        this.additional = '\u0000';
                        returnState = state;
                        state = 37;
                        continue block314;
                    }
                    case '<': {
                        this.flushChars();
                        returnState = state;
                        state = 51;
                        continue block314;
                    }
                    default: {
                        continue block356;
                    }
                }
                break;
            }
            break;
        }
        this.flushChars();
        if (this.prev == '\r' && this.pos != this.endPos) {
            --this.pos;
            --this.col;
        }
        this.stateSave = state;
        this.returnStateSave = returnState;
    }

    private void errUnescapedAmpersandInterpretedAsCharacterReference() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException("The string following \u201c&\u201d was interpreted as a character reference. (\u201c&\u201d probably should have been escaped as \u201c&amp;\u201d.)", this.ampersandLocation);
        this.errorHandler.error(spe);
    }

    private void errNotSemicolonTerminated() throws SAXException {
        this.err("Named character reference was not terminated by a semicolon. (Or \u201c&\u201d should have been escaped as \u201c&amp;\u201d.)");
    }

    private void errNotSemicolonMatchInAttribute() throws SAXException {
        this.errNoNamedCharacterMatch();
    }

    private void errNoNamedCharacterMatch() throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException("\u201c&\u201d did not start a character reference. (\u201c&\u201d probably should have been escaped as \u201c&amp;\u201d.)", this.ampersandLocation);
        this.errorHandler.error(spe);
    }

    private void errQuoteBeforeAttributeName(char c) throws SAXException {
        this.err("Saw \u201c" + c + "\u201d when expecting an attribute name. Probable cause: \u201c=\u201d missing immediately before.");
    }

    private void errQuoteInAttributeName(char c) throws SAXException {
        this.err("Quote \u201c" + c + "\u201d in attribute name. Probable cause: Matching quote missing somewhere earlier.");
    }

    private void rememberAmpersandLocation() {
        this.ampersandLocation = new LocatorImpl(this);
    }

    private void bogusDoctype() throws SAXException {
        this.err("Bogus doctype.");
        this.forceQuirks = true;
    }

    private void bogusDoctypeWithoutQuirks() throws SAXException {
        this.err("Bogus doctype.");
        this.forceQuirks = false;
    }

    private void emitOrAppendStrBuf(int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendStrBufToLongStrBuf();
        } else {
            this.emitStrBuf();
        }
    }

    private void handleNcrValue(int returnState) throws SAXException {
        if (this.value >= 128 && this.value <= 159) {
            this.err("A numeric character reference expanded to the C1 controls range.");
            char[] val = NamedCharacters.WINDOWS_1252[this.value - 128];
            this.emitOrAppendOne(val, returnState);
        } else if (this.value == 13) {
            this.err("A numeric character reference expanded to carriage return.");
            this.emitOrAppendOne(LF, returnState);
        } else if (this.value == 12 && this.contentSpacePolicy != XmlViolationPolicy.ALLOW) {
            if (this.contentSpacePolicy == XmlViolationPolicy.ALTER_INFOSET) {
                this.emitOrAppendOne(SPACE, returnState);
            } else if (this.contentSpacePolicy == XmlViolationPolicy.FATAL) {
                this.fatal("A character reference expanded to a form feed which is not legal XML 1.0 white space.");
            }
        } else if (this.value >= 0 && this.value <= 8 || this.value == 11 || this.value >= 14 && this.value <= 31 || this.value == 127) {
            this.err("Character reference expands to a control character (" + this.toUPlusString((char)this.value) + ").");
            this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
        } else if ((this.value & 0xF800) == 55296) {
            this.err("Character reference expands to a surrogate.");
            this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
        } else if (this.isNonCharacter(this.value)) {
            this.err("Character reference expands to a non-character.");
            this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
        } else if (this.value >= 64976 && this.value <= 65007) {
            this.err("Character reference expands to a permanently unassigned code point.");
            this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
        } else if (this.value <= 65535) {
            char ch = (char)this.value;
            if (this.errorHandler != null && this.isPrivateUse(ch)) {
                this.warnAboutPrivateUseChar();
            }
            this.bmpChar[0] = ch;
            this.emitOrAppendOne(this.bmpChar, returnState);
        } else if (this.value <= 0x10FFFF) {
            if (this.errorHandler != null && this.isAstralPrivateUse(this.value)) {
                this.warnAboutPrivateUseChar();
            }
            this.astralChar[0] = (char)(55232 + (this.value >> 10));
            this.astralChar[1] = (char)(56320 + (this.value & 0x3FF));
            this.emitOrAppend(this.astralChar, returnState);
        } else {
            this.err("Character reference outside the permissible Unicode range.");
            this.emitOrAppendOne(REPLACEMENT_CHARACTER, returnState);
        }
    }

    public void eof() throws SAXException {
        int state = this.stateSave;
        int returnState = this.returnStateSave;
        block30: while (true) {
            switch (state) {
                case 51: {
                    this.tokenHandler.characters(LT_GT, 0, 1);
                    break block30;
                }
                case 49: {
                    this.err("End of file in the tag open state.");
                    this.tokenHandler.characters(LT_GT, 0, 1);
                    break block30;
                }
                case 32: {
                    if (this.index < this.contentModelElementNameAsArray.length) break block30;
                    this.err("End of file inside end tag.");
                    this.endTag = true;
                    this.tagName = this.contentModelElement;
                    this.emitCurrentTagToken(false);
                    break block30;
                }
                case 50: {
                    this.err("Saw \u201c</\u201d immediately before end of file.");
                    this.tokenHandler.characters(LT_SOLIDUS, 0, 2);
                    break block30;
                }
                case 58: {
                    this.err("End of file seen when looking for tag name");
                    this.tagName = this.strBufToElementNameString();
                    this.emitCurrentTagToken(false);
                    break block30;
                }
                case 4: 
                case 11: 
                case 44: {
                    this.err("Saw end of file without the previous tag ending with \u201c>\u201d.");
                    this.emitCurrentTagToken(false);
                    break block30;
                }
                case 5: {
                    this.err("End of file occurred in an attribute name.");
                    this.attributeNameComplete();
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken(false);
                    break block30;
                }
                case 6: 
                case 7: {
                    this.err("Saw end of file without the previous tag ending with \u201c>\u201d.");
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken(false);
                    break block30;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.err("End of file reached when inside an attribute value.");
                    this.addAttributeWithValue();
                    this.emitCurrentTagToken(false);
                    break block30;
                }
                case 12: {
                    this.emitComment(0);
                    break block30;
                }
                case 57: {
                    this.maybeAppendSpaceToBogusComment();
                    this.emitComment(0);
                    break block30;
                }
                case 13: {
                    this.err("Bogus comment.");
                    this.clearLongStrBuf();
                    this.emitComment(0);
                    break block30;
                }
                case 33: {
                    this.err("Bogus comment.");
                    this.emitComment(0);
                    break block30;
                }
                case 34: {
                    if (this.index < 6) {
                        this.err("Bogus comment.");
                        this.emitComment(0);
                        break block30;
                    }
                    this.err("Expected space characters after \u201cDOCTYPE\u201d.");
                    this.err("End of file inside doctype.");
                    this.doctypeName = "";
                    this.publicIdentifier = null;
                    this.systemIdentifier = null;
                    this.forceQuirks = true;
                    this.emitDoctypeToken();
                    break block30;
                }
                case 27: 
                case 29: {
                    this.err("End of file inside comment.");
                    this.emitComment(0);
                    break block30;
                }
                case 31: {
                    this.err("End of file inside comment.");
                    this.emitComment(2);
                    break block30;
                }
                case 28: 
                case 30: {
                    this.err("End of file inside comment.");
                    this.emitComment(1);
                    break block30;
                }
                case 14: 
                case 15: {
                    this.err("End of file inside doctype.");
                    this.forceQuirks = true;
                    this.emitDoctypeToken();
                    break block30;
                }
                case 16: {
                    this.err("End of file inside doctype.");
                    this.doctypeName = this.strBufToDoctypeName();
                    this.forceQuirks = true;
                    this.emitDoctypeToken();
                    break block30;
                }
                case 17: 
                case 18: 
                case 35: 
                case 36: {
                    this.err("End of file inside doctype.");
                    this.forceQuirks = true;
                    this.emitDoctypeToken();
                    break block30;
                }
                case 19: 
                case 20: {
                    this.err("End of file inside public identifier.");
                    this.forceQuirks = true;
                    this.publicIdentifier = this.longStrBufToString();
                    this.emitDoctypeToken();
                    break block30;
                }
                case 21: 
                case 22: {
                    this.err("End of file inside doctype.");
                    this.forceQuirks = true;
                    this.emitDoctypeToken();
                    break block30;
                }
                case 23: 
                case 24: {
                    this.err("End of file inside system identifier.");
                    this.forceQuirks = true;
                    this.systemIdentifier = this.longStrBufToString();
                    this.emitDoctypeToken();
                    break block30;
                }
                case 25: {
                    this.err("End of file inside doctype.");
                    this.forceQuirks = true;
                    this.emitDoctypeToken();
                    break block30;
                }
                case 26: {
                    this.emitDoctypeToken();
                    break block30;
                }
                case 37: {
                    this.emitOrAppendStrBuf(returnState);
                    state = returnState;
                    continue block30;
                }
                case 39: {
                    block31: while (true) {
                        char c = '\u0000';
                        ++this.entCol;
                        while (this.hi != -1 && this.entCol != NamedCharacters.NAMES[this.hi].length) {
                            if (this.entCol > NamedCharacters.NAMES[this.hi].length) break block31;
                            if (c >= NamedCharacters.NAMES[this.hi][this.entCol]) break;
                            --this.hi;
                        }
                        while (this.hi >= this.lo) {
                            if (this.entCol == NamedCharacters.NAMES[this.lo].length) {
                                this.candidate = this.lo++;
                                this.strBufMark = this.strBufLen;
                                continue;
                            }
                            if (this.entCol > NamedCharacters.NAMES[this.lo].length) break block31;
                            if (c <= NamedCharacters.NAMES[this.lo][this.entCol]) continue block31;
                            ++this.lo;
                            continue;
                            if (this.hi >= this.lo) continue block31;
                        }
                        break;
                    }
                    if (this.candidate == -1) {
                        this.errNoNamedCharacterMatch();
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        continue block30;
                    }
                    char[] candidateArr = NamedCharacters.NAMES[this.candidate];
                    if (candidateArr[candidateArr.length - 1] != ';') {
                        int ch;
                        if ((returnState & 0xFFFFFFFE) != 0 && ((ch = this.strBufMark == this.strBufLen ? 0 : this.strBuf[this.strBufMark]) >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122)) {
                            this.errNotSemicolonMatchInAttribute();
                            this.appendStrBufToLongStrBuf();
                            state = returnState;
                            continue block30;
                        }
                        if ((returnState & 0xFFFFFFFE) != 0) {
                            this.errUnescapedAmpersandInterpretedAsCharacterReference();
                        } else {
                            this.errNotSemicolonTerminated();
                        }
                    }
                    char[] val = NamedCharacters.VALUES[this.candidate];
                    this.emitOrAppend(val, returnState);
                    if (this.strBufMark < this.strBufLen) {
                        if ((returnState & 0xFFFFFFFE) != 0) {
                            for (int i = this.strBufMark; i < this.strBufLen; ++i) {
                                this.appendLongStrBuf(this.strBuf[i]);
                            }
                        } else {
                            this.tokenHandler.characters(this.strBuf, this.strBufMark, this.strBufLen - this.strBufMark);
                        }
                    }
                    state = returnState;
                    continue block30;
                }
                case 38: 
                case 41: 
                case 42: {
                    if (!this.seenDigits) {
                        this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
                        this.emitOrAppendStrBuf(returnState);
                        state = returnState;
                        continue block30;
                    }
                    this.err("Character reference was not terminated by a semicolon.");
                    this.handleNcrValue(returnState);
                    state = returnState;
                    continue block30;
                }
            }
            break;
        }
        this.tokenHandler.eof();
    }

    private void emitDoctypeToken() throws SAXException {
        this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.systemIdentifier, this.forceQuirks);
        Portability.releaseLocal(this.doctypeName);
        Portability.releaseString(this.publicIdentifier);
        Portability.releaseString(this.systemIdentifier);
    }

    @Inline
    private char read() throws SAXException {
        ++this.pos;
        if (this.pos == this.endPos) {
            return '\u0000';
        }
        this.linePrev = this.line++;
        this.colPrev = this.col++;
        if (this.nextCharOnNewLine) {
            this.col = 1;
            this.nextCharOnNewLine = false;
        }
        char c = this.buf[this.pos];
        if (this.errorHandler == null && this.contentNonXmlCharPolicy == XmlViolationPolicy.ALLOW) {
            switch (c) {
                case '\r': {
                    this.nextCharOnNewLine = true;
                    this.buf[this.pos] = 10;
                    this.prev = (char)13;
                    return '\n';
                }
                case '\n': {
                    if (this.prev == '\r') {
                        return '\u0000';
                    }
                    this.nextCharOnNewLine = true;
                    break;
                }
                case '\u0000': {
                    this.buf[this.pos] = '\ufffd';
                    c = '\ufffd';
                }
            }
        } else {
            if (!this.confident && !this.alreadyComplainedAboutNonAscii && c > '\u007f') {
                this.complainAboutNonAscii();
                this.alreadyComplainedAboutNonAscii = true;
            }
            switch (c) {
                case '\r': {
                    this.nextCharOnNewLine = true;
                    this.buf[this.pos] = 10;
                    this.prev = (char)13;
                    return '\n';
                }
                case '\n': {
                    if (this.prev == '\r') {
                        return '\u0000';
                    }
                    this.nextCharOnNewLine = true;
                    break;
                }
                case '\u0000': {
                    this.err("Found U+0000 in the character stream.");
                    this.buf[this.pos] = '\ufffd';
                    c = '\ufffd';
                    break;
                }
                case '\f': {
                    if (this.contentNonXmlCharPolicy == XmlViolationPolicy.FATAL) {
                        this.fatal("This document is not mappable to XML 1.0 without data loss due to " + this.toUPlusString(c) + " which is not a legal XML 1.0 character.");
                        break;
                    }
                    if (this.contentNonXmlCharPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                        this.buf[this.pos] = ' ';
                        c = ' ';
                    }
                    this.warn("This document is not mappable to XML 1.0 without data loss due to " + this.toUPlusString(c) + " which is not a legal XML 1.0 character.");
                    break;
                }
                default: {
                    if ((c & 0xFC00) == 56320) {
                        if ((this.prev & 0xFC00) == 55296) {
                            int intVal = (this.prev << 10) + c + -56613888;
                            if (this.isNonCharacter(intVal)) {
                                this.err("Astral non-character.");
                            }
                            if (!this.isAstralPrivateUse(intVal)) break;
                            this.warnAboutPrivateUseChar();
                            break;
                        }
                        this.err("Found low surrogate without high surrogate.");
                        break;
                    }
                    if ((c < ' ' || this.isNonCharacter(c)) && c != '\t') {
                        switch (this.contentNonXmlCharPolicy) {
                            case FATAL: {
                                this.fatal("Forbidden code point " + this.toUPlusString(c) + ".");
                                break;
                            }
                            case ALTER_INFOSET: {
                                this.buf[this.pos] = '\ufffd';
                                c = '\ufffd';
                            }
                            case ALLOW: {
                                this.err("Forbidden code point " + this.toUPlusString(c) + ".");
                            }
                        }
                        break;
                    }
                    if (c >= '\u007f' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufddf') {
                        this.err("Forbidden code point " + this.toUPlusString(c) + ".");
                        break;
                    }
                    if (!this.isPrivateUse(c)) break;
                    this.warnAboutPrivateUseChar();
                }
            }
        }
        this.prev = c;
        return c;
    }

    private void complainAboutNonAscii() throws SAXException {
        String encoding = null;
        if (this.encodingDeclarationHandler != null) {
            encoding = this.encodingDeclarationHandler.getCharacterEncoding();
        }
        if (encoding == null) {
            this.err("The character encoding of the document was not explicit but the document contains non-ASCII.");
        } else {
            this.err("No explicit character encoding declaration has been seen yet (assumed \u201c" + encoding + "\u201d) but the document contains non-ASCII.");
        }
    }

    public boolean isAlreadyComplainedAboutNonAscii() {
        return this.alreadyComplainedAboutNonAscii;
    }

    public void internalEncodingDeclaration(String internalCharset) throws SAXException {
        if (this.encodingDeclarationHandler != null) {
            this.encodingDeclarationHandler.internalEncodingDeclaration(internalCharset);
        }
    }

    private void emitOrAppend(char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val);
        } else {
            this.tokenHandler.characters(val, 0, val.length);
        }
    }

    private void emitOrAppendOne(@NoLength char[] val, int returnState) throws SAXException {
        if ((returnState & 0xFFFFFFFE) != 0) {
            this.appendLongStrBuf(val[0]);
        } else {
            this.tokenHandler.characters(val, 0, 1);
        }
    }

    public void end() throws SAXException {
        this.strBuf = null;
        this.longStrBuf = null;
        this.systemIdentifier = null;
        this.publicIdentifier = null;
        this.doctypeName = null;
        this.tagName = null;
        this.attributeName = null;
        this.tokenHandler.endTokenization();
        if (this.attributes != null) {
            this.attributes.clear(this.mappingLangToXmlLang);
            Portability.delete(this.attributes);
            this.attributes = null;
        }
    }

    public void requestSuspension() {
        this.shouldSuspend = true;
    }

    public void becomeConfident() {
        this.confident = true;
    }

    public boolean isNextCharOnNewLine() {
        return this.nextCharOnNewLine;
    }

    public boolean isPrevCR() {
        return this.prev == '\r';
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean isInDataState() {
        return this.stateSave == 0;
    }
}

