/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public class TxnCounter
implements Transactional {
    private Semaphore writersWaiting = new Semaphore(1, true);
    private final AtomicLong value = new AtomicLong(-1712L);
    private ThreadLocal<IntegerState> txnValue = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<ReadWrite> txnMode = ThreadLocal.withInitial(() -> null);
    private Object txnLifecycleLock = new Object();

    private void releaseWriterLock() {
        int x = this.writersWaiting.availablePermits();
        if (x != 0) {
            throw new JenaTransactionException("TransactionCoordinator: Probably mismatch of enable/disableWriter calls");
        }
        this.writersWaiting.release();
    }

    private boolean acquireWriterLock(boolean canBlock) {
        if (!canBlock) {
            return this.writersWaiting.tryAcquire();
        }
        try {
            this.writersWaiting.acquire();
            return true;
        }
        catch (InterruptedException e2) {
            throw new JenaTransactionException(e2);
        }
    }

    public TxnCounter(long x) {
        this.value.set(x);
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.begin(readWrite, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(ReadWrite readWrite, boolean canBlock) {
        if (readWrite == ReadWrite.WRITE) {
            this.acquireWriterLock(canBlock);
        }
        Object object = this.txnLifecycleLock;
        synchronized (object) {
            if (this.txnMode.get() != null) {
                throw new JenaTransactionException("Already in a transaction");
            }
            IntegerState state = new IntegerState(this.value.get());
            this.txnValue.set(state);
            this.txnMode.set(readWrite);
        }
    }

    @Override
    public void commit() {
        this.checkTxn();
        if (this.isWriteTxn()) {
            this.value.set(this.getDataState().txnValue);
            this.txnValue.set(null);
            this.releaseWriterLock();
        }
        this.endOnce();
    }

    @Override
    public void abort() {
        this.checkTxn();
        if (this.isWriteTxn()) {
            this.txnValue.set(null);
            this.releaseWriterLock();
        }
        this.endOnce();
    }

    @Override
    public boolean isInTransaction() {
        ReadWrite mode = this.txnMode.get();
        if (mode == null) {
            this.txnMode.remove();
        }
        return mode != null;
    }

    @Override
    public void end() {
        if (!this.isInTransaction()) {
            return;
        }
        if (this.isWriteTxn() && this.txnValue.get() != null) {
            throw new JenaTransactionException("No commit or abort before end for a write transaction");
        }
        this.endOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOnce() {
        if (this.isActiveTxn()) {
            Object object = this.txnLifecycleLock;
            synchronized (object) {
                this.txnValue.remove();
                this.txnMode.remove();
            }
        }
    }

    public void inc() {
        this.checkWriteTxn();
        IntegerState ts = this.getDataState();
        ++ts.txnValue;
    }

    public void dec() {
        this.checkWriteTxn();
        IntegerState ts = this.getDataState();
        --ts.txnValue;
    }

    public long set(long x) {
        this.checkWriteTxn();
        IntegerState ts = this.getDataState();
        long v = ts.txnValue;
        ts.txnValue = x;
        return v;
    }

    public long read() {
        this.checkTxn();
        return this.getDataState().txnValue;
    }

    public long get() {
        if (this.isActiveTxn()) {
            return this.getDataState().txnValue;
        }
        return this.value.get();
    }

    public long value() {
        return this.value.get();
    }

    private boolean isWriteTxn() {
        ReadWrite rw = this.txnMode.get();
        if (rw == null) {
            throw new JenaTransactionException(Lib.classShortName(this.getClass()) + ".isWriteTxn called outside a transaction");
        }
        return this.txnMode.get() == ReadWrite.WRITE;
    }

    private boolean isActiveTxn() {
        ReadWrite rw = this.txnMode.get();
        return rw != null;
    }

    private IntegerState getDataState() {
        return this.txnValue.get();
    }

    private void checkWriteTxn() {
        if (!this.isWriteTxn()) {
            throw new JenaTransactionException("Not in a write transaction");
        }
    }

    private void checkTxn() {
        if (!this.isActiveTxn()) {
            throw new JenaTransactionException("Not in a transaction");
        }
    }

    static class IntegerState {
        long txnValue;

        public IntegerState(long v) {
            this.txnValue = v;
        }
    }
}

