/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.xs.opti.DefaultText;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class TextImpl
extends DefaultText {
    String fData = null;
    SchemaDOM fSchemaDOM = null;
    int fRow;
    int fCol;

    public TextImpl(StringBuffer str2, SchemaDOM sDOM, int row, int col) {
        this.fData = str2.toString();
        this.fSchemaDOM = sDOM;
        this.fRow = row;
        this.fCol = col;
        this.uri = null;
        this.localpart = null;
        this.prefix = null;
        this.rawname = null;
        this.nodeType = (short)3;
    }

    public String getNodeName() {
        return "#text";
    }

    public Node getParentNode() {
        return this.fSchemaDOM.relations[this.fRow][0];
    }

    public Node getPreviousSibling() {
        if (this.fCol == 1) {
            return null;
        }
        return this.fSchemaDOM.relations[this.fRow][this.fCol - 1];
    }

    public Node getNextSibling() {
        if (this.fCol == this.fSchemaDOM.relations[this.fRow].length - 1) {
            return null;
        }
        return this.fSchemaDOM.relations[this.fRow][this.fCol + 1];
    }

    public String getData() throws DOMException {
        return this.fData;
    }

    public int getLength() {
        if (this.fData == null) {
            return 0;
        }
        return this.fData.length();
    }

    public String substringData(int offset, int count) throws DOMException {
        if (this.fData == null) {
            return null;
        }
        if (count < 0 || offset < 0 || offset > this.fData.length()) {
            throw new DOMException(1, "parameter error");
        }
        if (offset + count >= this.fData.length()) {
            return this.fData.substring(offset);
        }
        return this.fData.substring(offset, offset + count);
    }
}

