/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import org.apache.xerces.jaxp.validation.Util;
import org.apache.xerces.jaxp.validation.ValidatorHelper;
import org.apache.xerces.jaxp.validation.XMLSchemaValidatorComponentManager;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XML11Configuration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.xml.sax.SAXException;

final class StreamValidatorHelper
implements ValidatorHelper {
    private static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    private static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private SoftReference fConfiguration = new SoftReference<Object>(null);
    private final XMLSchemaValidator fSchemaValidator;
    private final XMLSchemaValidatorComponentManager fComponentManager;
    private SoftReference fParser = new SoftReference<Object>(null);
    private SerializerFactory fSerializerFactory;

    public StreamValidatorHelper(XMLSchemaValidatorComponentManager componentManager) {
        this.fComponentManager = componentManager;
        this.fSchemaValidator = (XMLSchemaValidator)this.fComponentManager.getProperty(SCHEMA_VALIDATOR);
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result instanceof StreamResult || result == null) {
            StreamSource streamSource = (StreamSource)source;
            StreamResult streamResult = (StreamResult)result;
            XMLInputSource input = new XMLInputSource(streamSource.getPublicId(), streamSource.getSystemId(), null);
            input.setByteStream(streamSource.getInputStream());
            input.setCharacterStream(streamSource.getReader());
            boolean newConfig = false;
            XMLParserConfiguration config = (XMLParserConfiguration)this.fConfiguration.get();
            if (config == null) {
                config = this.initialize();
                newConfig = true;
            } else if (this.fComponentManager.getFeature(PARSER_SETTINGS)) {
                config.setProperty(ENTITY_RESOLVER, this.fComponentManager.getProperty(ENTITY_RESOLVER));
                config.setProperty(ERROR_HANDLER, this.fComponentManager.getProperty(ERROR_HANDLER));
                config.setProperty(SECURITY_MANAGER, this.fComponentManager.getProperty(SECURITY_MANAGER));
            }
            this.fComponentManager.reset();
            if (streamResult != null) {
                Serializer ser;
                if (this.fSerializerFactory == null) {
                    this.fSerializerFactory = SerializerFactory.getSerializerFactory("xml");
                }
                if (streamResult.getWriter() != null) {
                    ser = this.fSerializerFactory.makeSerializer(streamResult.getWriter(), new OutputFormat());
                } else if (streamResult.getOutputStream() != null) {
                    ser = this.fSerializerFactory.makeSerializer(streamResult.getOutputStream(), new OutputFormat());
                } else if (streamResult.getSystemId() != null) {
                    String uri = streamResult.getSystemId();
                    OutputStream out = XMLEntityManager.createOutputStream(uri);
                    ser = this.fSerializerFactory.makeSerializer(out, new OutputFormat());
                } else {
                    throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fComponentManager.getLocale(), "StreamResultNotInitialized", null));
                }
                SAXParser parser = (SAXParser)this.fParser.get();
                if (newConfig || parser == null) {
                    parser = new SAXParser(config);
                    this.fParser = new SoftReference<SAXParser>(parser);
                } else {
                    parser.reset();
                }
                config.setDocumentHandler(this.fSchemaValidator);
                this.fSchemaValidator.setDocumentHandler(parser);
                parser.setContentHandler(ser.asContentHandler());
            } else {
                this.fSchemaValidator.setDocumentHandler(null);
            }
            try {
                config.parse(input);
            }
            catch (XMLParseException e2) {
                throw Util.toSAXParseException(e2);
            }
            catch (XNIException e3) {
                throw Util.toSAXException(e3);
            }
            finally {
                this.fSchemaValidator.setDocumentHandler(null);
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fComponentManager.getLocale(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }

    private XMLParserConfiguration initialize() {
        XML11Configuration config = new XML11Configuration();
        config.setProperty(ENTITY_RESOLVER, this.fComponentManager.getProperty(ENTITY_RESOLVER));
        config.setProperty(ERROR_HANDLER, this.fComponentManager.getProperty(ERROR_HANDLER));
        XMLErrorReporter errorReporter = (XMLErrorReporter)this.fComponentManager.getProperty(ERROR_REPORTER);
        config.setProperty(ERROR_REPORTER, errorReporter);
        if (errorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
            XMLMessageFormatter xmft = new XMLMessageFormatter();
            errorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", xmft);
            errorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", xmft);
        }
        config.setProperty(SYMBOL_TABLE, this.fComponentManager.getProperty(SYMBOL_TABLE));
        config.setProperty(VALIDATION_MANAGER, this.fComponentManager.getProperty(VALIDATION_MANAGER));
        config.setProperty(SECURITY_MANAGER, this.fComponentManager.getProperty(SECURITY_MANAGER));
        config.setDocumentHandler(this.fSchemaValidator);
        config.setDTDHandler(null);
        config.setDTDContentModelHandler(null);
        this.fConfiguration = new SoftReference<XML11Configuration>(config);
        return config;
    }
}

