/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SubmoduleConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;

public class FetchCommand
extends TransportCommand<FetchCommand, FetchResult> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;

    protected FetchCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    private SubmoduleConfig.FetchRecurseSubmodulesMode getRecurseMode(String path) {
        if (this.submoduleRecurseMode != null) {
            return this.submoduleRecurseMode;
        }
        SubmoduleConfig.FetchRecurseSubmodulesMode mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "submodule", path, "fetchRecurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "fetch", null, "recurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        return SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND;
    }

    private void fetchSubmodules(FetchResult results) throws TransportException, GitAPIException, InvalidConfigurationException {
        try (SubmoduleWalk walk = new SubmoduleWalk(this.repo);
             RevWalk revWalk = new RevWalk(this.repo);){
            ObjectId fetchHead = this.repo.resolve("FETCH_HEAD");
            if (fetchHead == null) {
                return;
            }
            walk.setTree(revWalk.parseTree(fetchHead));
            while (walk.next()) {
                SubmoduleConfig.FetchRecurseSubmodulesMode recurseMode;
                Repository submoduleRepo = walk.getRepository();
                if (submoduleRepo == null || walk.getModulesPath() == null || walk.getConfigUrl() == null || ((recurseMode = this.getRecurseMode(walk.getPath())) != SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND || submoduleRepo.hasObject(walk.getObjectId())) && recurseMode != SubmoduleConfig.FetchRecurseSubmodulesMode.YES) continue;
                FetchCommand f = new FetchCommand(submoduleRepo).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setCheckFetchedObjects(this.checkFetchedObjects).setRemoveDeletedRefs(this.isRemoveDeletedRefs()).setThin(this.thin).setRefSpecs(this.refSpecs).setDryRun(this.dryRun).setRecurseSubmodules(recurseMode);
                results.addSubmodule(walk.getPath(), f.call());
            }
        }
        catch (IOException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
        catch (ConfigInvalidException e3) {
            throw new InvalidConfigurationException(e3.getMessage(), e3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try (Transport transport = Transport.open(this.repo, this.remote);){
            transport.setCheckFetchedObjects(this.checkFetchedObjects);
            transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
            transport.setDryRun(this.dryRun);
            if (this.tagOption != null) {
                transport.setTagOpt(this.tagOption);
            }
            transport.setFetchThin(this.thin);
            this.configure(transport);
            FetchResult result = transport.fetch(this.monitor, this.refSpecs);
            if (!this.repo.isBare()) {
                this.fetchSubmodules(result);
            }
            FetchResult fetchResult = result;
            return fetchResult;
        }
        catch (NoRemoteRepositoryException e2) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e2);
        }
        catch (org.eclipse.jgit.errors.TransportException e3) {
            throw new TransportException(e3.getMessage(), e3);
        }
        catch (URISyntaxException e4) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
        }
        catch (NotSupportedException e5) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, e5);
        }
    }

    public FetchCommand setRecurseSubmodules(SubmoduleConfig.FetchRecurseSubmodulesMode recurse) {
        this.checkCallable();
        this.submoduleRecurseMode = recurse;
        return this;
    }

    public FetchCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean checkFetchedObjects) {
        this.checkCallable();
        this.checkFetchedObjects = checkFetchedObjects;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean result = false;
        StoredConfig config = this.repo.getConfig();
        result = config.getBoolean("fetch", null, "prune", result);
        result = config.getBoolean("remote", this.remote, "prune", result);
        return result;
    }

    public FetchCommand setRemoveDeletedRefs(boolean removeDeletedRefs) {
        this.checkCallable();
        this.removeDeletedRefs = removeDeletedRefs;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(RefSpec ... specs) {
        this.checkCallable();
        this.refSpecs.clear();
        for (RefSpec spec : specs) {
            this.refSpecs.add(spec);
        }
        return this;
    }

    public FetchCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }
}

