/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long KiB = 1024L;
    private static final long MiB = 0x100000L;
    private static final long GiB = 0x40000000L;
    private static final int MAX_DEPTH = 10;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference<ConfigSnapshot> state;
    private final Config baseConfig;
    private static final String MAGIC_EMPTY_VALUE = new String();

    public Config() {
        this(null);
    }

    public Config(Config defaultConfig) {
        this.baseConfig = defaultConfig;
        this.state = new AtomicReference<ConfigSnapshot>(this.newState());
    }

    private static String escapeValue(String x) {
        boolean inquote = false;
        int lineStart = 0;
        StringBuilder r = new StringBuilder(x.length());
        block9: for (int k = 0; k < x.length(); ++k) {
            char c = x.charAt(k);
            switch (c) {
                case '\n': {
                    if (inquote) {
                        r.append('\"');
                        inquote = false;
                    }
                    r.append("\\n\\\n");
                    lineStart = r.length();
                    continue block9;
                }
                case '\t': {
                    r.append("\\t");
                    continue block9;
                }
                case '\b': {
                    r.append("\\b");
                    continue block9;
                }
                case '\\': {
                    r.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    r.append("\\\"");
                    continue block9;
                }
                case '#': 
                case ';': {
                    if (!inquote) {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(c);
                    continue block9;
                }
                case ' ': {
                    if (!inquote && r.length() > 0 && r.charAt(r.length() - 1) == ' ') {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(' ');
                    continue block9;
                }
                default: {
                    r.append(c);
                }
            }
        }
        if (inquote) {
            r.append('\"');
        }
        return r.toString();
    }

    public int getInt(String section, String name, int defaultValue) {
        return this.getInt(section, null, name, defaultValue);
    }

    public int getInt(String section, String subsection, String name, int defaultValue) {
        long val = this.getLong(section, subsection, name, defaultValue);
        if (Integer.MIN_VALUE <= val && val <= Integer.MAX_VALUE) {
            return (int)val;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueOutOfRange, section, name));
    }

    public long getLong(String section, String name, long defaultValue) {
        return this.getLong(section, null, name, defaultValue);
    }

    public long getLong(String section, String subsection, String name, long defaultValue) {
        String str2 = this.getString(section, subsection, name);
        if (str2 == null) {
            return defaultValue;
        }
        String n = str2.trim();
        if (n.length() == 0) {
            return defaultValue;
        }
        long mul = 1L;
        switch (StringUtils.toLowerCase(n.charAt(n.length() - 1))) {
            case 'g': {
                mul = 0x40000000L;
                break;
            }
            case 'm': {
                mul = 0x100000L;
                break;
            }
            case 'k': {
                mul = 1024L;
            }
        }
        if (mul > 1L) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return defaultValue;
        }
        try {
            return mul * Long.parseLong(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIntegerValue, section, name, str2));
        }
    }

    public boolean getBoolean(String section, String name, boolean defaultValue) {
        return this.getBoolean(section, null, name, defaultValue);
    }

    public boolean getBoolean(String section, String subsection, String name, boolean defaultValue) {
        String n = this.getRawString(section, subsection, name);
        if (n == null) {
            return defaultValue;
        }
        if (MAGIC_EMPTY_VALUE == n) {
            return true;
        }
        try {
            return StringUtils.toBoolean(n);
        }
        catch (IllegalArgumentException err) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidBooleanValue, section, name, n));
        }
    }

    public <T extends Enum<?>> T getEnum(String section, String subsection, String name, T defaultValue) {
        Enum[] all = Config.allValuesOf(defaultValue);
        return (T)this.getEnum(all, section, subsection, name, defaultValue);
    }

    private static <T> T[] allValuesOf(T value) {
        try {
            return (Object[])value.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception err) {
            String typeName = value.getClass().getName();
            String msg = MessageFormat.format(JGitText.get().enumValuesNotAvailable, typeName);
            throw new IllegalArgumentException(msg, err);
        }
    }

    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name, T defaultValue) {
        String value = this.getString(section, subsection, name);
        if (value == null) {
            return defaultValue;
        }
        if (all[0] instanceof ConfigEnum) {
            for (T t : all) {
                if (!((ConfigEnum)t).matchConfigValue(value)) continue;
                return t;
            }
        }
        String n = value.replace(' ', '_');
        n = n.replace('-', '_');
        T trueState = null;
        T falseState = null;
        for (T e2 : all) {
            if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), n)) {
                return e2;
            }
            if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), "TRUE")) {
                trueState = e2;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase(((Enum)e2).name(), "FALSE")) continue;
            falseState = e2;
        }
        if (trueState != null && falseState != null) {
            try {
                return StringUtils.toBoolean(n) ? trueState : falseState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (subsection != null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, subsection, name, value));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, section, name, value));
    }

    public String getString(String section, String subsection, String name) {
        return this.getRawString(section, subsection, name);
    }

    public String[] getStringList(String section, String subsection, String name) {
        String[] base = this.baseConfig != null ? this.baseConfig.getStringList(section, subsection, name) : EMPTY_STRING_ARRAY;
        String[] self = this.getRawStringList(section, subsection, name);
        if (self == null) {
            return base;
        }
        if (base.length == 0) {
            return self;
        }
        String[] res = new String[base.length + self.length];
        int n = base.length;
        System.arraycopy(base, 0, res, 0, n);
        System.arraycopy(self, 0, res, n, self.length);
        return res;
    }

    public long getTimeUnit(String section, String subsection, String name, long defaultValue, TimeUnit wantUnit) {
        int inputMul;
        TimeUnit inputUnit;
        String valueString = this.getString(section, subsection, name);
        if (valueString == null) {
            return defaultValue;
        }
        String s = valueString.trim();
        if (s.length() == 0) {
            return defaultValue;
        }
        if (s.startsWith("-")) {
            throw this.notTimeUnit(section, subsection, name, valueString);
        }
        Matcher m = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(valueString);
        if (!m.matches()) {
            return defaultValue;
        }
        String digits = m.group(1);
        String unitName = m.group(2).trim();
        if (unitName.isEmpty()) {
            inputUnit = wantUnit;
            inputMul = 1;
        } else if (Config.match(unitName, "ms", "milliseconds")) {
            inputUnit = TimeUnit.MILLISECONDS;
            inputMul = 1;
        } else if (Config.match(unitName, "s", "sec", "second", "seconds")) {
            inputUnit = TimeUnit.SECONDS;
            inputMul = 1;
        } else if (Config.match(unitName, "m", "min", "minute", "minutes")) {
            inputUnit = TimeUnit.MINUTES;
            inputMul = 1;
        } else if (Config.match(unitName, "h", "hr", "hour", "hours")) {
            inputUnit = TimeUnit.HOURS;
            inputMul = 1;
        } else if (Config.match(unitName, "d", "day", "days")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 1;
        } else if (Config.match(unitName, "w", "week", "weeks")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 7;
        } else if (Config.match(unitName, "mon", "month", "months")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 30;
        } else if (Config.match(unitName, "y", "year", "years")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 365;
        } else {
            throw this.notTimeUnit(section, subsection, name, valueString);
        }
        try {
            return wantUnit.convert(Long.parseLong(digits) * (long)inputMul, inputUnit);
        }
        catch (NumberFormatException nfe) {
            throw this.notTimeUnit(section, subsection, unitName, valueString);
        }
    }

    private static boolean match(String a, String ... cases) {
        for (String b : cases) {
            if (b == null || !b.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    private IllegalArgumentException notTimeUnit(String section, String subsection, String name, String valueString) {
        if (subsection != null) {
            return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue3, section, subsection, name, valueString));
        }
        return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue2, section, name, valueString));
    }

    public Set<String> getSubsections(String section) {
        return this.getState().getSubsections(section);
    }

    public Set<String> getSections() {
        return this.getState().getSections();
    }

    public Set<String> getNames(String section) {
        return this.getNames(section, null);
    }

    public Set<String> getNames(String section, String subsection) {
        return this.getState().getNames(section, subsection);
    }

    public Set<String> getNames(String section, boolean recursive) {
        return this.getState().getNames(section, null, recursive);
    }

    public Set<String> getNames(String section, String subsection, boolean recursive) {
        return this.getState().getNames(section, subsection, recursive);
    }

    public <T> T get(SectionParser<T> parser) {
        ConfigSnapshot myState = this.getState();
        Object obj = myState.cache.get(parser);
        if (obj == null) {
            obj = parser.parse(this);
            myState.cache.put(parser, obj);
        }
        return (T)obj;
    }

    public void uncache(SectionParser<?> parser) {
        this.state.get().cache.remove(parser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener listener) {
        return this.listeners.addConfigChangedListener(listener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    private String getRawString(String section, String subsection, String name) {
        String[] lst = this.getRawStringList(section, subsection, name);
        if (lst != null) {
            return lst[lst.length - 1];
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name);
        }
        return null;
    }

    private String[] getRawStringList(String section, String subsection, String name) {
        return this.state.get().get(section, subsection, name);
    }

    private ConfigSnapshot getState() {
        ConfigSnapshot base;
        ConfigSnapshot upd;
        ConfigSnapshot cur;
        do {
            cur = this.state.get();
            base = this.getBaseState();
            if (cur.baseState != base) continue;
            return cur;
        } while (!this.state.compareAndSet(cur, upd = new ConfigSnapshot(cur.entryList, base)));
        return upd;
    }

    private ConfigSnapshot getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String section, String subsection, String name, int value) {
        this.setLong(section, subsection, name, value);
    }

    public void setLong(String section, String subsection, String name, long value) {
        String s = value >= 0x40000000L && value % 0x40000000L == 0L ? String.valueOf(value / 0x40000000L) + "g" : (value >= 0x100000L && value % 0x100000L == 0L ? String.valueOf(value / 0x100000L) + "m" : (value >= 1024L && value % 1024L == 0L ? String.valueOf(value / 1024L) + "k" : String.valueOf(value)));
        this.setString(section, subsection, name, s);
    }

    public void setBoolean(String section, String subsection, String name, boolean value) {
        this.setString(section, subsection, name, value ? "true" : "false");
    }

    public <T extends Enum<?>> void setEnum(String section, String subsection, String name, T value) {
        String n = value instanceof ConfigEnum ? ((ConfigEnum)((Object)value)).toConfigValue() : value.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        this.setString(section, subsection, name, n);
    }

    public void setString(String section, String subsection, String name, String value) {
        this.setStringList(section, subsection, name, Collections.singletonList(value));
    }

    public void unset(String section, String subsection, String name) {
        this.setStringList(section, subsection, name, Collections.emptyList());
    }

    public void unsetSection(String section, String subsection) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.unsetSection(src, section, subsection))) {
        }
    }

    private ConfigSnapshot unsetSection(ConfigSnapshot srcState, String section, String subsection) {
        int max2 = srcState.entryList.size();
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        boolean lastWasMatch = false;
        for (ConfigLine e2 : srcState.entryList) {
            if (e2.match(section, subsection)) {
                lastWasMatch = true;
                continue;
            }
            if (lastWasMatch && e2.section == null && e2.subsection == null) continue;
            r.add(e2);
        }
        return this.newState(r);
    }

    public void setStringList(String section, String subsection, String name, List<String> values) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.replaceStringList(src, section, subsection, name, values))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private ConfigSnapshot replaceStringList(ConfigSnapshot srcState, String section, String subsection, String name, List<String> values) {
        ConfigLine e2;
        int entryIndex;
        List<ConfigLine> entries = Config.copy(srcState, values);
        int valueIndex = 0;
        int insertPosition = -1;
        for (entryIndex = 0; entryIndex < entries.size() && valueIndex < values.size(); ++entryIndex) {
            e2 = entries.get(entryIndex);
            if (!e2.match(section, subsection, name)) continue;
            entries.set(entryIndex, e2.forValue(values.get(valueIndex++)));
            insertPosition = entryIndex + 1;
        }
        if (valueIndex == values.size() && entryIndex < entries.size()) {
            while (entryIndex < entries.size()) {
                if (!(e2 = entries.get(entryIndex++)).match(section, subsection, name)) continue;
                entries.remove(--entryIndex);
            }
        }
        if (valueIndex < values.size() && entryIndex == entries.size()) {
            if (insertPosition < 0) {
                insertPosition = Config.findSectionEnd(entries, section, subsection);
            }
            if (insertPosition < 0) {
                e2 = new ConfigLine();
                e2.section = section;
                e2.subsection = subsection;
                entries.add(e2);
                insertPosition = entries.size();
            }
            while (valueIndex < values.size()) {
                e2 = new ConfigLine();
                e2.section = section;
                e2.subsection = subsection;
                e2.name = name;
                e2.value = values.get(valueIndex++);
                entries.add(insertPosition++, e2);
            }
        }
        return this.newState(entries);
    }

    private static List<ConfigLine> copy(ConfigSnapshot src, List<String> values) {
        int max2 = src.entryList.size() + values.size() + 1;
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        r.addAll(src.entryList);
        return r;
    }

    private static int findSectionEnd(List<ConfigLine> entries, String section, String subsection) {
        for (int i = 0; i < entries.size(); ++i) {
            ConfigLine e2 = entries.get(i);
            if (!e2.match(section, subsection, null)) continue;
            ++i;
            while (i < entries.size() && (e2 = entries.get(i)).match(section, subsection, e2.name)) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public String toText() {
        StringBuilder out = new StringBuilder();
        for (ConfigLine e2 : this.state.get().entryList) {
            if (e2.prefix != null) {
                out.append(e2.prefix);
            }
            if (e2.section != null && e2.name == null) {
                out.append('[');
                out.append(e2.section);
                if (e2.subsection != null) {
                    boolean quoted;
                    out.append(' ');
                    String escaped = Config.escapeValue(e2.subsection);
                    boolean bl = quoted = escaped.startsWith("\"") && escaped.endsWith("\"");
                    if (!quoted) {
                        out.append('\"');
                    }
                    out.append(escaped);
                    if (!quoted) {
                        out.append('\"');
                    }
                }
                out.append(']');
            } else if (e2.section != null && e2.name != null) {
                if (e2.prefix == null || "".equals(e2.prefix)) {
                    out.append('\t');
                }
                out.append(e2.name);
                if (MAGIC_EMPTY_VALUE != e2.value) {
                    out.append(" =");
                    if (e2.value != null) {
                        out.append(' ');
                        out.append(Config.escapeValue(e2.value));
                    }
                }
                if (e2.suffix != null) {
                    out.append(' ');
                }
            }
            if (e2.suffix != null) {
                out.append(e2.suffix);
            }
            out.append('\n');
        }
        return out.toString();
    }

    public void fromText(String text) throws ConfigInvalidException {
        this.state.set(this.newState(this.fromTextRecurse(text, 1)));
    }

    private List<ConfigLine> fromTextRecurse(String text, int depth) throws ConfigInvalidException {
        ArrayList<ConfigLine> newEntries;
        block15: {
            if (depth > 10) {
                throw new ConfigInvalidException(JGitText.get().tooManyIncludeRecursions);
            }
            newEntries = new ArrayList<ConfigLine>();
            StringReader in = new StringReader(text);
            ConfigLine last = null;
            ConfigLine e2 = new ConfigLine();
            while (true) {
                int input;
                if (-1 == (input = in.read())) {
                    if (e2.section != null) {
                        newEntries.add(e2);
                    }
                    break block15;
                }
                char c = (char)input;
                if ('\n' == c) {
                    newEntries.add(e2);
                    if (e2.section != null) {
                        last = e2;
                    }
                    e2 = new ConfigLine();
                    continue;
                }
                if (e2.suffix != null) {
                    e2.suffix = e2.suffix + c;
                    continue;
                }
                if (';' == c || '#' == c) {
                    e2.suffix = String.valueOf(c);
                    continue;
                }
                if (e2.section == null && Character.isWhitespace(c)) {
                    if (e2.prefix == null) {
                        e2.prefix = "";
                    }
                    e2.prefix = e2.prefix + c;
                    continue;
                }
                if ('[' == c) {
                    e2.section = Config.readSectionName(in);
                    input = in.read();
                    if (34 == input) {
                        e2.subsection = Config.readValue(in, true, 34);
                        input = in.read();
                    }
                    if (93 != input) {
                        throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                    }
                    e2.suffix = "";
                    continue;
                }
                if (last == null) break;
                e2.section = last.section;
                e2.subsection = last.subsection;
                in.reset();
                e2.name = Config.readKeyName(in);
                if (e2.name.endsWith("\n")) {
                    e2.name = e2.name.substring(0, e2.name.length() - 1);
                    e2.value = MAGIC_EMPTY_VALUE;
                } else {
                    e2.value = Config.readValue(in, false, -1);
                }
                if (!e2.section.equals("include")) continue;
                this.addIncludedConfig(newEntries, e2, depth);
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        return newEntries;
    }

    private void addIncludedConfig(List<ConfigLine> newEntries, ConfigLine line, int depth) throws ConfigInvalidException {
        if (!line.name.equals("path") || line.value == null || line.value.equals(MAGIC_EMPTY_VALUE)) {
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        File path = new File(line.value);
        try {
            byte[] bytes = IO.readFully(path);
            String decoded = this.isUtf8(bytes) ? RawParseUtils.decode(RawParseUtils.UTF8_CHARSET, bytes, 3, bytes.length) : RawParseUtils.decode(bytes);
            newEntries.addAll(this.fromTextRecurse(decoded, depth + 1));
        }
        catch (FileNotFoundException fnfe) {
            if (path.exists()) {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, path), fnfe);
            }
        }
        catch (IOException ioe) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, path), ioe);
        }
    }

    private ConfigSnapshot newState() {
        return new ConfigSnapshot(Collections.emptyList(), this.getBaseState());
    }

    private ConfigSnapshot newState(List<ConfigLine> entries) {
        return new ConfigSnapshot(Collections.unmodifiableList(entries), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    protected boolean isUtf8(byte[] bytes) {
        return bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
    }

    private static String readSectionName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block6: {
            name = new StringBuilder();
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == c) {
                    in.reset();
                    break block6;
                }
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != c) continue;
                        in.reset();
                        break block6;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
                }
                if (!Character.isLetterOrDigit((char)c) && 46 != c && 45 != c) break;
                name.append((char)c);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
        }
        return name.toString();
    }

    private static String readKeyName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block7: {
            int c;
            name = new StringBuilder();
            while (true) {
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == c) break block7;
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == c) break block7;
                        if (59 != c && 35 != c && 10 != c) continue;
                        in.reset();
                        break block7;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)c) && c != 45) break;
                name.append((char)c);
            }
            if (10 == c) {
                in.reset();
                name.append((char)c);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, name));
            }
        }
        return name.toString();
    }

    private static String readValue(StringReader in, boolean quote, int eol) throws ConfigInvalidException {
        int c;
        StringBuilder value = new StringBuilder();
        boolean space = false;
        block9: while ((c = in.read()) >= 0) {
            if (10 == c) {
                if (quote) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                in.reset();
                break;
            }
            if (eol == c) break;
            if (!quote) {
                if (Character.isWhitespace((char)c)) {
                    space = true;
                    continue;
                }
                if (59 == c || 35 == c) {
                    in.reset();
                    break;
                }
            }
            if (space) {
                if (value.length() > 0) {
                    value.append(' ');
                }
                space = false;
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block9;
                    }
                    case 116: {
                        value.append('\t');
                        continue block9;
                    }
                    case 98: {
                        value.append('\b');
                        continue block9;
                    }
                    case 110: {
                        value.append('\n');
                        continue block9;
                    }
                    case 92: {
                        value.append('\\');
                        continue block9;
                    }
                    case 34: {
                        value.append('\"');
                        continue block9;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.valueOf((char)c)));
            }
            if (34 == c) {
                quote = !quote;
                continue;
            }
            value.append((char)c);
        }
        return value.length() > 0 ? value.toString() : null;
    }

    public static interface ConfigEnum {
        public String toConfigValue();

        public boolean matchConfigValue(String var1);
    }

    public static interface SectionParser<T> {
        public T parse(Config var1);
    }

    private static class StringReader {
        private final char[] buf;
        private int pos;

        StringReader(String in) {
            this.buf = in.toCharArray();
        }

        int read() {
            try {
                return this.buf[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                this.pos = this.buf.length;
                return -1;
            }
        }

        void reset() {
            --this.pos;
        }
    }
}

