/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.compare.CreatorSheet;
import org.spdx.compare.DocumentAnnotationSheet;
import org.spdx.compare.DocumentRelationshipSheet;
import org.spdx.compare.DocumentSheet;
import org.spdx.compare.ExternalReferencesSheet;
import org.spdx.compare.ExtractedLicenseSheet;
import org.spdx.compare.FileAnnotationSheet;
import org.spdx.compare.FileArtifactOfSheet;
import org.spdx.compare.FileChecksumSheet;
import org.spdx.compare.FileCommentSheet;
import org.spdx.compare.FileConcludedSheet;
import org.spdx.compare.FileContributorsSheet;
import org.spdx.compare.FileCopyrightSheet;
import org.spdx.compare.FileDependenciesSheet;
import org.spdx.compare.FileLicenseCommentsSheet;
import org.spdx.compare.FileLicenseInfoSheet;
import org.spdx.compare.FileNoticeSheet;
import org.spdx.compare.FileRelationshipSheet;
import org.spdx.compare.FileSpdxIdSheet;
import org.spdx.compare.FileTypeSheet;
import org.spdx.compare.NormalizedFileNameComparator;
import org.spdx.compare.PackageSheet;
import org.spdx.compare.ReviewerSheet;
import org.spdx.compare.SnippetSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.VerificationSheet;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class MultiDocumentSpreadsheet
extends AbstractSpreadsheet {
    private SpdxFileComparator fileComparator = new SpdxFileComparator();
    static Logger logger = LoggerFactory.getLogger(MultiDocumentSpreadsheet.class);
    private static final String DOCUMENT_SHEET_NAME = "Document";
    private DocumentSheet documentSheet = new DocumentSheet(this.workbook, "Document");
    private static final String CREATOR_SHEET_NAME = "Creator";
    private CreatorSheet creatorSheet;
    private static final String PACKAGE_SHEET_NAME = "Package";
    private PackageSheet packageSheet;
    private static final String EXTRACTED_LICENSE_SHEET_NAME = "Extracted Licenses";
    private ExtractedLicenseSheet extractedLicenseSheet;
    private static final String FILE_CHECKSUM_SHEET_NAME = "File Checksum";
    private FileChecksumSheet fileChecksumSheet;
    private static final String FILE_CONCLUDED_SHEET_NAME = "File Concluded";
    private FileConcludedSheet fileConcludedSheet;
    private static final String FILE_FOUND_SHEET_NAME = "File Found Licenses";
    private FileLicenseInfoSheet fileLicenseInfoSheet;
    private static final String FILE_LICENSE_COMMENT_SHEET_NAME = "File License Comment";
    private FileLicenseCommentsSheet fileLicenseCommentsSheet;
    private static final String FILE_COMMENT_SHEET_NAME = "File Comment";
    private FileCommentSheet fileCommentSheet;
    private static final String FILE_ARTIFACT_OF_SHEET_NAME = "File ArtifactOf";
    private FileArtifactOfSheet fileArtifactOfSheet;
    private static final String FILE_TYPE_SHEET_NAME = "File Type";
    private FileTypeSheet fileTypeSheet;
    private static final String REVIEWER_SHEET_NAME = "Reviewers";
    private ReviewerSheet reviewerSheet;
    private static final String FILE_CONTRIBUTOR_SHEET_NAME = "File Contributors";
    private FileContributorsSheet fileContributorsSheet;
    private static final String FILE_DEPENDENCIES_SHEET_NAME = "File Dependencies";
    private FileDependenciesSheet fileDependenciesSheet;
    private static final String FILE_NOTICE_SHEET_NAME = "File Notices";
    private FileNoticeSheet fileNoticeSheet;
    private static final String VERIFICATION_SHEET_NAME = "Verification Errors";
    public static final int MAX_DOCUMENTS = 25;
    private static final String EXTERNAL_REFERENCES_SHEET_NAME = "Ext. Doc. References";
    private static final String DOCUMENT_RELATIONSHIP_SHEET_NAME = "Doc. Relationships";
    private static final String DOCUMENT_ANNOTATION_SHEET_NAME = "Doc. Annotations";
    private static final String FILE_SPDX_ID_SHEET_NAME = "File IDs";
    private static final String FILE_COPYRIGHT_SHEET_NAME = "File Copyrights";
    private static final String FILE_ANNOTATION_SHEET_NAME = "File Annot.";
    private static final String FILE_RELATIONSHIP_SHEET = "File Relationships";
    private static final String SNIPPET_SHEET_NAME = "Snippets";
    private VerificationSheet verificationSheet;
    private ExternalReferencesSheet externalReferencesSheet = new ExternalReferencesSheet(this.workbook, "Ext. Doc. References");
    private DocumentAnnotationSheet documentAnnotationSheet;
    private DocumentRelationshipSheet documentRelationshipSheet;
    private FileSpdxIdSheet fileSpdxIdSheet;
    private FileCopyrightSheet fileCopyrightSheet;
    private FileAnnotationSheet fileAnnotationSheet;
    private FileRelationshipSheet fileRelationshipSheet;
    private SnippetSheet snippetSheet;

    public MultiDocumentSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        super(spreadsheetFile, create, readonly);
        this.creatorSheet = new CreatorSheet(this.workbook, CREATOR_SHEET_NAME);
        this.documentAnnotationSheet = new DocumentAnnotationSheet(this.workbook, DOCUMENT_ANNOTATION_SHEET_NAME);
        this.documentRelationshipSheet = new DocumentRelationshipSheet(this.workbook, DOCUMENT_RELATIONSHIP_SHEET_NAME);
        this.packageSheet = new PackageSheet(this.workbook, PACKAGE_SHEET_NAME);
        this.extractedLicenseSheet = new ExtractedLicenseSheet(this.workbook, EXTRACTED_LICENSE_SHEET_NAME);
        this.fileSpdxIdSheet = new FileSpdxIdSheet(this.workbook, FILE_SPDX_ID_SHEET_NAME);
        this.fileTypeSheet = new FileTypeSheet(this.workbook, FILE_TYPE_SHEET_NAME);
        this.fileChecksumSheet = new FileChecksumSheet(this.workbook, FILE_CHECKSUM_SHEET_NAME);
        this.fileConcludedSheet = new FileConcludedSheet(this.workbook, FILE_CONCLUDED_SHEET_NAME);
        this.fileLicenseInfoSheet = new FileLicenseInfoSheet(this.workbook, FILE_FOUND_SHEET_NAME);
        this.fileLicenseCommentsSheet = new FileLicenseCommentsSheet(this.workbook, FILE_LICENSE_COMMENT_SHEET_NAME);
        this.fileCopyrightSheet = new FileCopyrightSheet(this.workbook, FILE_COPYRIGHT_SHEET_NAME);
        this.fileArtifactOfSheet = new FileArtifactOfSheet(this.workbook, FILE_ARTIFACT_OF_SHEET_NAME);
        this.fileCommentSheet = new FileCommentSheet(this.workbook, FILE_COMMENT_SHEET_NAME);
        this.fileNoticeSheet = new FileNoticeSheet(this.workbook, FILE_NOTICE_SHEET_NAME);
        this.fileContributorsSheet = new FileContributorsSheet(this.workbook, FILE_CONTRIBUTOR_SHEET_NAME);
        this.fileDependenciesSheet = new FileDependenciesSheet(this.workbook, FILE_DEPENDENCIES_SHEET_NAME);
        this.fileAnnotationSheet = new FileAnnotationSheet(this.workbook, FILE_ANNOTATION_SHEET_NAME);
        this.fileRelationshipSheet = new FileRelationshipSheet(this.workbook, FILE_RELATIONSHIP_SHEET);
        this.snippetSheet = new SnippetSheet(this.workbook, SNIPPET_SHEET_NAME);
        this.reviewerSheet = new ReviewerSheet(this.workbook, REVIEWER_SHEET_NAME);
        this.verificationSheet = new VerificationSheet(this.workbook, VERIFICATION_SHEET_NAME);
        String verify = this.verifyWorkbook();
        if (verify != null && !verify.isEmpty()) {
            logger.error("Invalid workbook: " + verify);
            throw new SpreadsheetException("Invalid workbook: " + verify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error("Unable to create " + spreadsheetFile.getName());
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        try (FileOutputStream excelOut = null;){
            excelOut = new FileOutputStream(spreadsheetFile);
            HSSFWorkbook wb = new HSSFWorkbook();
            DocumentSheet.create(wb, DOCUMENT_SHEET_NAME);
            CreatorSheet.create(wb, CREATOR_SHEET_NAME);
            ExternalReferencesSheet.create(wb, EXTERNAL_REFERENCES_SHEET_NAME);
            DocumentAnnotationSheet.create(wb, DOCUMENT_ANNOTATION_SHEET_NAME);
            DocumentRelationshipSheet.create(wb, DOCUMENT_RELATIONSHIP_SHEET_NAME);
            PackageSheet.create(wb, PACKAGE_SHEET_NAME);
            ExtractedLicenseSheet.create(wb, EXTRACTED_LICENSE_SHEET_NAME);
            FileSpdxIdSheet.create(wb, FILE_SPDX_ID_SHEET_NAME);
            FileChecksumSheet.create(wb, FILE_CHECKSUM_SHEET_NAME);
            FileConcludedSheet.create(wb, FILE_CONCLUDED_SHEET_NAME);
            FileLicenseInfoSheet.create(wb, FILE_FOUND_SHEET_NAME);
            FileCommentSheet.create(wb, FILE_COMMENT_SHEET_NAME);
            FileCopyrightSheet.create(wb, FILE_COPYRIGHT_SHEET_NAME);
            FileLicenseCommentsSheet.create(wb, FILE_LICENSE_COMMENT_SHEET_NAME);
            FileArtifactOfSheet.create(wb, FILE_ARTIFACT_OF_SHEET_NAME);
            FileTypeSheet.create(wb, FILE_TYPE_SHEET_NAME);
            FileContributorsSheet.create(wb, FILE_CONTRIBUTOR_SHEET_NAME);
            FileDependenciesSheet.create(wb, FILE_DEPENDENCIES_SHEET_NAME);
            FileNoticeSheet.create(wb, FILE_NOTICE_SHEET_NAME);
            FileAnnotationSheet.create(wb, FILE_ANNOTATION_SHEET_NAME);
            FileRelationshipSheet.create(wb, FILE_RELATIONSHIP_SHEET);
            SnippetSheet.create(wb, SNIPPET_SHEET_NAME);
            ReviewerSheet.create(wb, REVIEWER_SHEET_NAME);
            VerificationSheet.create(wb, VERIFICATION_SHEET_NAME);
            wb.write(excelOut);
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (docNames == null) {
            throw new SpdxCompareException("Doc names can not be null");
        }
        if (comparer == null) {
            throw new SpdxCompareException("Comparer names can not be null");
        }
        if (docNames.length != comparer.getNumSpdxDocs()) {
            throw new SpdxCompareException("Number of document names does not match the number of documents compared");
        }
        SpdxFile[][] files = new SpdxFile[comparer.getNumSpdxDocs()][];
        for (int i = 0; i < files.length; ++i) {
            SpdxFile[] docFiles = comparer.collectAllFiles(comparer.getSpdxDoc(i));
            Arrays.sort(docFiles, this.fileComparator);
            files[i] = docFiles;
        }
        this.documentSheet.importCompareResults(comparer, docNames);
        this.documentSheet.resizeRows();
        this.creatorSheet.importCompareResults(comparer, docNames);
        this.creatorSheet.resizeRows();
        this.externalReferencesSheet.importCompareResults(comparer, docNames);
        this.externalReferencesSheet.resizeRows();
        this.documentAnnotationSheet.importCompareResults(comparer, docNames);
        this.documentAnnotationSheet.resizeRows();
        this.documentRelationshipSheet.importCompareResults(comparer, docNames);
        this.documentRelationshipSheet.resizeRows();
        this.packageSheet.importCompareResults(comparer, docNames);
        this.packageSheet.resizeRows();
        this.fileSpdxIdSheet.importCompareResults(comparer, files, docNames);
        this.fileSpdxIdSheet.resizeRows();
        this.extractedLicenseSheet.importCompareResults(comparer, docNames);
        this.extractedLicenseSheet.resizeRows();
        this.fileChecksumSheet.importCompareResults(comparer, files, docNames);
        this.fileChecksumSheet.resizeRows();
        this.fileConcludedSheet.importCompareResults(comparer, files, docNames);
        this.fileConcludedSheet.resizeRows();
        this.fileLicenseInfoSheet.importCompareResults(comparer, files, docNames);
        this.fileLicenseInfoSheet.resizeRows();
        this.fileCopyrightSheet.importCompareResults(comparer, files, docNames);
        this.fileCopyrightSheet.resizeRows();
        this.fileCommentSheet.importCompareResults(comparer, files, docNames);
        this.fileCommentSheet.resizeRows();
        this.fileLicenseCommentsSheet.importCompareResults(comparer, files, docNames);
        this.fileLicenseCommentsSheet.resizeRows();
        this.fileArtifactOfSheet.importCompareResults(comparer, files, docNames);
        this.fileArtifactOfSheet.resizeRows();
        this.fileTypeSheet.importCompareResults(comparer, files, docNames);
        this.fileTypeSheet.resizeRows();
        this.fileContributorsSheet.importCompareResults(comparer, files, docNames);
        this.fileContributorsSheet.resizeRows();
        this.fileDependenciesSheet.importCompareResults(comparer, files, docNames);
        this.fileDependenciesSheet.resizeRows();
        this.fileNoticeSheet.importCompareResults(comparer, files, docNames);
        this.fileNoticeSheet.resizeRows();
        this.fileAnnotationSheet.importCompareResults(comparer, files, docNames);
        this.fileAnnotationSheet.resizeRows();
        this.fileRelationshipSheet.importCompareResults(comparer, files, docNames);
        this.fileRelationshipSheet.resizeRows();
        this.reviewerSheet.importCompareResults(comparer, docNames);
        this.reviewerSheet.resizeRows();
        this.snippetSheet.importCompareResults(comparer, docNames);
        this.snippetSheet.resizeRows();
    }

    @Override
    public void clear() {
        this.documentSheet.clear();
        this.creatorSheet.clear();
        this.packageSheet.clear();
        this.extractedLicenseSheet.clear();
        this.fileChecksumSheet.clear();
        this.fileConcludedSheet.clear();
        this.fileLicenseInfoSheet.clear();
        this.fileLicenseCommentsSheet.clear();
        this.fileArtifactOfSheet.clear();
        this.reviewerSheet.clear();
        this.verificationSheet.clear();
        this.fileCommentSheet.clear();
        this.fileContributorsSheet.clear();
        this.fileDependenciesSheet.clear();
        this.fileNoticeSheet.clear();
        this.snippetSheet.clear();
    }

    @Override
    public String verifyWorkbook() {
        StringBuilder sb = new StringBuilder();
        String sheetVerify = this.documentSheet.verify();
        if (sheetVerify != null && !sheetVerify.isEmpty()) {
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.creatorSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.packageSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.extractedLicenseSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileChecksumSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileConcludedSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileLicenseInfoSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileCommentSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileLicenseCommentsSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileArtifactOfSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.reviewerSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileContributorsSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileDependenciesSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileNoticeSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.verificationSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.snippetSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void importVerificationErrors(List<String>[] verificationErrors, String[] docNames) throws SpreadsheetException {
        this.verificationSheet.importVerificationErrors(verificationErrors, docNames);
        this.verificationSheet.resizeRows();
    }

    private static final class SpdxFileComparator
    implements Comparator<SpdxFile> {
        private NormalizedFileNameComparator normalizedFileNameComparator = new NormalizedFileNameComparator();

        private SpdxFileComparator() {
        }

        @Override
        public int compare(SpdxFile arg0, SpdxFile arg1) {
            return this.normalizedFileNameComparator.compare(arg0.getName(), arg1.getName());
        }
    }
}

