/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseTOCJSONFile
extends AbstractJsonFile {
    public static final String JSON_REFERENCE_FIELD = "detailsUrl";
    List<ListedSpdxLicense> listedLicenses = Lists.newArrayList();
    private int currentRefNumber = 1;
    String version;
    String releaseDate;

    public LicenseTOCJSONFile(String version2, String releaseDate) {
        this.version = version2;
        this.releaseDate = releaseDate;
    }

    public void addLicense(SpdxListedLicense license, String licHTMLReference, String licJSONReference, boolean deprecated) {
        this.listedLicenses.add(new ListedSpdxLicense(licHTMLReference, String.valueOf(this.currentRefNumber), license.getLicenseId(), license.isOsiApproved(), license.getFsfLibre(), license.getName(), license.getSeeAlso(), deprecated, this.relativeToAbsolute(licJSONReference)));
        ++this.currentRefNumber;
    }

    private String relativeToAbsolute(String relativeRef) {
        String retval = relativeRef.startsWith("./") ? relativeRef.substring(2) : relativeRef;
        retval = "http://spdx.org/licenses/" + retval;
        return retval;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("licenseListVersion", this.version);
        jsonObject.put("releaseDate", this.releaseDate);
        JSONArray licensesList = new JSONArray();
        for (ListedSpdxLicense license : this.listedLicenses) {
            JSONObject licenseJSON = new JSONObject();
            licenseJSON.put("reference", license.getReference());
            licenseJSON.put("referenceNumber", license.getRefNumber());
            licenseJSON.put("licenseId", license.getLicenseId());
            licenseJSON.put("isOsiApproved", license.getOsiApproved());
            if (license.getFsfLibre() != null) {
                licenseJSON.put("isFsfLibre", license.getFsfLibre());
            }
            licenseJSON.put("name", license.getLicenseName());
            String[] seeAlsos = license.getSeeAlso();
            if (seeAlsos != null && seeAlsos.length > 0) {
                JSONArray seeAlsoArray = new JSONArray();
                for (String seeAlso : seeAlsos) {
                    seeAlsoArray.add(seeAlso);
                }
                licenseJSON.put("seeAlso", seeAlsoArray);
            }
            licenseJSON.put("isDeprecatedLicenseId", license.isDeprecated());
            licenseJSON.put(JSON_REFERENCE_FIELD, license.getLicJSONReference());
            licensesList.add(licenseJSON);
        }
        jsonObject.put("licenses", licensesList);
        return jsonObject;
    }

    private static class ListedSpdxLicense {
        private final String reference;
        private final String refNumber;
        private final String licenseId;
        private final boolean osiApproved;
        private final Boolean fsfLibre;
        private final String licenseName;
        private final String[] seeAlso;
        private boolean deprecated;
        private String licJSONReference;

        public ListedSpdxLicense(String reference, String refNumber, String licenseId, boolean osiApproved, Boolean fsfLibre, String licenseName, String[] seeAlso, boolean deprecated, String licJSONReference) {
            this.reference = reference;
            this.refNumber = refNumber;
            this.licenseId = licenseId;
            this.osiApproved = osiApproved;
            this.fsfLibre = fsfLibre;
            this.licenseName = licenseName;
            this.seeAlso = seeAlso;
            this.deprecated = deprecated;
            this.licJSONReference = licJSONReference;
        }

        public String getLicJSONReference() {
            return this.licJSONReference;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getReference() {
            return this.reference;
        }

        public String getRefNumber() {
            return this.refNumber;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public boolean getOsiApproved() {
            return this.osiApproved;
        }

        public Boolean getFsfLibre() {
            return this.fsfLibre;
        }

        public String getLicenseName() {
            return this.licenseName;
        }

        public String[] getSeeAlso() {
            return this.seeAlso;
        }
    }
}

