/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;

public class SPDXReview
implements Comparable<SPDXReview> {
    private String reviewer = null;
    private String reviewDate = null;
    private String comment = null;
    private Model model = null;
    private Node reviewerNode = null;
    private Resource reviewerResource = null;

    public SPDXReview(Model model, Node reviewerNode) throws InvalidSPDXAnalysisException {
        Triple t;
        this.model = model;
        this.reviewerNode = reviewerNode;
        if (reviewerNode.isBlank()) {
            this.reviewerResource = model.createResource(new AnonId(reviewerNode.getBlankNodeId()));
        } else if (reviewerNode.isURI()) {
            this.reviewerResource = model.createResource(reviewerNode.getURI());
        } else {
            throw new InvalidSPDXAnalysisException("Can not have a Review node as a literal");
        }
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "reviewer").asNode();
        Triple m = Triple.createMatch(reviewerNode, p, null);
        ExtendedIterator<Triple> tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.reviewer = t.getObject().toString(false);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "reviewDate").asNode();
        m = Triple.createMatch(reviewerNode, p, null);
        tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.reviewDate = t.getObject().toString(false);
        }
        p = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m = Triple.createMatch(reviewerNode, p, null);
        tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.comment = t.getObject().toString(false);
        }
    }

    public SPDXReview(String reviewer, String date2, String comment) {
        this.reviewer = reviewer;
        this.reviewDate = date2;
        this.comment = comment;
    }

    public Resource createResource(Model model) {
        Resource type = model.createResource("http://spdx.org/rdf/terms#Review");
        Resource retval = model.createResource(type);
        this.populateModel(model, retval);
        return retval;
    }

    private void populateModel(Model model, Resource reviewResource) {
        Property p;
        this.model = model;
        this.reviewerNode = reviewResource.asNode();
        this.reviewerResource = reviewResource;
        if (this.reviewer != null) {
            p = model.createProperty("http://spdx.org/rdf/terms#", "reviewer");
            reviewResource.addProperty(p, this.reviewer);
        }
        if (this.reviewDate != null) {
            p = model.createProperty("http://spdx.org/rdf/terms#", "reviewDate");
            reviewResource.addProperty(p, this.reviewDate);
        }
        if (this.comment != null) {
            p = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            reviewResource.addProperty(p, this.comment);
        }
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
        if (this.reviewerNode != null && this.model != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "reviewer");
            this.model.removeAll(this.reviewerResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "reviewer");
            this.reviewerResource.addProperty(p, reviewer);
        }
    }

    public String getReviewDate() {
        return this.reviewDate;
    }

    public void setReviewDate(String reviewDate) {
        this.reviewDate = reviewDate;
        if (this.reviewerNode != null && this.model != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "reviewDate");
            this.model.removeAll(this.reviewerResource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "reviewDate");
            this.reviewerResource.addProperty(p, reviewDate);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.reviewerNode != null && this.model != null) {
            Property p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.reviewerResource, p, null);
            if (comment != null) {
                p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
                this.reviewerResource.addProperty(p, comment);
            }
        }
    }

    public int hashCode() {
        int retval = 41;
        if (this.getReviewer() != null) {
            retval ^= this.getReviewer().hashCode();
        }
        if (this.getComment() != null) {
            retval ^= this.getComment().hashCode();
        }
        if (this.getReviewDate() != null) {
            retval ^= this.getReviewDate().hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPDXReview)) {
            return false;
        }
        SPDXReview comp = (SPDXReview)o;
        if (this.getReviewer() == null ? comp.getReviewer() != null : comp.getReviewer() == null || !this.getReviewer().equals(comp.getReviewer())) {
            return false;
        }
        if (this.getComment() == null ? comp.getComment() != null : comp.getComment() == null || !this.getComment().equals(comp.getComment())) {
            return false;
        }
        return !(this.getReviewDate() == null ? comp.getReviewDate() != null : comp.getReviewDate() == null || !this.getReviewDate().equals(comp.getReviewDate()));
    }

    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        String reviewer = this.getReviewer();
        if (reviewer == null || reviewer.isEmpty()) {
            retval.add("Missing required reviewer");
        } else {
            String verify = SpdxVerificationHelper.verifyReviewer(reviewer);
            if (verify != null) {
                retval.add(verify);
            }
        }
        String reviewDate = this.getReviewDate();
        if (reviewDate == null || reviewDate.isEmpty()) {
            retval.add("Missing required review date");
        } else {
            String verify = SpdxVerificationHelper.verifyDate(reviewDate);
            if (verify != null) {
                retval.add(verify);
            }
        }
        return retval;
    }

    @Override
    public int compareTo(SPDXReview o) {
        if (this.getReviewDate() == null) {
            if (o.getReviewDate() == null) {
                if (this.getReviewer() == null) {
                    if (o.getReviewer() == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o.getReviewer() == null) {
                    return -1;
                }
                return this.getReviewer().compareTo(o.getReviewer());
            }
            return 1;
        }
        if (o.getReviewDate() == null) {
            return -1;
        }
        return this.getReviewDate().compareTo(o.getReviewDate());
    }
}

