/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.CompareHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class PerFileSheetV1d2
extends PerFileSheet {
    static final int NUM_COLS = 15;
    static final int FILE_NAME_COL = 0;
    static final int FILE_TYPE_COL = 1;
    static final int SHA1_COL = 2;
    static final int CONCLUDED_LIC_COL = 3;
    static final int LIC_INFO_IN_FILE_COL = 4;
    static final int LIC_COMMENTS_COL = 5;
    static final int SEEN_COPYRIGHT_COL = 6;
    static final int NOTICE_TEXT_COL = 7;
    static final int ARTIFACT_OF_PROJECT_COL = 8;
    static final int ARTIFACT_OF_HOMEPAGE_COL = 9;
    static final int ARTIFACT_OF_PROJECT_URL_COL = 10;
    static final int FILE_DEPENDENCIES_COL = 11;
    static final int CONTRIBUTORS_COL = 12;
    static final int COMMENT_COL = 13;
    static final int USER_DEFINED_COL = 14;
    static final boolean[] REQUIRED = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"File Name", "File Type", "File Checksum", "License Concluded", "License Info in File", "License Comments", "File Copyright Text", "Notice Text", "Artifact of Project", "Artifact of Homepage", "Artifact of URL", "File Dependencies", "Contribuors", "File Comment", "User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{60, 10, 25, 30, 30, 40, 40, 40, 25, 60, 60, 60, 60, 60, 60};
    static final boolean[] LEFT_WRAP = new boolean[]{true, false, true, true, true, true, true, true, true, true, true, true, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
    Map<String, SpdxFile> fileCache = Maps.newHashMap();

    public PerFileSheetV1d2(Workbook workbook, String sheetName, String version2) {
        super(workbook, sheetName, version2);
    }

    @Override
    public void add(SpdxFile fileInfo, String pkgId) {
        Row row = this.addRow();
        if (fileInfo.getArtifactOf() != null && fileInfo.getArtifactOf().length > 0) {
            DoapProject[] projects = fileInfo.getArtifactOf();
            String[] projectNames = new String[projects.length];
            String[] projectHomePages = new String[projects.length];
            String[] projectUrls = new String[projects.length];
            for (int i = 0; i < projects.length; ++i) {
                String projectName = projects[i].getName();
                if (projectName == null) {
                    projectName = "";
                }
                projectNames[i] = projectName;
                String projectHomePage = projects[i].getHomePage();
                if (projectHomePage == null) {
                    projectHomePage = "";
                }
                projectHomePages[i] = projectHomePage;
                String projectUrl = projects[i].getProjectUri();
                if (projectUrl == null) {
                    projectUrl = "";
                }
                projectUrls[i] = projectUrl;
            }
            row.createCell(8).setCellValue(PerFileSheetV1d2.stringsToCsv(projectNames));
            row.createCell(9).setCellValue(PerFileSheetV1d2.stringsToCsv(projectHomePages));
            row.createCell(10).setCellValue(PerFileSheetV1d2.stringsToCsv(projectUrls));
        }
        if (fileInfo.getLicenseConcluded() != null) {
            row.createCell(3).setCellValue(fileInfo.getLicenseConcluded().toString());
        }
        row.createCell(0).setCellValue(fileInfo.getName());
        if (fileInfo.getSha1() != null && !fileInfo.getSha1().isEmpty()) {
            row.createCell(2).setCellValue(fileInfo.getSha1());
        }
        row.createCell(1).setCellValue(CompareHelper.fileTypesToString(fileInfo.getFileTypes()));
        if (fileInfo.getLicenseComments() != null && !fileInfo.getLicenseComments().isEmpty()) {
            row.createCell(5).setCellValue(fileInfo.getLicenseComments());
        }
        if (fileInfo.getCopyrightText() != null && !fileInfo.getCopyrightText().isEmpty()) {
            row.createCell(6).setCellValue(fileInfo.getCopyrightText());
        }
        if (fileInfo.getLicenseInfoFromFiles() != null && fileInfo.getLicenseInfoFromFiles().length > 0) {
            row.createCell(4).setCellValue(PackageInfoSheet.licensesToString(fileInfo.getLicenseInfoFromFiles()));
        }
        if (fileInfo.getComment() != null && !fileInfo.getComment().isEmpty()) {
            row.createCell(13).setCellValue(fileInfo.getComment());
        }
        if (fileInfo.getFileContributors() != null && fileInfo.getFileContributors().length > 0) {
            row.createCell(12).setCellValue(PerFileSheetV1d2.stringsToCsv(fileInfo.getFileContributors()));
        }
        if (fileInfo.getFileDependencies() != null && fileInfo.getFileDependencies().length > 0) {
            SpdxFile[] fileDependencies = fileInfo.getFileDependencies();
            String[] fileDependencyNames = new String[fileDependencies.length];
            for (int i = 0; i < fileDependencies.length; ++i) {
                fileDependencyNames[i] = fileDependencies[i].getName();
            }
            row.createCell(11).setCellValue(PerFileSheetV1d2.stringsToCsv(fileDependencyNames));
        }
        if (fileInfo.getNoticeText() != null && !fileInfo.getNoticeText().isEmpty()) {
            row.createCell(7).setCellValue(fileInfo.getNoticeText());
        }
    }

    @Override
    public SpdxFile getFileInfo(int rowNum, SpdxDocumentContainer container2) throws SpreadsheetException {
        SpdxFile retval;
        Cell artifactOfUrlCell;
        Cell artifactOfHomePageCell;
        Cell licCommentCell;
        AnyLicenseInfo[] seenLicenses;
        SpdxFile.FileType[] types;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String name = row.getCell(0).getStringCellValue();
        if (this.fileCache.containsKey(name)) {
            return this.fileCache.get(name);
        }
        String typeStr = row.getCell(1).getStringCellValue();
        try {
            types = CompareHelper.parseFileTypeString(typeStr);
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error converting file types: " + e1.getMessage());
        }
        Cell sha1cell = row.getCell(2);
        String sha1 = sha1cell != null ? sha1cell.getStringCellValue() : "";
        Cell assertedLicenseCell = row.getCell(3);
        AnyLicenseInfo fileLicenses = assertedLicenseCell != null && !assertedLicenseCell.getStringCellValue().isEmpty() ? LicenseInfoFactory.parseSPDXLicenseString(assertedLicenseCell.getStringCellValue(), container2) : null;
        Cell seenLicenseCell = row.getCell(4);
        if (seenLicenseCell != null && !seenLicenseCell.getStringCellValue().isEmpty()) {
            String[] licenseStrings = seenLicenseCell.getStringCellValue().split(",");
            seenLicenses = new AnyLicenseInfo[licenseStrings.length];
            for (int i = 0; i < licenseStrings.length; ++i) {
                seenLicenses[i] = LicenseInfoFactory.parseSPDXLicenseString(licenseStrings[i].trim(), container2);
            }
        } else {
            seenLicenses = null;
        }
        String licenseComments = (licCommentCell = row.getCell(5)) != null ? licCommentCell.getStringCellValue() : "";
        Cell copyrightCell = row.getCell(6);
        String copyright = copyrightCell != null ? copyrightCell.getStringCellValue() : "";
        String[] projectNames = new String[]{};
        String[] projectHomePages = new String[]{};
        String[] projectUrls = new String[]{};
        Cell artifactOfNameCell = row.getCell(8);
        if (artifactOfNameCell != null && !artifactOfNameCell.getStringCellValue().isEmpty()) {
            projectNames = PerFileSheetV1d2.csvToStrings(artifactOfNameCell.getStringCellValue());
        }
        if ((artifactOfHomePageCell = row.getCell(9)) != null && !artifactOfHomePageCell.getStringCellValue().isEmpty()) {
            projectHomePages = PerFileSheetV1d2.csvToStrings(artifactOfHomePageCell.getStringCellValue());
        }
        if ((artifactOfUrlCell = row.getCell(10)) != null && !artifactOfUrlCell.getStringCellValue().isEmpty()) {
            projectUrls = PerFileSheetV1d2.csvToStrings(artifactOfUrlCell.getStringCellValue());
        }
        int numProjects = projectNames.length;
        DoapProject[] projects = new DoapProject[numProjects];
        for (int i = 0; i < numProjects; ++i) {
            String homePage = null;
            if (projectHomePages.length > i) {
                homePage = projectHomePages[i];
            }
            projects[i] = new DoapProject(projectNames[i], homePage);
            if (projectUrls.length <= i || projectUrls[i].isEmpty()) continue;
            try {
                projects[i].setProjectUri(projectUrls[i]);
                continue;
            }
            catch (InvalidSPDXAnalysisException e2) {
                throw new SpreadsheetException("Error setting the URI for the artifact of");
            }
        }
        SpdxFile[] fileDependencies = new SpdxFile[]{};
        Cell fileDependencyCells = row.getCell(11);
        if (fileDependencyCells != null && !fileDependencyCells.getStringCellValue().isEmpty()) {
            String[] fileDependencyNames = PerFileSheetV1d2.csvToStrings(fileDependencyCells.getStringCellValue());
            fileDependencies = new SpdxFile[fileDependencyNames.length];
            for (int i = 0; i < fileDependencyNames.length; ++i) {
                fileDependencies[i] = this.findFileByName(fileDependencyNames[i].trim(), container2);
            }
        }
        String[] contributors = new String[]{};
        Cell contributorCell = row.getCell(12);
        if (contributorCell != null && !contributorCell.getStringCellValue().trim().isEmpty()) {
            contributors = PerFileSheetV1d2.csvToStrings(contributorCell.getStringCellValue().trim());
        }
        String noticeText = null;
        Cell noticeCell = row.getCell(7);
        if (noticeCell != null) {
            noticeText = noticeCell.getStringCellValue().trim();
        }
        String comment = null;
        Cell commentCell = row.getCell(13);
        if (commentCell != null) {
            comment = commentCell.getStringCellValue();
        }
        try {
            retval = new SpdxFile(name, comment, new Annotation[0], new Relationship[0], fileLicenses, seenLicenses, copyright, licenseComments, types, new Checksum[]{new Checksum(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, sha1)}, contributors, noticeText, projects);
            retval.setFileDependencies(fileDependencies);
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new SpreadsheetException("Error creating new SPDX file: " + e3.getMessage());
        }
        this.fileCache.put(name, retval);
        return retval;
    }

    public SpdxFile findFileByName(String fileName, SpdxDocumentContainer container2) throws SpreadsheetException {
        if (this.fileCache.containsKey(fileName)) {
            return this.fileCache.get(fileName);
        }
        for (int i = this.firstRowNum; i < this.lastRowNum + 1; ++i) {
            Cell fileNameCell = this.sheet.getRow(i).getCell(0);
            if (!fileNameCell.getStringCellValue().trim().equals(fileName)) continue;
            return this.getFileInfo(i, container2);
        }
        throw new SpreadsheetException("Could not find dependant file in the spreadsheet: " + fileName);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX File does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 14; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX File worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX File work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 15; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            if (i != 3 && i != 4) continue;
            try {
                LicenseInfoFactory.parseSPDXLicenseString(cell.getStringCellValue(), null);
                continue;
            }
            catch (SpreadsheetException ex) {
                if (i == 3) {
                    return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                }
                return "Invalid seen license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
            }
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    @Override
    public String[] getPackageIds(int row) {
        return new String[0];
    }
}

