/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.spdx.tools.LicenseGeneratorException;

public class FsfLicenseDataParser {
    static final String PROP_USE_ONLY_LOCAL_FILE = "LocalFsfFreeJson";
    static final String PROP_FSF_FREE_JSON_URL = "FsfFreeJsonUrl";
    static final String DEFAULT_FSF_JSON_URL = "https://wking.github.io/fsf-api/licenses-full.json";
    static final String FSF_JSON_FILE_PATH = "resources" + File.separator + "licenses-full.json";
    static final String FSF_JSON_CLASS_PATH = "resources/licenses-full.json";
    private static FsfLicenseDataParser fsfLicenseDataParser = null;
    private Map<String, Boolean> licenseIdToFsfFree = Maps.newHashMap();
    private boolean useOnlyLocalFile = Boolean.parseBoolean(System.getProperty("LocalFsfFreeJson", "false"));
    private String licenseJsonUrl = System.getProperty("FsfFreeJsonUrl", "https://wking.github.io/fsf-api/licenses-full.json");

    private FsfLicenseDataParser() throws LicenseGeneratorException {
        Reader reader = null;
        try {
            if (!this.useOnlyLocalFile) {
                try {
                    URL url = new URL(this.licenseJsonUrl);
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                }
                catch (MalformedURLException e2) {
                    reader = null;
                }
                catch (IOException e3) {
                    reader = null;
                }
            }
            if (reader == null) {
                try {
                    reader = new BufferedReader(new FileReader(FSF_JSON_FILE_PATH));
                }
                catch (FileNotFoundException e4) {
                    reader = null;
                }
            }
            if (reader == null) {
                try {
                    reader = new BufferedReader(new FileReader(FSF_JSON_CLASS_PATH));
                }
                catch (FileNotFoundException e5) {
                    throw new LicenseGeneratorException("Unable to open reader for the FSF API");
                }
            }
            JSONObject fsfLicenses = (JSONObject)JSONValue.parseWithException(reader);
            for (Map.Entry entry : fsfLicenses.entrySet()) {
                String spdxId;
                JSONObject fsfLicense = (JSONObject)entry.getValue();
                JSONObject identifiers = (JSONObject)fsfLicense.get("identifiers");
                if (identifiers == null || (spdxId = (String)identifiers.get("spdx")) == null) continue;
                Boolean fsfLibre = false;
                JSONArray tags = (JSONArray)fsfLicense.get("tags");
                if (tags != null) {
                    for (Object tag : tags) {
                        if (!"libre".equals(tag)) continue;
                        fsfLibre = true;
                        break;
                    }
                }
                this.licenseIdToFsfFree.put(spdxId, fsfLibre);
            }
        }
        catch (IOException e6) {
            throw new LicenseGeneratorException("IO error reading FSF license information");
        }
        catch (ParseException e7) {
            throw new LicenseGeneratorException("Parsing error reading FSF license information");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e8) {
                    throw new LicenseGeneratorException("Unable to close reader for the FSF API");
                }
            }
        }
    }

    public static synchronized FsfLicenseDataParser getFsfLicenseDataParser() throws LicenseGeneratorException {
        if (fsfLicenseDataParser == null) {
            fsfLicenseDataParser = new FsfLicenseDataParser();
        }
        return fsfLicenseDataParser;
    }

    public Boolean isSpdxLicenseFsfLibre(String spdxLicenseId) {
        return this.licenseIdToFsfFree.get(spdxLicenseId);
    }
}

