/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;
import org.spdx.tools.licensegenerator.LicenseHtmlFormatWriter;

public class LicenseTextFormatWriter
implements ILicenseFormatWriter {
    private File textFolder;
    private Charset utf8 = Charset.forName("UTF-8");

    public LicenseTextFormatWriter(File textFolder) {
        this.textFolder = textFolder;
    }

    public File getTextFolder() {
        return this.textFolder;
    }

    public void setTextFolder(File textFolder) {
        this.textFolder = textFolder;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException {
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        if (deprecated) {
            licBaseHtmlFileName = "deprecated_" + licBaseHtmlFileName;
        }
        Path textFilePath = Paths.get(this.textFolder.getPath(), licBaseHtmlFileName + ".txt");
        Files.write(textFilePath, Arrays.asList(license.getLicenseText().split("\\n")), this.utf8, new OpenOption[0]);
    }

    @Override
    public void writeToC() throws IOException {
    }

    @Override
    public void writeException(LicenseException exception, boolean deprecated, String deprecatedVersion) throws IOException {
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        Path textFilePath = Paths.get(this.textFolder.getPath(), exceptionHtmlFileName + ".txt");
        Files.write(textFilePath, Arrays.asList(exception.getLicenseExceptionText().split("\\n")), this.utf8, new OpenOption[0]);
    }
}

