/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileCommentSheet
extends AbstractFileCompareSheet {
    private static final int FILE_COMMENT_COL_WIDTH = 60;

    public FileCommentSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        if (spdxFile.getComment() == null) {
            return "";
        }
        return spdxFile.getComment();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringsEqual(fileA.getComment(), fileB.getComment());
    }
}

